/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.widget.stateview;

import android.support.annotation.NonNull;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.baselibrary.widget.stateview.SwitchStatusLayoutManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StatusLayoutManager {
    private static volatile StatusLayoutManager instance;
    private View mContentLayout;
    private Object mTarget;
    private ViewGroup mParentLayout;
    private LayoutInflater mInflater;
    private SparseIntArray mStatusViewMap;
    private SparseArray<View> mStatusViews;
    private SparseArray<View.OnClickListener> mClickListeners;
    private ViewGroup.LayoutParams mLayoutParams;

    public StatusLayoutManager(Builder builder) {
        this.mStatusViewMap = builder.mStatusViewMap;
        this.mClickListeners = builder.mClickListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusLayoutManager getInstance(Builder builder) {
        if (instance != null) return instance;
        Class<StatusLayoutManager> clazz = StatusLayoutManager.class;
        synchronized (StatusLayoutManager.class) {
            if (instance != null) return instance;
            instance = new StatusLayoutManager(builder);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static StatusLayoutManager getInstance() {
        if (instance == null) {
            throw new IllegalArgumentException("You must use commit method first before use getInstance without builder");
        }
        return instance;
    }

    public SwitchStatusLayoutManager regist(Object target) {
        this.mTarget = target;
        return new SwitchStatusLayoutManager(this);
    }

    public View getContentLayout() {
        return this.mContentLayout;
    }

    public Object getTarget() {
        return this.mTarget;
    }

    public ViewGroup getParentLayout() {
        return this.mParentLayout;
    }

    public LayoutInflater getInflater() {
        return this.mInflater;
    }

    public SparseIntArray getStatusViewMap() {
        return this.mStatusViewMap;
    }

    public SparseArray<View> gemStatusViews() {
        return this.mStatusViews;
    }

    public SparseArray<View.OnClickListener> getClickListeners() {
        return this.mClickListeners;
    }

    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mLayoutParams;
    }

    public static class Builder {
        public SparseIntArray mStatusViewMap;
        public SparseArray<View.OnClickListener> mClickListeners;

        public Builder setErrorView(int layoutId) {
            return this.setStatusView(2, layoutId);
        }

        public Builder setLoadingView(int layoutId) {
            return this.setStatusView(1, layoutId);
        }

        public Builder setNoNetWorkView(int layoutId) {
            return this.setStatusView(4, layoutId);
        }

        public Builder setEmptyView(int layoutId) {
            return this.setStatusView(3, layoutId);
        }

        private Builder setStatusView(int status, int layoutId) {
            if (this.mStatusViewMap == null) {
                this.mStatusViewMap = new SparseIntArray();
            }
            this.mStatusViewMap.put(status, layoutId);
            return this;
        }

        public Builder addNoNetWorkClickListener(View.OnClickListener clickListener) {
            return this.addOnClickListener(4, clickListener);
        }

        public Builder addEmptyClickListener(View.OnClickListener clickListener) {
            return this.addOnClickListener(3, clickListener);
        }

        public Builder addErrorClickListener(View.OnClickListener statusClickListener) {
            return this.addOnClickListener(2, statusClickListener);
        }

        public Builder addOnClickListener(int status, View.OnClickListener statusClickListener) {
            if (this.mClickListeners == null) {
                this.mClickListeners = new SparseArray();
            }
            this.mClickListeners.put(status, (Object)statusClickListener);
            return this;
        }

        public SwitchStatusLayoutManager create(@NonNull Object target) {
            StatusLayoutManager multiStatusLayoutManager = new StatusLayoutManager(this);
            return multiStatusLayoutManager.regist(target);
        }

        public void commit() {
            StatusLayoutManager.getInstance(this);
        }
    }

    public static interface Status {
        public static final int CONTENT_TYPE = 0;
        public static final int LOADING_TYPE = 1;
        public static final int ERROR_TYPE = 2;
        public static final int EMPTY_TYPE = 3;
        public static final int NO_NETWORK_TYPE = 4;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StatusType {
        }
    }

    private static class SingletonHolder {
        private static final StatusLayoutManager INSTANCE = new StatusLayoutManager(null);

        private SingletonHolder() {
        }
    }
}

