/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetDialog;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.Toast;
import com.orhanobut.logger.Logger;
import com.trello.lifecycle2.android.lifecycle.AndroidLifecycle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.trello.rxlifecycle2.components.support.RxFragment;
import com.xdja.baselibrary.R;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.base.bottommenu.BottomMenuDialogAdapter;
import com.xdja.baselibrary.exception.MomentsBaseException;
import com.xdja.baselibrary.widget.dialog.MomentsAlertDialog;
import com.xdja.baselibrary.widget.dialog.MomentsProgressDialog;
import com.xdja.baselibrary.widget.stateview.StatusLayoutManager;
import com.xdja.baselibrary.widget.stateview.SwitchStatusLayoutManager;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public abstract class BaseFragment
extends RxFragment
implements IBaseView {
    protected MomentsAlertDialog alertDialog;
    private MomentsProgressDialog progressDialog = null;
    private SwitchStatusLayoutManager mStatusLayout;
    private BottomSheetDialog mBottomSheetDialog;
    private BottomMenuDialogAdapter mBottomMenuDialogAdapter;
    private List<BottomMenuBean> mBottomMenuBeanList = new ArrayList<BottomMenuBean>();
    private LoadingType onceLoadingType = LoadingType.LOAD_TYPE_NONE;
    protected LifecycleProvider<Lifecycle.Event> provider;
    private DialogInterface.OnCancelListener cancelListener = dialog -> this.dismissProgressDialog();

    @LayoutRes
    protected abstract int getRootView();

    protected abstract void initView(View var1, LayoutInflater var2);

    protected abstract void initData(LifecycleProvider<Lifecycle.Event> var1);

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    protected void showAlertDialog(String leftText, String rightText, String msg, View.OnClickListener leftListenter, View.OnClickListener rightListener) {
        this.showAlertDialog(leftText, rightText, msg, leftListenter, rightListener, true, true);
    }

    protected void showAlertDialog(String rightText, String msg, View.OnClickListener rightListener) {
        this.showAlertDialog(rightText, msg, rightListener, true, true);
    }

    protected void showAlertDialog(String rightText, String msg, View.OnClickListener rightListener, boolean cancelTouch, boolean cancelAble) {
        if (null == this.alertDialog) {
            this.alertDialog = new MomentsAlertDialog();
        }
        this.alertDialog.show((Context)this.getActivity(), rightText, msg, rightListener, cancelTouch, cancelAble);
    }

    protected void showAlertDialog(String leftText, String rightText, String msg, View.OnClickListener leftListenter, View.OnClickListener rightListener, boolean cancelTouch, boolean cancelAble) {
        if (null == this.alertDialog) {
            this.alertDialog = new MomentsAlertDialog();
        }
        this.alertDialog.show((Context)this.getActivity(), leftText, rightText, msg, leftListenter, rightListener, cancelTouch, cancelAble);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View rootView = inflater.inflate(this.getRootView(), container, false);
        this.initView(rootView, inflater);
        this.initErrorLayout();
        this.initBottomDialog(this.initBottomMenuDialog());
        if (this.initEventBus()) {
            EventBus.getDefault().register((Object)this);
        }
        this.initData(this.provider);
        return rootView;
    }

    private void initErrorLayout() {
        StatusLayoutManager.Builder builder = new StatusLayoutManager.Builder();
        builder.addErrorClickListener(view -> this.onErrorLayoutClick());
        builder.addEmptyClickListener(view -> this.onEmptyLayoutClick());
        builder.addNoNetWorkClickListener(view -> this.onNoNetLayoutClick());
        if (this.getErrorParentView() != null) {
            this.mStatusLayout = new StatusLayoutManager(builder).regist(this.getErrorParentView());
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initProvider();
    }

    protected LoadingType getLoadingType() {
        return LoadingType.LOAD_TYPE_NONE;
    }

    protected BottomDialogType initBottomMenuDialog() {
        return BottomDialogType.BOTTOM_TYPE_NONE;
    }

    private void initProvider() {
        this.provider = AndroidLifecycle.createLifecycleProvider((LifecycleOwner)this);
    }

    private LoadingType getRealLoadingType() {
        if (this.onceLoadingType == LoadingType.LOAD_TYPE_NONE) {
            return this.getLoadingType();
        }
        return this.onceLoadingType;
    }

    @Override
    public void showLoading(String msg, String key) {
        switch (this.getRealLoadingType()) {
            case LOAD_TYPE_NONE: {
                Logger.d((Object)"show none loading");
                break;
            }
            case LOAD_TYPE_COVER: {
                Logger.d((Object)"show cover loading");
                this.showLoadingLayout(msg);
                break;
            }
            case LOAD_TYPE_DIALOG: {
                Logger.d((Object)"show progressDialog loading");
                this.showProgressDialog(msg);
                break;
            }
            default: {
                Logger.d((Object)"show none loading");
            }
        }
    }

    @Override
    public void hideLoading(String key) {
        switch (this.getRealLoadingType()) {
            case LOAD_TYPE_NONE: {
                Logger.d((Object)"hide none loading");
                break;
            }
            case LOAD_TYPE_COVER: {
                Logger.d((Object)"hide cover loading");
                this.hideLoadingLayout();
                break;
            }
            case LOAD_TYPE_DIALOG: {
                Logger.d((Object)"hide progressDialog loading");
                this.dismissProgressDialog();
                break;
            }
            default: {
                Logger.d((Object)"hideLoading");
            }
        }
        this.onceLoadingType = LoadingType.LOAD_TYPE_NONE;
    }

    @Override
    public void showError(MomentsBaseException ex) {
        this.hideLoadingLayout();
        this.dismissProgressDialog();
        if (ex.keyPath.equals("DEFAULT")) {
            this.showContentError(ex);
        } else {
            this.showSubmitError(ex);
        }
    }

    protected void showSubmitError(MomentsBaseException ex) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)ex.errorMessage, (int)0).show();
    }

    private void showContentError(MomentsBaseException ex) {
        switch (ex.code) {
            case 1002: 
            case 1003: 
            case 1004: {
                this.showNoNetLayout(ex.errorMessage);
                break;
            }
            default: {
                this.showErrorLayout(ex.errorMessage);
            }
        }
    }

    protected void setOnceLoadingType(LoadingType loadingType) {
        this.onceLoadingType = loadingType;
    }

    protected void showProgressDialog(String msg) {
        if (this.progressDialog == null) {
            this.progressDialog = new MomentsProgressDialog();
        }
        this.progressDialog.show((Context)this.getActivity(), msg, this.cancelListener);
    }

    public void showProgressDialog(String msg, boolean cancelable) {
        if (this.progressDialog == null) {
            this.progressDialog = new MomentsProgressDialog();
        }
        this.progressDialog.show((Context)this.getActivity(), msg, cancelable, cancelable, this.cancelListener);
    }

    public void dismissAlertDialog() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.showContentView();
        }
        if (this.alertDialog != null) {
            this.alertDialog.dismiss();
            this.alertDialog = null;
        }
    }

    public void dismissProgressDialog() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
            this.progressDialog = null;
        }
    }

    protected void showLoadingLayout() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.showLoadingView();
        }
    }

    protected void showLoadingLayout(String loadingText) {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.showLoadingView(loadingText);
        }
    }

    protected void showNoNetLayout(String netErrorText) {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.showNoNetWorkView(netErrorText);
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)netErrorText, (int)0).show();
        }
    }

    protected void showEmptyLayout(String emptyText) {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.showEmptyView(emptyText);
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)emptyText, (int)0).show();
        }
    }

    protected void showErrorLayout(String errorInfo) {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.showErrorView(errorInfo);
        } else {
            Toast.makeText((Context)this.getActivity(), (CharSequence)errorInfo, (int)0).show();
        }
    }

    protected void hideLoadingLayout() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.hideStatusView(1);
            this.mStatusLayout.showContentView();
        }
    }

    protected void hideNoNetLayout() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.hideStatusView(4);
            this.mStatusLayout.showContentView();
        }
    }

    protected void hideEmptyLayout() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.hideStatusView(3);
            this.mStatusLayout.showContentView();
        }
    }

    protected void hideErrorLayout() {
        if (this.mStatusLayout != null) {
            this.mStatusLayout.hideStatusView(2);
            this.mStatusLayout.showContentView();
        }
    }

    protected void onErrorLayoutClick() {
        this.hideErrorLayout();
        this.initData(this.provider);
    }

    protected void onNoNetLayoutClick() {
        this.hideNoNetLayout();
        this.initData(this.provider);
    }

    protected void onEmptyLayoutClick() {
        this.hideEmptyLayout();
        this.initData(this.provider);
    }

    protected ViewGroup getErrorParentView() {
        return null;
    }

    private void initBottomDialog(BottomDialogType type) {
        if (type == BottomDialogType.BOTTOM_TYPE_NONE) {
            return;
        }
        this.mBottomSheetDialog = new BottomSheetDialog((Context)this.getActivity());
        LayoutInflater inflater = (LayoutInflater)this.getActivity().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.moments_bottom_menu_dialog, null);
        RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.recycleView);
        if (BottomDialogType.BOTTOM_TYPE_LIST == type) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        } else if (BottomDialogType.BOTTOM_TYPE_GIRD == type) {
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.getActivity(), 4));
        }
        this.mBottomMenuDialogAdapter = new BottomMenuDialogAdapter(recyclerView, this.mBottomMenuBeanList, this.getContext(), type);
        this.mBottomMenuDialogAdapter.setOnItemClickListener((v, position) -> this.onBottomMenuItemClick(this.mBottomMenuBeanList.get(position)));
        recyclerView.setAdapter((RecyclerView.Adapter)this.mBottomMenuDialogAdapter);
        this.mBottomSheetDialog.setCanceledOnTouchOutside(true);
        this.mBottomSheetDialog.setContentView(view);
    }

    protected void showBottomMenu(List<BottomMenuBean> bottomMenuBeanList) {
        if (this.mBottomSheetDialog == null) {
            throw new IllegalArgumentException("\nBottomMenuDialog\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initBottomMenuDialog()\u65b9\u6cd5\uff0c\u5e76\u8fd4\u56deTrue");
        }
        this.mBottomMenuBeanList.clear();
        this.mBottomMenuDialogAdapter.addAll(bottomMenuBeanList);
        this.mBottomSheetDialog.show();
    }

    protected void hideBottomMenu() {
        if (this.mBottomSheetDialog == null) {
            throw new IllegalArgumentException("\nBottomMenuDialog\u672a\u521d\u59cb\u5316\uff0c\u8bf7\u5148\u8c03\u7528initBottomMenuDialog()\u65b9\u6cd5\uff0c\u5e76\u8fd4\u56deTrue");
        }
        this.mBottomMenuBeanList.clear();
        this.mBottomSheetDialog.hide();
    }

    protected void onBottomMenuItemClick(BottomMenuBean menuBean) {
        Logger.d((Object)String.format("bottom menu : %s click ,you\u2018d better override onBottomMenuItemClick\uff08\uff09and remove super", menuBean.getItemName()));
    }

    protected boolean initEventBus() {
        return false;
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.initEventBus()) {
            EventBus.getDefault().unregister((Object)this);
        }
        if (this.mStatusLayout != null) {
            this.mStatusLayout.release();
        }
        if (this.mBottomSheetDialog != null) {
            this.mBottomSheetDialog.dismiss();
        }
    }

    @Override
    public void showToast(String msg) {
        Toast.makeText((Context)this.getActivity(), (CharSequence)msg, (int)0).show();
    }

    public void hideKeyboard(View v) {
        ((InputMethodManager)this.getActivity().getSystemService("input_method")).hideSoftInputFromWindow(v.getWindowToken(), 2);
    }

    public void hideKeyboard() {
        if (this.getActivity() == null) {
            return;
        }
        Window window = this.getActivity().getWindow();
        if (window != null) {
            this.hideKeyboard(window.getDecorView());
        }
    }

    public void showKeyboard(EditText et) {
        ((InputMethodManager)this.getActivity().getSystemService("input_method")).showSoftInput((View)et, 1);
    }

    public void hideInputSoft() {
        View currentFocus = this.getActivity().getCurrentFocus();
        if (currentFocus != null) {
            currentFocus.clearFocus();
            InputMethodManager inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (inputMethodManager != null) {
                inputMethodManager.hideSoftInputFromWindow(currentFocus.getWindowToken(), 0);
            }
        }
    }
}

