/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BaseRecyclerViewAdapter<T, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH> {
    protected List<T> dataLists;

    public BaseRecyclerViewAdapter() {
        this(new ArrayList());
    }

    public BaseRecyclerViewAdapter(@NonNull List<T> dataLists) {
        this.dataLists = dataLists;
    }

    public T getItem(int position) {
        return this.dataLists.get(position);
    }

    public List<T> getDataLists() {
        return this.dataLists;
    }

    public void setDataLists(List<T> datas) {
        this.dataLists.clear();
        if (datas != null && !datas.isEmpty()) {
            this.dataLists.addAll(datas);
        }
        this.notifyDataSetChanged();
    }

    public void add(T data) {
        this.dataLists.add(data);
        this.notifyDataSetChanged();
    }

    public void add(int position, T data) {
        this.dataLists.add(position, data);
        this.notifyDataSetChanged();
    }

    public void addAll(List<T> datas) {
        this.dataLists.addAll(datas);
        this.notifyDataSetChanged();
    }

    public void addAll(int position, List<T> datas) {
        this.dataLists.addAll(position, datas);
        this.notifyDataSetChanged();
    }

    public void remove(int position) {
        this.dataLists.remove(position);
        this.notifyDataSetChanged();
    }

    public void remove(T data) {
        this.dataLists.remove(data);
        this.notifyDataSetChanged();
    }

    public void replace(int location, T newData) {
        this.dataLists.set(location, newData);
        this.notifyDataSetChanged();
    }

    public void replace(T oldData, T newData) {
        this.replace((T)this.dataLists.indexOf(oldData), newData);
    }

    public void move(int fromPosition, int toPosition) {
        Collections.swap(this.dataLists, fromPosition, toPosition);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.dataLists.clear();
        this.notifyDataSetChanged();
    }
}

