/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter.decoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import java.util.HashMap;
import java.util.Map;

public class StickyHeaderDecoration
extends RecyclerView.ItemDecoration {
    public static final long NO_HEADER_ID = -1L;
    private Map<Long, RecyclerView.ViewHolder> mHeaderCache;
    private IStickyHeaderAdapter mAdapter;
    private boolean mRenderInline;
    private boolean mIncludeHeader = false;

    public StickyHeaderDecoration(IStickyHeaderAdapter adapter) {
        this(adapter, false);
    }

    public StickyHeaderDecoration(IStickyHeaderAdapter adapter, boolean renderInline) {
        this.mAdapter = adapter;
        this.mHeaderCache = new HashMap<Long, RecyclerView.ViewHolder>();
        this.mRenderInline = renderInline;
    }

    public void setIncludeHeader(boolean mIncludeHeader) {
        this.mIncludeHeader = mIncludeHeader;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        int headerHeight = 0;
        if (!this.mIncludeHeader && parent.getAdapter() instanceof XRecyclerViewAdapter) {
            int headerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getHeaderCount();
            int footerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getFooterCount();
            int dataCount = ((XRecyclerViewAdapter)parent.getAdapter()).getDataCount();
            if (position < headerCount) {
                return;
            }
            if (position >= headerCount + dataCount) {
                return;
            }
            if (position >= headerCount) {
                position -= headerCount;
            }
        }
        if (position != -1 && this.hasHeader(position) && this.showHeaderAboveItem(position)) {
            View header = this.getHeader((RecyclerView)parent, (int)position).itemView;
            headerHeight = this.getHeaderHeightForLayout(header);
        }
        outRect.set(0, headerHeight, 0, 0);
    }

    private boolean showHeaderAboveItem(int itemAdapterPosition) {
        if (itemAdapterPosition == 0) {
            return true;
        }
        return this.mAdapter.getHeaderId(itemAdapterPosition - 1) != this.mAdapter.getHeaderId(itemAdapterPosition);
    }

    public void clearHeaderCache() {
        this.mHeaderCache.clear();
    }

    public View findHeaderViewUnder(float x, float y) {
        for (RecyclerView.ViewHolder holder : this.mHeaderCache.values()) {
            View child = holder.itemView;
            float translationX = ViewCompat.getTranslationX((View)child);
            float translationY = ViewCompat.getTranslationY((View)child);
            if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
            return child;
        }
        return null;
    }

    private boolean hasHeader(int position) {
        return this.mAdapter.getHeaderId(position) != -1L;
    }

    private RecyclerView.ViewHolder getHeader(RecyclerView parent, int position) {
        long key = this.mAdapter.getHeaderId(position);
        if (this.mHeaderCache.containsKey(key)) {
            return this.mHeaderCache.get(key);
        }
        Object holder = this.mAdapter.onCreateHeaderViewHolder((ViewGroup)parent);
        View header = ((RecyclerView.ViewHolder)holder).itemView;
        this.mAdapter.onBindHeaderViewHolder(holder, position);
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getMeasuredWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getMeasuredHeight(), (int)0);
        int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)header.getLayoutParams().width);
        int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)header.getLayoutParams().height);
        header.measure(childWidth, childHeight);
        header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
        this.mHeaderCache.put(key, (RecyclerView.ViewHolder)holder);
        return holder;
    }

    public void onDrawOver(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        if (parent.getAdapter() == null) {
            return;
        }
        int count = parent.getChildCount();
        long previousHeaderId = -1L;
        for (int layoutPos = 0; layoutPos < count; ++layoutPos) {
            long headerId;
            View child = parent.getChildAt(layoutPos);
            int adapterPos = parent.getChildAdapterPosition(child);
            if (!this.mIncludeHeader && parent.getAdapter() instanceof XRecyclerViewAdapter) {
                int headerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getHeaderCount();
                int footerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getFooterCount();
                int dataCount = ((XRecyclerViewAdapter)parent.getAdapter()).getDataCount();
                if (adapterPos < headerCount || adapterPos >= headerCount + dataCount) continue;
                if (adapterPos >= headerCount) {
                    adapterPos -= headerCount;
                }
            }
            if (adapterPos == -1 || !this.hasHeader(adapterPos) || (headerId = this.mAdapter.getHeaderId(adapterPos)) == previousHeaderId) continue;
            previousHeaderId = headerId;
            View header = this.getHeader((RecyclerView)parent, (int)adapterPos).itemView;
            canvas.save();
            int left = child.getLeft();
            int top = this.getHeaderTop(parent, child, header, adapterPos, layoutPos);
            canvas.translate((float)left, (float)top);
            header.setTranslationX((float)left);
            header.setTranslationY((float)top);
            header.draw(canvas);
            canvas.restore();
        }
    }

    private int getHeaderTop(RecyclerView parent, View child, View header, int adapterPos, int layoutPos) {
        int headerHeight = this.getHeaderHeightForLayout(header);
        int top = (int)child.getY() - headerHeight;
        if (layoutPos == 0) {
            int count = parent.getChildCount();
            long currentId = this.mAdapter.getHeaderId(adapterPos);
            for (int i = 1; i < count; ++i) {
                long nextId;
                int adapterPosHere = parent.getChildAdapterPosition(parent.getChildAt(i));
                if (adapterPosHere == -1 || (nextId = this.mAdapter.getHeaderId(adapterPosHere)) == currentId) continue;
                View next = parent.getChildAt(i);
                int offset = (int)next.getY() - (headerHeight + this.getHeader((RecyclerView)parent, (int)adapterPosHere).itemView.getHeight());
                if (offset >= 0) break;
                return offset;
            }
            top = Math.max(0, top);
        }
        return top;
    }

    private int getHeaderHeightForLayout(View header) {
        return this.mRenderInline ? 0 : header.getHeight();
    }

    public static interface IStickyHeaderAdapter<T extends RecyclerView.ViewHolder> {
        public long getHeaderId(int var1);

        public T onCreateHeaderViewHolder(ViewGroup var1);

        public void onBindHeaderViewHolder(T var1, int var2);
    }
}

