/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.bottommenu;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextPaint;
import android.view.ViewGroup;
import com.xdja.baselibrary.R;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.XViewHolder;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.util.DensityUtil;
import java.util.List;

public class BottomMenuDialogAdapter
extends XRecyclerViewAdapter<BottomMenuBean> {
    private String maxLengthTitle = "";
    private int maxTextWidth = 0;
    private Context context;
    private BottomDialogType type;

    public BottomMenuDialogAdapter(@NonNull RecyclerView mRecyclerView, List<BottomMenuBean> dataLists, Context context, BottomDialogType type) {
        super(mRecyclerView, dataLists, type == BottomDialogType.BOTTOM_TYPE_LIST ? R.layout.moments_item_bottom_dialog : R.layout.moments_item_bottom_gird_dialog);
        this.context = context;
        this.type = type;
    }

    @Override
    public void addAll(List<BottomMenuBean> datas) {
        if (this.type == BottomDialogType.BOTTOM_TYPE_LIST) {
            this.maxTextWidth = 0;
            this.maxLengthTitle = "";
            for (BottomMenuBean dataList : datas) {
                if (this.maxLengthTitle.length() >= dataList.getItemName().length()) continue;
                this.maxLengthTitle = dataList.getItemName();
            }
            TextPaint textPaint = new TextPaint();
            textPaint.setTextSize((float)DensityUtil.dip2px(this.context, 16.0f));
            Rect rect = new Rect();
            textPaint.getTextBounds(this.maxLengthTitle, 0, this.maxLengthTitle.length(), rect);
            this.maxTextWidth = rect.width() + DensityUtil.dip2px(this.context, 15.0f);
        }
        super.addAll(datas);
    }

    @Override
    protected void bindData(XViewHolder holder, BottomMenuBean data, int position) {
        holder.setImageResource(R.id.tv_image, data.getItemResources());
        holder.setText(R.id.tv_name, data.getItemName());
        if (this.type == BottomDialogType.BOTTOM_TYPE_LIST) {
            Object view = holder.getView(R.id.tv_name);
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            layoutParams.width = this.maxTextWidth;
            view.setLayoutParams(layoutParams);
        }
    }
}

