/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.exception;

import com.google.gson.JsonParseException;
import com.xdja.baselibrary.exception.MomentsBaseException;
import com.xdja.baselibrary.exception.ServerException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import org.json.JSONException;
import retrofit2.HttpException;

public class ExceptionEngine {
    private static final int UNAUTHORIZED = 401;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;
    private static final int REQUEST_TIMEOUT = 408;
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int BAD_GATEWAY = 502;
    private static final int SERVICE_UNAVAILABLE = 503;
    private static final int GATEWAY_TIMEOUT = 504;

    public static MomentsBaseException handleException(Throwable e) {
        if (e instanceof HttpException) {
            HttpException httpException = (HttpException)e;
            MomentsBaseException ex = new MomentsBaseException(e, 1003);
            switch (httpException.code()) {
                default: 
            }
            ex.errorMessage = "\u7f51\u7edc\u8fde\u63a5\u9519\u8bef";
            return ex;
        }
        if (e instanceof ServerException) {
            ServerException resultException = (ServerException)e;
            MomentsBaseException ex = new MomentsBaseException(resultException, resultException.code);
            switch (resultException.code) {
                case 10000: {
                    ex.errorMessage = "\u8be5\u5206\u7c7b\u5df2\u7ecf\u88ab\u5220\u9664";
                    break;
                }
                case 10003: {
                    ex.errorMessage = "\u6ca1\u6709\u8be5\u5206\u7c7b\u8bc4\u8bba\u6743\u9650";
                    break;
                }
                case 10004: {
                    ex.errorMessage = "\u6ca1\u6709\u8be5\u5206\u7c7b\u5ba1\u6838\u6743\u9650";
                    break;
                }
                case 10005: {
                    ex.errorMessage = "\u6ca1\u6709\u8be5\u5206\u7c7b\u70b9\u8d5e\u6743\u9650";
                    break;
                }
                case 10002: {
                    ex.errorMessage = "\u6ca1\u6709\u8be5\u5206\u7c7b\u67e5\u770b\u6743\u9650";
                    break;
                }
                case 10001: {
                    ex.errorMessage = "\u6ca1\u6709\u8be5\u5206\u7c7b\u53d1\u5e03\u6743\u9650";
                    break;
                }
                case 20003: {
                    ex.errorMessage = "\u8be5\u52a8\u6001\u5df2\u7ecf\u88ab\u5220\u9664";
                    break;
                }
                case 20002: {
                    ex.errorMessage = "\u8be5\u52a8\u6001\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u5ba1\u6838\u62d2\u7edd";
                    break;
                }
                case 20001: {
                    ex.errorMessage = "\u8be5\u52a8\u6001\u5df2\u7ecf\u88ab\u5176\u4ed6\u4eba\u5ba1\u6838\u901a\u8fc7";
                    break;
                }
                case 20000: {
                    ex.errorMessage = "\u8be5\u52a8\u6001\u5df2\u7ecf\u4e0d\u5b58\u5728\u4e86";
                    break;
                }
                case 2000: {
                    ex.errorMessage = "\u8fd4\u56de\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
                    break;
                }
                default: {
                    ex.errorMessage = resultException.message;
                }
            }
            return ex;
        }
        if (e instanceof JsonParseException || e instanceof JSONException || e instanceof ParseException) {
            MomentsBaseException ex = new MomentsBaseException(e, 1001);
            ex.errorMessage = "\u6570\u636e\u89e3\u6790\u5f02\u5e38";
            return ex;
        }
        if (e instanceof ConnectException) {
            MomentsBaseException ex = new MomentsBaseException(e, 1002);
            ex.errorMessage = "\u4e0e\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\u5931\u8d25";
            return ex;
        }
        if (e instanceof SocketTimeoutException) {
            MomentsBaseException ex = new MomentsBaseException(e, 1004);
            ex.errorMessage = "\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6";
            return ex;
        }
        MomentsBaseException ex = new MomentsBaseException(e, 1000);
        ex.errorMessage = "\u672a\u77e5\u9519\u8bef";
        return ex;
    }
}

