/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.widget.dialog;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.text.method.ScrollingMovementMethod;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.xdja.baselibrary.R;

public class MomentsAlertDialog {
    private Dialog dialog = null;

    public void show(Context context, String leftBtnText, String rightBtnText, String msg, View.OnClickListener left, View.OnClickListener right) {
        this.show(context, leftBtnText, rightBtnText, msg, left, right, true, true);
    }

    public void show(Context context, String leftBtnText, String rightBtnText, String msg, View.OnClickListener left, View.OnClickListener right, boolean cancelOnTouchOutside, boolean cancelable) {
        if (this.dialog == null) {
            this.dialog = new AlertDialog.Builder(context).create();
        }
        this.dialog.setCanceledOnTouchOutside(cancelOnTouchOutside);
        this.dialog.setCancelable(cancelable);
        if (context instanceof Activity) {
            this.dialog.setOwnerActivity((Activity)context);
        }
        this.dialog.setOnCancelListener(null);
        if (context instanceof Activity) {
            if (!((Activity)context).isFinishing()) {
                this.dialog.show();
            }
        } else {
            this.dialog.getWindow().setType(2003);
            this.dialog.show();
        }
        Window window = this.dialog.getWindow();
        window.setContentView(R.layout.moments_base_dialog_alert);
        window.addFlags(2);
        TextView leftBtn = (TextView)window.findViewById(R.id.dialog_left_btn);
        if (!TextUtils.isEmpty((CharSequence)leftBtnText)) {
            leftBtn.setText((CharSequence)leftBtnText);
            leftBtn.setVisibility(0);
        } else {
            leftBtn.setVisibility(8);
        }
        TextView rightBtn = (TextView)window.findViewById(R.id.dialog_right_btn);
        if (!TextUtils.isEmpty((CharSequence)rightBtnText)) {
            rightBtn.setText((CharSequence)rightBtnText);
        }
        TextView message = (TextView)window.findViewById(R.id.dialog_message);
        message.setMovementMethod(ScrollingMovementMethod.getInstance());
        if (left != null) {
            leftBtn.setOnClickListener(left);
        }
        if (right != null) {
            rightBtn.setOnClickListener(right);
        }
        if (msg != null) {
            message.setText((CharSequence)msg);
            message.setVisibility(0);
        } else {
            message.setVisibility(8);
        }
    }

    public void show(Context context, String rightBtnText, String msg, View.OnClickListener right) {
        this.show(context, null, rightBtnText, msg, null, right, true, true);
    }

    public void show(Context context, String rightBtnText, String msg, View.OnClickListener right, boolean cancelOnTouchOutside, boolean cancelable) {
        this.show(context, null, rightBtnText, msg, null, right, cancelOnTouchOutside, cancelable);
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    public void dismiss() {
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
    }
}

