/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.CheckBox;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.xdja.baselibrary.util.GlideCircleTransform;

public class XViewHolder
extends RecyclerView.ViewHolder {
    private SparseArray<View> viewArray = new SparseArray();

    public XViewHolder(ViewGroup parent, @LayoutRes int resId) {
        super(LayoutInflater.from((Context)parent.getContext()).inflate(resId, parent, false));
    }

    public XViewHolder(View view) {
        super(view);
    }

    public <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.viewArray.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.viewArray.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public View getConvertView() {
        return this.itemView;
    }

    public XViewHolder setText(@IdRes int viewId, CharSequence text) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setText(text);
        return this;
    }

    public XViewHolder setCompoundDrawables(@IdRes int viewId, Drawable top, Drawable right, Drawable bottom, Drawable left) {
        TextView tv = (TextView)this.getView(viewId);
        tv.setCompoundDrawables(left, top, right, bottom);
        return this;
    }

    public XViewHolder setCheckListener(@IdRes int viewId, CompoundButton.OnCheckedChangeListener listener) {
        CheckBox checkBox = (CheckBox)this.getView(viewId);
        checkBox.setOnCheckedChangeListener(listener);
        return this;
    }

    public XViewHolder setImageResource(@IdRes int viewId, int resId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(resId);
        return this;
    }

    public XViewHolder setImageBitmap(@IdRes int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public XViewHolder setImageUrl(Context context, @IdRes int viewId, String url) {
        this.setImageUrl(context, viewId, url, 0);
        return this;
    }

    public XViewHolder setImageUrl(Context context, @IdRes int viewId, String url, @DrawableRes int errorimage) {
        this.setImageUrl(context, viewId, url, errorimage, false);
        return this;
    }

    public XViewHolder setImageUrl(Context context, @IdRes int viewId, String url, @DrawableRes int errorimage, boolean fitcenter) {
        this.setImageUrl(context, viewId, url, errorimage, fitcenter, false);
        return this;
    }

    public XViewHolder setImageUrl(Context context, @IdRes int viewId, String url, @DrawableRes int errorimage, boolean fitcenter, boolean cirlcetransForm) {
        ImageView view = (ImageView)this.getView(viewId);
        if (fitcenter) {
            if (cirlcetransForm) {
                Glide.with((Context)context).load(url).fitCenter().transform(new BitmapTransformation[]{new GlideCircleTransform(context)}).error(errorimage).placeholder(errorimage).diskCacheStrategy(DiskCacheStrategy.ALL).into(view);
            } else {
                Glide.with((Context)context).load(url).fitCenter().error(errorimage).placeholder(errorimage).diskCacheStrategy(DiskCacheStrategy.ALL).into(view);
            }
        } else if (cirlcetransForm) {
            Glide.with((Context)context).load(url).centerCrop().error(errorimage).transform(new BitmapTransformation[]{new GlideCircleTransform(context)}).placeholder(errorimage).diskCacheStrategy(DiskCacheStrategy.ALL).into(view);
        } else {
            Glide.with((Context)context).load(url).centerCrop().error(errorimage).placeholder(errorimage).diskCacheStrategy(DiskCacheStrategy.ALL).into(view);
        }
        return this;
    }

    public XViewHolder setImageDrawable(@IdRes int viewId, Drawable drawable2) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable2);
        return this;
    }

    public XViewHolder setBackgroundColor(@IdRes int viewId, int color) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color);
        return this;
    }

    public XViewHolder setBackgroundRes(@IdRes int viewId, int backgroundRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public XViewHolder setTextColor(@IdRes int viewId, int textColor) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    @SuppressLint(value={"NewApi"})
    public XViewHolder setAlpha(@IdRes int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.getView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.getView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public XViewHolder setVisible(@IdRes int viewId, int visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible);
        return this;
    }

    public XViewHolder setVisible(@IdRes int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public XViewHolder setInVisible(@IdRes int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 4);
        return this;
    }

    public XViewHolder linkify(@IdRes int viewId) {
        TextView view = (TextView)this.getView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public XViewHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public XViewHolder setProgress(@IdRes int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setProgress(progress);
        return this;
    }

    public XViewHolder setProgress(@IdRes int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public XViewHolder setMax(@IdRes int viewId, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        return this;
    }

    public XViewHolder setRating(@IdRes int viewId, float rating) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setRating(rating);
        return this;
    }

    public XViewHolder setRating(@IdRes int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    public XViewHolder setTag(@IdRes int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    public XViewHolder setTag(@IdRes int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public XViewHolder setChecked(@IdRes int viewId, boolean checked) {
        Checkable view = (Checkable)this.getView(viewId);
        view.setChecked(checked);
        return this;
    }

    public XViewHolder setOnCheckChangeListener(@IdRes int viewId, CompoundButton.OnCheckedChangeListener listener) {
        CompoundButton view = (CompoundButton)this.getView(viewId);
        view.setOnCheckedChangeListener(listener);
        return this;
    }

    public XViewHolder setOnClickListener(@IdRes int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public XViewHolder setOnTouchListener(@IdRes int viewId, View.OnTouchListener listener) {
        Object view = this.getView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    public XViewHolder setOnLongClickListener(@IdRes int viewId, View.OnLongClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }
}

