/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.base.adapter.decoration;

import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;

public class SpaceDecoration
extends RecyclerView.ItemDecoration {
    private int space;
    private int headerCount = -1;
    private int footerCount = Integer.MAX_VALUE;
    private boolean mPaddingEdgeSide = true;
    private boolean mPaddingStart = true;
    private boolean mPaddingHeaderFooter = false;

    public SpaceDecoration(int space) {
        this.space = space;
    }

    public void setPaddingEdgeSide(boolean mPaddingEdgeSide) {
        this.mPaddingEdgeSide = mPaddingEdgeSide;
    }

    public void setPaddingStart(boolean mPaddingStart) {
        this.mPaddingStart = mPaddingStart;
    }

    public void setPaddingHeaderFooter(boolean mPaddingHeaderFooter) {
        this.mPaddingHeaderFooter = mPaddingHeaderFooter;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager;
        int position = parent.getChildAdapterPosition(view);
        int spanCount = 0;
        int orientation = 0;
        int spanIndex = 0;
        int headerCount = 0;
        int footerCount = 0;
        if (parent.getAdapter() instanceof XRecyclerViewAdapter) {
            headerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getHeaderCount();
            footerCount = ((XRecyclerViewAdapter)parent.getAdapter()).getFooterCount();
        }
        if ((layoutManager = parent.getLayoutManager()) instanceof StaggeredGridLayoutManager) {
            orientation = ((StaggeredGridLayoutManager)layoutManager).getOrientation();
            spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
            spanIndex = ((StaggeredGridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex();
        } else if (layoutManager instanceof GridLayoutManager) {
            orientation = ((GridLayoutManager)layoutManager).getOrientation();
            spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
            spanIndex = ((GridLayoutManager.LayoutParams)view.getLayoutParams()).getSpanIndex();
        } else if (layoutManager instanceof LinearLayoutManager) {
            orientation = ((LinearLayoutManager)layoutManager).getOrientation();
            spanCount = 1;
            spanIndex = 0;
        }
        if (position >= headerCount && position < parent.getAdapter().getItemCount() - footerCount) {
            if (orientation == 1) {
                float expectedWidth = (float)(parent.getWidth() - this.space * (spanCount + (this.mPaddingEdgeSide ? 1 : -1))) / (float)spanCount;
                float originWidth = (float)parent.getWidth() / (float)spanCount;
                float expectedX = (float)(this.mPaddingEdgeSide ? this.space : 0) + (expectedWidth + (float)this.space) * (float)spanIndex;
                float originX = originWidth * (float)spanIndex;
                outRect.left = (int)(expectedX - originX);
                outRect.right = (int)(originWidth - (float)outRect.left - expectedWidth);
                if (position - headerCount < spanCount && this.mPaddingStart) {
                    outRect.top = this.space;
                }
                outRect.bottom = this.space;
                return;
            }
            float expectedHeight = (float)(parent.getHeight() - this.space * (spanCount + (this.mPaddingEdgeSide ? 1 : -1))) / (float)spanCount;
            float originHeight = (float)parent.getHeight() / (float)spanCount;
            float expectedY = (float)(this.mPaddingEdgeSide ? this.space : 0) + (expectedHeight + (float)this.space) * (float)spanIndex;
            float originY = originHeight * (float)spanIndex;
            outRect.bottom = (int)(expectedY - originY);
            outRect.top = (int)(originHeight - (float)outRect.bottom - expectedHeight);
            if (position - headerCount < spanCount && this.mPaddingStart) {
                outRect.left = this.space;
            }
            outRect.right = this.space;
            return;
        }
        if (this.mPaddingHeaderFooter) {
            if (orientation == 1) {
                outRect.left = this.mPaddingEdgeSide ? this.space : 0;
                outRect.right = outRect.left;
                outRect.top = this.mPaddingStart ? this.space : 0;
            } else {
                outRect.bottom = this.mPaddingEdgeSide ? this.space : 0;
                outRect.top = outRect.bottom;
                outRect.left = this.mPaddingStart ? this.space : 0;
            }
        }
    }
}

