/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.util;

import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static String regex = "(((http://)|(https://))?([a-z0-9]+[.])|(www.))([a-z0-9])+([.]([a-z0-9]{1,4}))*(:[0-9]{1,5})?((/[\\S&&[^,;\u4e00-\u9fa5]]+)+)?";
    private static String A1 = "<a target=\"_bank\" href={0}>";
    private static String A2 = "</a>";
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] APOS_ENCODE = "&apos;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEquals(Object actual, Object expected) {
        return actual == expected || (actual == null ? expected == null : actual.equals(expected));
    }

    public static String nullStrToEmpty(String str) {
        return str == null ? "" : str;
    }

    public static String capitalizeFirstLetter(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char c = str.charAt(0);
        return !Character.isLetter(c) || Character.isUpperCase(c) ? str : new StringBuilder(str.length()).append(Character.toUpperCase(c)).append(str.substring(1)).toString();
    }

    public static String utf8Encode(String str) {
        if (!StringUtils.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UnsupportedEncodingException occurred. ", e);
            }
        }
        return str;
    }

    public static String utf8Encode(String str, String defultReturn) {
        if (!StringUtils.isEmpty(str) && str.getBytes().length != str.length()) {
            try {
                return URLEncoder.encode(str, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return defultReturn;
            }
        }
        return str;
    }

    public static String getHrefInnerHtml(String href) {
        if (StringUtils.isEmpty(href)) {
            return "";
        }
        String hrefReg = ".*<[\\s]*a[\\s]*.*>(.+?)<[\\s]*/a[\\s]*>.*";
        Pattern hrefPattern = Pattern.compile(hrefReg, 2);
        Matcher hrefMatcher = hrefPattern.matcher(href);
        if (hrefMatcher.matches()) {
            return hrefMatcher.group(1);
        }
        return href;
    }

    public static String htmlEscapeCharsToString(String source) {
        return StringUtils.isEmpty(source) ? source : source.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
    }

    public static String fullWidthToHalfWidth(String s) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        char[] source = s.toCharArray();
        for (int i = 0; i < source.length; ++i) {
            source[i] = source[i] == '\u3000' ? 32 : (source[i] >= '\uff01' && source[i] <= '\uff5e' ? (char)(source[i] - 65248) : source[i]);
        }
        return new String(source);
    }

    public static String halfWidthToFullWidth(String s) {
        if (StringUtils.isEmpty(s)) {
            return s;
        }
        char[] source = s.toCharArray();
        for (int i = 0; i < source.length; ++i) {
            source[i] = source[i] == ' ' ? 12288 : (source[i] >= '!' && source[i] <= '~' ? (char)(source[i] + 65248) : source[i]);
        }
        return new String(source);
    }

    public static String toHref(String title) {
        if (TextUtils.isEmpty((CharSequence)title)) {
            return "";
        }
        StringBuffer sb = new StringBuffer(title);
        Pattern pat = Pattern.compile(regex, 2);
        Matcher mat = pat.matcher(title);
        int index = 0;
        int index1 = 0;
        while (mat.find()) {
            String url = mat.group();
            System.out.println(url);
            if (url.indexOf("http://") != 0) {
                url = "http://" + url;
            }
            Object[] obj = new Object[]{"'" + url + "'"};
            String a = MessageFormat.format(A1, obj);
            int l = a.length();
            sb.insert(mat.start() + (index += index1), a);
            sb.insert(mat.end() + (index += l), A2);
            index1 = A2.length();
        }
        return sb.toString();
    }

    public static String escapeForXML(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '>') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(GT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                if (len > i + 5 && input[i + 1] == '#' && Character.isDigit(input[i + 2]) && Character.isDigit(input[i + 3]) && Character.isDigit(input[i + 4]) && input[i + 5] == ';') continue;
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch == '\"') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(QUOTE_ENCODE);
                continue;
            }
            if (ch != '\'') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(APOS_ENCODE);
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }
}

