/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.util.swipefinsh.helper;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityOptions;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.xdja.baselibrary.util.swipefinsh.helper.DecelerateAnimator;
import com.xdja.baselibrary.util.swipefinsh.helper.ShadowView;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@RequiresApi(api=19)
public class SwipeBackHelper {
    private final Activity mSwipeBackActivity;
    private final ViewGroup mDecorView;
    private final int mTouchSlop;
    private final float mInterceptRect;
    private final boolean isStatusBarTransparent;
    private final int vertical = 1;
    private final int horizontal = 2;
    private final int mOrientation;
    private int mDragDirection;
    private View mShadowView;
    private ViewGroup mSwipeBackView;
    private VelocityTracker mVelocityTracker;
    private DecelerateAnimator mSwipeAnimator;
    private int mTouchPointerId;
    private float mStartX;
    private float mStartY;
    private boolean isAnimationCancel;
    private boolean isSwipeBackEnabled = true;
    private int mWindowBackgroundColor;
    private View mWindowBackGroundView;
    private Object mTranslucentConversionListener;
    private Class mTranslucentConversionListenerClass;
    private boolean isTranslucentComplete;
    private PrivateListener mPrivateListener = new PrivateListener();

    @SuppressLint(value={"NewApi"})
    public SwipeBackHelper(Activity activity) {
        this(activity, false);
    }

    @RequiresApi(api=23)
    public SwipeBackHelper(Activity activity, boolean darkStatusBar) {
        this.mSwipeBackActivity = activity;
        this.mOrientation = activity.getResources().getConfiguration().orientation;
        this.mDecorView = (ViewGroup)activity.getWindow().getDecorView();
        this.isStatusBarTransparent = this.setStatusBarTransparent(darkStatusBar);
        this.mTouchSlop = ViewConfiguration.get((Context)activity).getScaledTouchSlop();
        this.mInterceptRect = 18.0f * activity.getResources().getDisplayMetrics().density;
        this.convertFromTranslucent(this.mSwipeBackActivity);
    }

    private boolean setStatusBarTransparent(boolean darkStatusBar) {
        boolean isInMultiWindowMode;
        boolean bl = isInMultiWindowMode = Build.VERSION.SDK_INT >= 24 && this.mSwipeBackActivity.isInMultiWindowMode();
        if (isInMultiWindowMode || Build.VERSION.SDK_INT < 19) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.mSwipeBackActivity.getWindow().addFlags(0x4000000);
        } else {
            int systemUiVisibility = 1280;
            if (darkStatusBar && Build.VERSION.SDK_INT >= 23) {
                systemUiVisibility |= 0x2000;
            }
            this.mDecorView.setSystemUiVisibility(systemUiVisibility);
            this.mSwipeBackActivity.getWindow().clearFlags(0x4000000);
            this.mSwipeBackActivity.getWindow().addFlags(Integer.MIN_VALUE);
            this.mSwipeBackActivity.getWindow().setStatusBarColor(0);
        }
        this.mDecorView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mPrivateListener);
        if (Build.VERSION.SDK_INT < 23) {
            this.fixActionModeStatusBarAbnormal();
        }
        return true;
    }

    protected void fixActionModeStatusBarAbnormal() {
        ViewGroup contentParent = (ViewGroup)this.mSwipeBackActivity.findViewById(0x1020002).getParent();
        contentParent.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                ViewGroup contentParent = (ViewGroup)v;
                if (contentParent.getChildCount() > 2) {
                    contentParent.removeView(contentParent.getChildAt(2));
                }
            }
        });
    }

    public boolean isStatusBarTransparent() {
        return this.isStatusBarTransparent;
    }

    public ViewGroup getSwipeBackView(ViewGroup decorView) {
        if (this.mSwipeBackView == null) {
            this.mSwipeBackView = (ViewGroup)decorView.findViewById(0x1020002).getParent();
        }
        return this.mSwipeBackView;
    }

    public View getShadowView(ViewGroup swipeBackView) {
        if (this.mShadowView == null) {
            this.mShadowView = new ShadowView((Context)this.mSwipeBackActivity);
            this.mShadowView.setTranslationX((float)(-swipeBackView.getWidth()));
            ((ViewGroup)swipeBackView.getParent()).addView(this.mShadowView, 0, new ViewGroup.LayoutParams(-1, -1));
        }
        return this.mShadowView;
    }

    public View getWindowBackGroundView(ViewGroup decorView) {
        if (this.mWindowBackGroundView == null && this.mWindowBackgroundColor >>> 24 > 0) {
            this.mWindowBackGroundView = new View((Context)this.mSwipeBackActivity);
            this.mWindowBackGroundView.setTranslationY((float)decorView.getHeight());
            this.mWindowBackGroundView.setBackgroundColor(this.mWindowBackgroundColor);
            decorView.addView(this.mWindowBackGroundView, 0, new ViewGroup.LayoutParams(-1, -1));
            this.mDecorView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mPrivateListener);
        }
        return this.mWindowBackGroundView;
    }

    public void setWindowBackgroundColor(int color) {
        this.mWindowBackgroundColor = color;
        if (this.mWindowBackGroundView != null) {
            this.mWindowBackGroundView.setBackgroundColor(this.mWindowBackgroundColor);
        }
    }

    public void dispatchTouchEvent(MotionEvent event) {
        if (!this.isSwipeBackEnabled || this.mSwipeBackActivity.isTaskRoot()) {
            return;
        }
        this.mSwipeBackView = this.getSwipeBackView(this.mDecorView);
        this.mShadowView = this.getShadowView(this.mSwipeBackView);
        int actionIndex = event.getActionIndex();
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        block0 : switch (event.getActionMasked()) {
            case 0: {
                if (this.mSwipeAnimator != null && this.mSwipeAnimator.isStarted()) {
                    this.mDragDirection = 2;
                    this.mSwipeAnimator.cancel();
                    this.mStartX = event.getX(actionIndex) - this.mSwipeBackView.getTranslationX();
                    break;
                }
                this.mStartX = event.getX(actionIndex);
                this.mStartY = event.getY(actionIndex);
                this.mTouchPointerId = event.getPointerId(actionIndex);
                this.mDragDirection = 0;
                if (!(this.mStartX <= this.mInterceptRect)) break;
                this.convertToTranslucent(this.mSwipeBackActivity);
                break;
            }
            case 6: {
                if (event.getPointerId(actionIndex) != this.mTouchPointerId) break;
                this.mVelocityTracker.clear();
                for (int index = 0; index < event.getPointerCount(); ++index) {
                    if (index == actionIndex) continue;
                    this.mStartX = event.getX(index) - this.mSwipeBackView.getTranslationX();
                    this.mStartY = event.getY(index);
                    this.mTouchPointerId = event.getPointerId(index);
                    break block0;
                }
                break;
            }
            case 2: {
                for (int index = 0; index < event.getPointerCount(); ++index) {
                    if (event.getPointerId(index) != this.mTouchPointerId) continue;
                    if (this.mDragDirection == 2) {
                        int offsetX = (int)(event.getX(index) - this.mStartX);
                        if (offsetX < 0) {
                            offsetX = 0;
                            this.mStartX = event.getX(index);
                        } else if (offsetX > this.mShadowView.getWidth()) {
                            offsetX = this.mShadowView.getWidth();
                            this.mStartX = event.getX(index) - (float)offsetX;
                        }
                        this.swipeBackEvent(offsetX);
                        break block0;
                    }
                    if (this.mDragDirection != 0 || !(this.mStartX <= this.mInterceptRect)) break block0;
                    if (Math.abs(event.getX(index) - this.mStartX) >= (float)this.mTouchSlop * 0.8f) {
                        this.mStartX = event.getX(index);
                        this.mDragDirection = 2;
                        event.setAction(3);
                        this.HideInputSoft();
                        break block0;
                    }
                    if (!(Math.abs(event.getY(index) - this.mStartY) >= (float)this.mTouchSlop)) break block0;
                    this.mDragDirection = 1;
                    break block0;
                }
                break;
            }
            case 1: 
            case 3: {
                if (this.mDragDirection == 2) {
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float velocityX = this.mVelocityTracker.getXVelocity();
                    float offsetX = event.getX(actionIndex) - this.mStartX;
                    if (offsetX < 0.0f) {
                        offsetX = 0.0f;
                    } else if (offsetX > (float)this.mShadowView.getWidth()) {
                        offsetX = this.mShadowView.getWidth();
                    }
                    this.startSwipeAnimator(offsetX, 0.0f, this.mShadowView.getWidth(), velocityX);
                } else {
                    this.convertFromTranslucent(this.mSwipeBackActivity);
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                this.mDragDirection = 0;
            }
        }
    }

    public void onTouchEvent(MotionEvent event) {
        if (!this.isSwipeBackEnabled || this.mSwipeBackActivity.isTaskRoot()) {
            return;
        }
        block0 : switch (event.getActionMasked()) {
            case 0: {
                if (this.mDragDirection != 0 || !(this.mStartX > this.mInterceptRect)) break;
                this.convertToTranslucent(this.mSwipeBackActivity);
                break;
            }
            case 2: {
                if (this.mDragDirection != 0 || !(this.mStartX > this.mInterceptRect)) break;
                for (int index = 0; index < event.getPointerCount(); ++index) {
                    if (event.getPointerId(index) != this.mTouchPointerId) continue;
                    if (Math.abs(event.getY(index) - this.mStartY) >= (float)this.mTouchSlop) {
                        this.mDragDirection = 1;
                        break block0;
                    }
                    if (!(Math.abs(event.getX(index) - this.mStartX) >= (float)this.mTouchSlop)) break block0;
                    this.mStartX = event.getX(index);
                    this.mDragDirection = 2;
                    this.HideInputSoft();
                    break block0;
                }
                break;
            }
        }
    }

    private void convertToTranslucent(Activity activity) {
        block10: {
            if (activity.isTaskRoot()) {
                return;
            }
            this.isTranslucentComplete = false;
            try {
                if (this.mTranslucentConversionListenerClass == null) {
                    Class<?>[] clazzArray;
                    for (Class<?> clazz : clazzArray = Activity.class.getDeclaredClasses()) {
                        if (!clazz.getSimpleName().contains("TranslucentConversionListener")) continue;
                        this.mTranslucentConversionListenerClass = clazz;
                    }
                }
                if (this.mTranslucentConversionListener == null && this.mTranslucentConversionListenerClass != null) {
                    InvocationHandler invocationHandler = new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            SwipeBackHelper.this.isTranslucentComplete = true;
                            return null;
                        }
                    };
                    this.mTranslucentConversionListener = Proxy.newProxyInstance(this.mTranslucentConversionListenerClass.getClassLoader(), new Class[]{this.mTranslucentConversionListenerClass}, invocationHandler);
                }
                if (Build.VERSION.SDK_INT >= 21) {
                    Object options = null;
                    try {
                        Method getActivityOptions = Activity.class.getDeclaredMethod("getActivityOptions", new Class[0]);
                        getActivityOptions.setAccessible(true);
                        options = getActivityOptions.invoke((Object)this, new Object[0]);
                    }
                    catch (Exception getActivityOptions) {
                        // empty catch block
                    }
                    Method convertToTranslucent = Activity.class.getDeclaredMethod("convertToTranslucent", this.mTranslucentConversionListenerClass, ActivityOptions.class);
                    convertToTranslucent.setAccessible(true);
                    convertToTranslucent.invoke((Object)activity, this.mTranslucentConversionListener, options);
                    break block10;
                }
                Method convertToTranslucent = Activity.class.getDeclaredMethod("convertToTranslucent", this.mTranslucentConversionListenerClass);
                convertToTranslucent.setAccessible(true);
                convertToTranslucent.invoke((Object)activity, this.mTranslucentConversionListener);
            }
            catch (Throwable ignored) {
                this.isTranslucentComplete = true;
            }
        }
        if (this.mTranslucentConversionListener == null) {
            this.isTranslucentComplete = true;
        }
    }

    private void convertFromTranslucent(Activity activity) {
        if (activity.isTaskRoot()) {
            return;
        }
        try {
            Method convertFromTranslucent = Activity.class.getDeclaredMethod("convertFromTranslucent", new Class[0]);
            convertFromTranslucent.setAccessible(true);
            convertFromTranslucent.invoke((Object)activity, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setSwipeBackEnabled(boolean enabled) {
        this.isSwipeBackEnabled = enabled;
        if (!enabled) {
            this.mSwipeBackView.setTranslationX(0.0f);
            this.mShadowView.setTranslationX((float)(-this.mShadowView.getWidth()));
        }
    }

    @RequiresApi(api=23)
    public void toggleStatusBarColor(boolean darkStatusBar) {
        int systemUiVisibility = 1280;
        if (darkStatusBar) {
            systemUiVisibility |= 0x2000;
        }
        this.mDecorView.setSystemUiVisibility(systemUiVisibility);
    }

    public void HideInputSoft() {
        View view = this.mSwipeBackActivity.getCurrentFocus();
        if (view != null) {
            InputMethodManager inputMethodManager;
            if (view instanceof EditText) {
                view.clearFocus();
            }
            if ((inputMethodManager = (InputMethodManager)this.mSwipeBackActivity.getSystemService("input_method")) != null) {
                inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
    }

    private void startSwipeAnimator(float startValue, float minFinalValue, float maxFinalValue, float velocity) {
        if (maxFinalValue <= minFinalValue) {
            this.swipeBackEvent(0);
            this.convertFromTranslucent(this.mSwipeBackActivity);
            return;
        }
        if (this.mSwipeAnimator == null) {
            this.mSwipeAnimator = new DecelerateAnimator((Context)this.mSwipeBackActivity, false);
            this.mSwipeAnimator.addListener(this.mPrivateListener);
            this.mSwipeAnimator.addUpdateListener(this.mPrivateListener);
        }
        this.mSwipeAnimator.setFlingFrictionRatio(9.0f);
        if (this.mOrientation == 2) {
            this.mSwipeAnimator.startAnimator(startValue, minFinalValue, maxFinalValue, velocity * 8.0f);
        } else {
            this.mSwipeAnimator.startAnimator(startValue, minFinalValue, maxFinalValue, velocity * 4.0f);
        }
    }

    private void swipeBackEvent(int translation) {
        if (!this.isTranslucentComplete) {
            return;
        }
        if (this.mShadowView.getBackground() != null) {
            int alpha = (int)((1.0f - 1.0f * (float)translation / (float)this.mShadowView.getWidth()) * 255.0f);
            if (alpha < 0) {
                alpha = 0;
            } else if (alpha > 255) {
                alpha = 255;
            }
            this.mShadowView.getBackground().setAlpha(alpha);
        }
        this.mShadowView.setTranslationX((float)(translation - this.mShadowView.getWidth()));
        this.mSwipeBackView.setTranslationX((float)translation);
    }

    private class PrivateListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener,
    View.OnLayoutChangeListener {
        private PrivateListener() {
        }

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            Rect visibleDisplayRect = new Rect();
            SwipeBackHelper.this.mDecorView.getWindowVisibleDisplayFrame(visibleDisplayRect);
            SwipeBackHelper.this.mWindowBackGroundView = SwipeBackHelper.this.getWindowBackGroundView(SwipeBackHelper.this.mDecorView);
            if (SwipeBackHelper.this.mWindowBackGroundView != null) {
                SwipeBackHelper.this.mWindowBackGroundView.setTranslationY((float)visibleDisplayRect.bottom);
            }
            if (SwipeBackHelper.this.isStatusBarTransparent()) {
                for (int i = 0; i < SwipeBackHelper.this.mDecorView.getChildCount(); ++i) {
                    View child = SwipeBackHelper.this.mDecorView.getChildAt(i);
                    if (!(child instanceof ViewGroup)) continue;
                    ViewGroup.LayoutParams childLp = child.getLayoutParams();
                    int paddingBottom = bottom - visibleDisplayRect.bottom;
                    if (childLp instanceof ViewGroup.MarginLayoutParams) {
                        paddingBottom -= ((ViewGroup.MarginLayoutParams)childLp).bottomMargin;
                    }
                    if (paddingBottom < 0) {
                        paddingBottom = 0;
                    }
                    if (paddingBottom == child.getPaddingBottom()) break;
                    child.setPadding(child.getPaddingLeft(), child.getPaddingTop(), child.getPaddingRight(), paddingBottom);
                    break;
                }
            }
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            float translation = ((Float)animation.getAnimatedValue()).floatValue();
            SwipeBackHelper.this.swipeBackEvent((int)translation);
        }

        public void onAnimationEnd(Animator animation) {
            if (!SwipeBackHelper.this.isAnimationCancel) {
                if ((float)SwipeBackHelper.this.mShadowView.getWidth() + 2.0f * SwipeBackHelper.this.mShadowView.getTranslationX() >= 0.0f) {
                    SwipeBackHelper.this.mShadowView.setVisibility(8);
                    SwipeBackHelper.this.mSwipeBackActivity.finish();
                    SwipeBackHelper.this.mSwipeBackActivity.overridePendingTransition(-1, -1);
                } else {
                    SwipeBackHelper.this.mShadowView.setTranslationX((float)(-SwipeBackHelper.this.mShadowView.getWidth()));
                    SwipeBackHelper.this.mSwipeBackView.setTranslationX(0.0f);
                    SwipeBackHelper.this.convertFromTranslucent(SwipeBackHelper.this.mSwipeBackActivity);
                }
            }
        }

        public void onAnimationStart(Animator animation) {
            SwipeBackHelper.this.isAnimationCancel = false;
        }

        public void onAnimationCancel(Animator animation) {
            SwipeBackHelper.this.isAnimationCancel = true;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }
}

