/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.baselibrary.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.Checkable;
import com.xdja.baselibrary.R;

public class SmoothCheckBox
extends View
implements Checkable {
    private static final String KEY_INSTANCE_STATE = "InstanceState";
    private static final int COLOR_TICK = -1;
    private static final int COLOR_UNCHECKED = -1;
    private static final int COLOR_CHECKED = Color.parseColor((String)"#FB4846");
    private static final int COLOR_FLOOR_UNCHECKED = Color.parseColor((String)"#DFDFDF");
    private static final int DEF_DRAW_SIZE = 25;
    private static final int DEF_ANIM_DURATION = 300;
    private Paint mPaint;
    private Paint mTickPaint;
    private Paint mFloorPaint;
    private Point[] mTickPoints;
    private Point mCenterPoint;
    private Path mTickPath;
    private float mLeftLineDistance;
    private float mRightLineDistance;
    private float mDrewDistance;
    private float mScaleVal = 1.0f;
    private float mFloorScale = 1.0f;
    private int mWidth;
    private int mAnimDuration;
    private int mStrokeWidth;
    private int mCheckedColor;
    private int mUnCheckedColor;
    private int mFloorColor;
    private int mFloorUnCheckedColor;
    private boolean mChecked;
    private boolean mTickDrawing;
    private OnCheckedChangeListener mListener;

    public SmoothCheckBox(Context context) {
        this(context, null);
    }

    public SmoothCheckBox(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmoothCheckBox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public SmoothCheckBox(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.MomentsSmoothCheckBox);
        int tickColor = ta.getColor(R.styleable.MomentsSmoothCheckBox_moments_color_tick, -1);
        this.mAnimDuration = ta.getInt(R.styleable.MomentsSmoothCheckBox_moments_duration, 300);
        this.mFloorColor = ta.getColor(R.styleable.MomentsSmoothCheckBox_moments_color_unchecked_stroke, COLOR_FLOOR_UNCHECKED);
        this.mCheckedColor = ta.getColor(R.styleable.MomentsSmoothCheckBox_moments_color_checked, COLOR_CHECKED);
        this.mUnCheckedColor = ta.getColor(R.styleable.MomentsSmoothCheckBox_moments_color_unchecked, -1);
        this.mStrokeWidth = ta.getDimensionPixelSize(R.styleable.MomentsSmoothCheckBox_moments_stroke_width, this.dp2px(this.getContext(), 0.0f));
        ta.recycle();
        this.mFloorUnCheckedColor = this.mFloorColor;
        this.mTickPaint = new Paint(1);
        this.mTickPaint.setStyle(Paint.Style.STROKE);
        this.mTickPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mTickPaint.setColor(tickColor);
        this.mFloorPaint = new Paint(1);
        this.mFloorPaint.setStyle(Paint.Style.FILL);
        this.mFloorPaint.setColor(this.mFloorColor);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mCheckedColor);
        this.mTickPath = new Path();
        this.mCenterPoint = new Point();
        this.mTickPoints = new Point[3];
        this.mTickPoints[0] = new Point();
        this.mTickPoints[1] = new Point();
        this.mTickPoints[2] = new Point();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SmoothCheckBox.this.toggle();
                SmoothCheckBox.this.mTickDrawing = false;
                SmoothCheckBox.this.mDrewDistance = 0.0f;
                if (SmoothCheckBox.this.isChecked()) {
                    SmoothCheckBox.this.startCheckedAnimation();
                } else {
                    SmoothCheckBox.this.startUnCheckedAnimation();
                }
            }
        });
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putBoolean(KEY_INSTANCE_STATE, this.isChecked());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            boolean isChecked = bundle.getBoolean(KEY_INSTANCE_STATE);
            this.setChecked(isChecked);
            super.onRestoreInstanceState(bundle.getParcelable(KEY_INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.reset();
        this.invalidate();
        if (this.mListener != null) {
            this.mListener.onCheckedChanged(this, this.mChecked);
        }
    }

    public void setChecked(boolean checked, boolean animate) {
        if (animate) {
            this.mTickDrawing = false;
            this.mChecked = checked;
            this.mDrewDistance = 0.0f;
            if (checked) {
                this.startCheckedAnimation();
            } else {
                this.startUnCheckedAnimation();
            }
            if (this.mListener != null) {
                this.mListener.onCheckedChanged(this, this.mChecked);
            }
        } else {
            this.setChecked(checked);
        }
    }

    private void reset() {
        this.mTickDrawing = true;
        this.mFloorScale = 1.0f;
        this.mScaleVal = this.isChecked() ? 0.0f : 1.0f;
        this.mFloorColor = this.isChecked() ? this.mCheckedColor : this.mFloorUnCheckedColor;
        this.mDrewDistance = this.isChecked() ? this.mLeftLineDistance + this.mRightLineDistance : 0.0f;
    }

    private int measureSize(int measureSpec) {
        int defSize = this.dp2px(this.getContext(), 25.0f);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int result = 0;
        switch (specMode) {
            case -2147483648: 
            case 0: {
                result = Math.min(defSize, specSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureSize(widthMeasureSpec), this.measureSize(heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mWidth = this.getMeasuredWidth();
        this.mStrokeWidth = this.mStrokeWidth == 0 ? this.getMeasuredWidth() / 10 : this.mStrokeWidth;
        this.mStrokeWidth = this.mStrokeWidth > this.getMeasuredWidth() / 5 ? this.getMeasuredWidth() / 5 : this.mStrokeWidth;
        this.mStrokeWidth = this.mStrokeWidth < 3 ? 3 : this.mStrokeWidth;
        this.mCenterPoint.x = this.mWidth / 2;
        this.mCenterPoint.y = this.getMeasuredHeight() / 2;
        this.mTickPoints[0].x = Math.round((float)this.getMeasuredWidth() / 30.0f * 7.0f);
        this.mTickPoints[0].y = Math.round((float)this.getMeasuredHeight() / 30.0f * 14.0f);
        this.mTickPoints[1].x = Math.round((float)this.getMeasuredWidth() / 30.0f * 13.0f);
        this.mTickPoints[1].y = Math.round((float)this.getMeasuredHeight() / 30.0f * 20.0f);
        this.mTickPoints[2].x = Math.round((float)this.getMeasuredWidth() / 30.0f * 22.0f);
        this.mTickPoints[2].y = Math.round((float)this.getMeasuredHeight() / 30.0f * 10.0f);
        this.mLeftLineDistance = (float)Math.sqrt(Math.pow(this.mTickPoints[1].x - this.mTickPoints[0].x, 2.0) + Math.pow(this.mTickPoints[1].y - this.mTickPoints[0].y, 2.0));
        this.mRightLineDistance = (float)Math.sqrt(Math.pow(this.mTickPoints[2].x - this.mTickPoints[1].x, 2.0) + Math.pow(this.mTickPoints[2].y - this.mTickPoints[1].y, 2.0));
        this.mTickPaint.setStrokeWidth((float)this.mStrokeWidth);
    }

    protected void onDraw(Canvas canvas) {
        this.drawBorder(canvas);
        this.drawCenter(canvas);
        this.drawTick(canvas);
    }

    private void drawCenter(Canvas canvas) {
        this.mPaint.setColor(this.mUnCheckedColor);
        float radius = (float)(this.mCenterPoint.x - this.mStrokeWidth) * this.mScaleVal;
        canvas.drawCircle((float)this.mCenterPoint.x, (float)this.mCenterPoint.y, radius, this.mPaint);
    }

    private void drawBorder(Canvas canvas) {
        this.mFloorPaint.setColor(this.mFloorColor);
        int radius = this.mCenterPoint.x;
        canvas.drawCircle((float)this.mCenterPoint.x, (float)this.mCenterPoint.y, (float)radius * this.mFloorScale, this.mFloorPaint);
    }

    private void drawTick(Canvas canvas) {
        if (this.mTickDrawing && this.isChecked()) {
            this.drawTickPath(canvas);
        }
    }

    private void drawTickPath(Canvas canvas) {
        this.mTickPath.reset();
        if (this.mDrewDistance < this.mLeftLineDistance) {
            float step = (float)this.mWidth / 20.0f < 3.0f ? 3.0f : (float)this.mWidth / 20.0f;
            this.mDrewDistance += step;
            float stopX = (float)this.mTickPoints[0].x + (float)(this.mTickPoints[1].x - this.mTickPoints[0].x) * this.mDrewDistance / this.mLeftLineDistance;
            float stopY = (float)this.mTickPoints[0].y + (float)(this.mTickPoints[1].y - this.mTickPoints[0].y) * this.mDrewDistance / this.mLeftLineDistance;
            this.mTickPath.moveTo((float)this.mTickPoints[0].x, (float)this.mTickPoints[0].y);
            this.mTickPath.lineTo(stopX, stopY);
            canvas.drawPath(this.mTickPath, this.mTickPaint);
            if (this.mDrewDistance > this.mLeftLineDistance) {
                this.mDrewDistance = this.mLeftLineDistance;
            }
        } else {
            this.mTickPath.moveTo((float)this.mTickPoints[0].x, (float)this.mTickPoints[0].y);
            this.mTickPath.lineTo((float)this.mTickPoints[1].x, (float)this.mTickPoints[1].y);
            canvas.drawPath(this.mTickPath, this.mTickPaint);
            if (this.mDrewDistance < this.mLeftLineDistance + this.mRightLineDistance) {
                float stopX = (float)this.mTickPoints[1].x + (float)(this.mTickPoints[2].x - this.mTickPoints[1].x) * (this.mDrewDistance - this.mLeftLineDistance) / this.mRightLineDistance;
                float stopY = (float)this.mTickPoints[1].y - (float)(this.mTickPoints[1].y - this.mTickPoints[2].y) * (this.mDrewDistance - this.mLeftLineDistance) / this.mRightLineDistance;
                this.mTickPath.reset();
                this.mTickPath.moveTo((float)this.mTickPoints[1].x, (float)this.mTickPoints[1].y);
                this.mTickPath.lineTo(stopX, stopY);
                canvas.drawPath(this.mTickPath, this.mTickPaint);
                float step = this.mWidth / 20 < 3 ? 3.0f : (float)(this.mWidth / 20);
                this.mDrewDistance += step;
            } else {
                this.mTickPath.reset();
                this.mTickPath.moveTo((float)this.mTickPoints[1].x, (float)this.mTickPoints[1].y);
                this.mTickPath.lineTo((float)this.mTickPoints[2].x, (float)this.mTickPoints[2].y);
                canvas.drawPath(this.mTickPath, this.mTickPaint);
            }
        }
        if (this.mDrewDistance < this.mLeftLineDistance + this.mRightLineDistance) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    SmoothCheckBox.this.postInvalidate();
                }
            }, 10L);
        }
    }

    private void startCheckedAnimation() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        animator.setDuration((long)(this.mAnimDuration / 3 * 2));
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmoothCheckBox.this.mScaleVal = ((Float)animation.getAnimatedValue()).floatValue();
                SmoothCheckBox.this.mFloorColor = SmoothCheckBox.getGradientColor(SmoothCheckBox.this.mUnCheckedColor, SmoothCheckBox.this.mCheckedColor, 1.0f - SmoothCheckBox.this.mScaleVal);
                SmoothCheckBox.this.postInvalidate();
            }
        });
        animator.start();
        ValueAnimator floorAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.8f, 1.0f});
        floorAnimator.setDuration((long)this.mAnimDuration);
        floorAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        floorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmoothCheckBox.this.mFloorScale = ((Float)animation.getAnimatedValue()).floatValue();
                SmoothCheckBox.this.postInvalidate();
            }
        });
        floorAnimator.start();
        this.drawTickDelayed();
    }

    private void startUnCheckedAnimation() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.setDuration((long)this.mAnimDuration);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmoothCheckBox.this.mScaleVal = ((Float)animation.getAnimatedValue()).floatValue();
                SmoothCheckBox.this.mFloorColor = SmoothCheckBox.getGradientColor(SmoothCheckBox.this.mCheckedColor, COLOR_FLOOR_UNCHECKED, SmoothCheckBox.this.mScaleVal);
                SmoothCheckBox.this.postInvalidate();
            }
        });
        animator.start();
        ValueAnimator floorAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.8f, 1.0f});
        floorAnimator.setDuration((long)this.mAnimDuration);
        floorAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        floorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SmoothCheckBox.this.mFloorScale = ((Float)animation.getAnimatedValue()).floatValue();
                SmoothCheckBox.this.postInvalidate();
            }
        });
        floorAnimator.start();
    }

    private void drawTickDelayed() {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                SmoothCheckBox.this.mTickDrawing = true;
                SmoothCheckBox.this.postInvalidate();
            }
        }, this.mAnimDuration);
    }

    private static int getGradientColor(int startColor, int endColor, float percent) {
        int sr = (startColor & 0xFF0000) >> 16;
        int sg = (startColor & 0xFF00) >> 8;
        int sb = startColor & 0xFF;
        int er = (endColor & 0xFF0000) >> 16;
        int eg = (endColor & 0xFF00) >> 8;
        int eb = endColor & 0xFF;
        int cr = (int)((float)sr * (1.0f - percent) + (float)er * percent);
        int cg = (int)((float)sg * (1.0f - percent) + (float)eg * percent);
        int cb = (int)((float)sb * (1.0f - percent) + (float)eb * percent);
        return Color.argb((int)255, (int)cr, (int)cg, (int)cb);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener l) {
        this.mListener = l;
    }

    public int dp2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(SmoothCheckBox var1, boolean var2);
    }
}

