/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBar;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.moments.filepicker.BaseFilePickerActivity;
import com.moments.filepicker.PickerManager;
import com.moments.filepicker.R;
import com.moments.filepicker.fragments.FileFragment;
import com.moments.filepicker.fragments.FilePickerFragment;
import com.moments.filepicker.fragments.MediaPickerFragment;
import com.moments.filepicker.fragments.PhotoPickerFragmentListener;
import com.moments.filepicker.utils.FileUtils;
import com.moments.filepicker.utils.FragmentUtil;
import java.util.ArrayList;

public class FilePickerActivity
extends BaseFilePickerActivity
implements PhotoPickerFragmentListener,
FileFragment.DocFragmentListener,
FilePickerFragment.DocPickerFragmentListener,
MediaPickerFragment.MediaPickerFragmentListener,
View.OnClickListener {
    private static final String TAG = FilePickerActivity.class.getSimpleName();
    private int type;
    private LinearLayout llFileOperator;
    private TextView tvSendFileSize;
    private Button btnSendFile;
    private TextView title;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState, R.layout.moments_filepicker_activity_file_picker);
    }

    @Override
    protected void initView() {
        this.title = (TextView)this.findViewById(R.id.tv_title);
        this.llFileOperator = (LinearLayout)this.findViewById(R.id.ll_file_send_operator);
        this.tvSendFileSize = (TextView)this.findViewById(R.id.tv_select_file_size);
        this.btnSendFile = (Button)this.findViewById(R.id.bt_send_file);
        this.btnSendFile.setOnClickListener((View.OnClickListener)this);
        Intent intent = this.getIntent();
        if (intent != null) {
            ArrayList<String> selectedPaths = intent.getStringArrayListExtra("selected_file");
            this.type = intent.getIntExtra("EXTRA_PICKER_TYPE", 17);
            if (selectedPaths != null) {
                if (PickerManager.getInstance().getMaxCount() == 1) {
                    selectedPaths.clear();
                }
                PickerManager.getInstance().clearSelections();
                if (this.type == 17) {
                    PickerManager.getInstance().add(selectedPaths, 1);
                } else {
                    PickerManager.getInstance().add(selectedPaths, 2);
                }
            } else {
                selectedPaths = new ArrayList<String>();
            }
            if (PickerManager.getInstance().getMaxCount() == 1) {
                this.llFileOperator.setVisibility(8);
            }
            long currentFileSize = PickerManager.getInstance().getCurrentSize();
            this.setViewState(PickerManager.getInstance().getCurrentCount(), currentFileSize);
            this.openSpecificFragment(this.type, selectedPaths);
        }
    }

    private void setViewState(int count, long totalFileSize) {
        ActionBar actionBar = this.getSupportActionBar();
        this.tvSendFileSize.setText((CharSequence)("\u5df2\u9009" + FileUtils.getSizeString(totalFileSize)));
        if (actionBar != null) {
            if (this.type == 17) {
                this.title.setText((CharSequence)this.getString(R.string.select_photo_text));
                actionBar.setTitle((CharSequence)"");
            } else {
                this.title.setText((CharSequence)this.getString(R.string.select_doc_text));
                actionBar.setTitle((CharSequence)"");
            }
            int maxCount = PickerManager.getInstance().getMaxCount();
            if (maxCount == -1 && count > 0) {
                this.btnSendFile.setText((CharSequence)String.format(this.getString(R.string.attachments_num), count));
            } else if (maxCount > 0 && count >= 0) {
                this.btnSendFile.setText((CharSequence)String.format(this.getString(R.string.file_send), count, maxCount));
                if (count == 0) {
                    this.btnSendFile.setEnabled(false);
                } else {
                    this.btnSendFile.setEnabled(true);
                }
            } else if (!TextUtils.isEmpty((CharSequence)PickerManager.getInstance().getTitle())) {
                actionBar.setTitle((CharSequence)PickerManager.getInstance().getTitle());
            }
        }
    }

    private void openSpecificFragment(int type, @Nullable ArrayList<String> selectedPaths) {
        if (type == 17) {
            MediaPickerFragment photoFragment = MediaPickerFragment.newInstance();
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        } else {
            FilePickerFragment photoFragment = FilePickerFragment.newInstance();
            FragmentUtil.addFragment(this, R.id.container, photoFragment);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.filepicker_picker_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int i = item.getItemId();
        if (i == R.id.action_done) {
            if (this.type == 17) {
                this.returnData(PickerManager.getInstance().getSelectedPhotos());
            } else {
                this.returnData(PickerManager.getInstance().getSelectedFiles());
            }
            return true;
        }
        if (i == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
        PickerManager.getInstance().reset();
        this.setResult(0);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 235: {
                if (resultCode == -1) {
                    if (this.type == 17) {
                        this.returnData(PickerManager.getInstance().getSelectedPhotos());
                        break;
                    }
                    this.returnData(PickerManager.getInstance().getSelectedFiles());
                    break;
                }
                long currentFileSize = PickerManager.getInstance().getCurrentSize();
                this.setViewState(PickerManager.getInstance().getCurrentCount(), currentFileSize);
            }
        }
    }

    private void returnData(ArrayList<String> paths) {
        ArrayList<String> existFiles = new ArrayList<String>();
        if (paths.size() == 1) {
            existFiles.add(paths.get(0));
            if (!FileUtils.isFileExist(paths.get(0))) {
                Toast.makeText((Context)this, (int)R.string.file_delete, (int)0).show();
                return;
            }
        } else {
            for (String path : paths) {
                if (!FileUtils.isFileExist(path)) continue;
                existFiles.add(path);
            }
        }
        Intent intent = new Intent();
        if (this.type == 17) {
            intent.putStringArrayListExtra("selected_file", existFiles);
        } else {
            intent.putStringArrayListExtra("selected_file", existFiles);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void onItemSelected() {
        int currentCount = PickerManager.getInstance().getCurrentCount();
        long currentFileSize = PickerManager.getInstance().getCurrentSize();
        this.setViewState(currentCount, currentFileSize);
        if (PickerManager.getInstance().getMaxCount() == 1 && currentCount == 1) {
            this.returnData(this.type == 17 ? PickerManager.getInstance().getSelectedPhotos() : PickerManager.getInstance().getSelectedFiles());
        }
    }

    public void onClick(View v) {
        if (this.type == 17) {
            this.returnData(PickerManager.getInstance().getSelectedPhotos());
        } else {
            this.returnData(PickerManager.getInstance().getSelectedFiles());
        }
    }
}

