/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import com.moments.filepicker.FilePickerActivity;
import com.moments.filepicker.PickerManager;
import com.moments.filepicker.R;
import com.moments.filepicker.models.FileType;
import com.moments.filepicker.models.sort.SortingTypes;
import com.moments.filepicker.utils.Orientation;
import java.util.ArrayList;

public class FilePickerBuilder {
    private final Bundle mPickerOptionsBundle = new Bundle();

    public static FilePickerBuilder getInstance() {
        return new FilePickerBuilder();
    }

    public FilePickerBuilder setMaxCount(int maxCount) {
        PickerManager.getInstance().setMaxCount(maxCount);
        return this;
    }

    public FilePickerBuilder setActivityTheme(int theme) {
        PickerManager.getInstance().setTheme(theme);
        return this;
    }

    public FilePickerBuilder setActivityTitle(String title) {
        PickerManager.getInstance().setTitle(title);
        return this;
    }

    public FilePickerBuilder setSelectedFiles(ArrayList<String> selectedPhotos) {
        this.mPickerOptionsBundle.putStringArrayList("selected_file", selectedPhotos);
        return this;
    }

    public FilePickerBuilder enableVideoPicker(boolean status) {
        PickerManager.getInstance().setShowVideos(status);
        return this;
    }

    public FilePickerBuilder enableImagePicker(boolean status) {
        PickerManager.getInstance().setShowImages(status);
        return this;
    }

    public FilePickerBuilder enableSelectAll(boolean status) {
        PickerManager.getInstance().enableSelectAll(status);
        return this;
    }

    public FilePickerBuilder setCameraPlaceholder(@DrawableRes int drawable2) {
        PickerManager.getInstance().setCameraDrawable(drawable2);
        return this;
    }

    public FilePickerBuilder showGifs(boolean status) {
        PickerManager.getInstance().setShowGif(status);
        return this;
    }

    public FilePickerBuilder showFolderView(boolean status) {
        PickerManager.getInstance().setShowFolderView(status);
        return this;
    }

    public FilePickerBuilder enableCameraSupport(boolean status) {
        PickerManager.getInstance().setEnableCamera(status);
        return this;
    }

    public FilePickerBuilder setMaxFileSizeMB(int fileSizeMB) {
        PickerManager.getInstance().setMaxFileSizeMB(fileSizeMB);
        return this;
    }

    public FilePickerBuilder withOrientation(Orientation orientation) {
        PickerManager.getInstance().setOrientation(orientation);
        return this;
    }

    public FilePickerBuilder addFileSupport(String title, String[] extensions, @DrawableRes int drawable2) {
        PickerManager.getInstance().addFileType(new FileType(title, extensions, drawable2));
        return this;
    }

    public FilePickerBuilder addFileSupport(String title, String[] extensions) {
        PickerManager.getInstance().addFileType(new FileType(title, extensions, 0));
        return this;
    }

    public FilePickerBuilder sortFilesBy(SortingTypes type) {
        PickerManager.getInstance().setSortingType(type);
        return this;
    }

    public void pickPhoto(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 233);
    }

    public void pickPhoto(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, 233);
    }

    public void pickFile(Activity context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 234);
    }

    public void pickFile(Fragment context) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, 234);
    }

    public void pickPhoto(Activity context, int requestCode) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, requestCode);
    }

    public void pickPhoto(Fragment context, int requestCode) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 17);
        this.start(context, requestCode);
    }

    public void pickFile(Activity context, int requestCode) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, requestCode);
    }

    public void pickFile(Fragment context, int requestCode) {
        this.mPickerOptionsBundle.putInt("EXTRA_PICKER_TYPE", 18);
        this.start(context, requestCode);
    }

    private void start(Activity context, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            Toast.makeText((Context)context, (CharSequence)context.getResources().getString(R.string.permission_filepicker_rationale), (int)0).show();
            return;
        }
        PickerManager.getInstance().setProviderAuthorities(context.getApplicationContext().getPackageName() + ".provider");
        Intent intent = new Intent((Context)context, FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        context.startActivityForResult(intent, requestCode);
    }

    private void start(Fragment fragment, int requestCode) {
        if (Build.VERSION.SDK_INT >= 23 && ContextCompat.checkSelfPermission((Context)fragment.getContext(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            Toast.makeText((Context)fragment.getContext(), (CharSequence)fragment.getContext().getResources().getString(R.string.permission_filepicker_rationale), (int)0).show();
            return;
        }
        PickerManager.getInstance().setProviderAuthorities(fragment.getContext().getApplicationContext().getPackageName() + ".provider");
        Intent intent = new Intent((Context)fragment.getActivity(), FilePickerActivity.class);
        intent.putExtras(this.mPickerOptionsBundle);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void initCommonFilePicker(Activity context, int maxChoose, int maxSingleFileSize, int requestCode, @StyleRes int style2) {
        String[] zipTypes = new String[]{".zip", ".rar"};
        String[] audioTypes = new String[]{".mp3", ".wav", "m4a", ".aac", ".amr", ".ogg", ".mp4", ".3gp", ".avi"};
        String[] imageTypes = new String[]{".png", ".jpeg", ".jpg", ".gif", ".bmp"};
        String[] apkTypes = new String[]{".apk"};
        String[] docTypes = new String[]{".doc", ".docx", ".dot", ".dotx", ".pdf", ".ppt", ".pptx", ".xls", ".xlsx", ".txt"};
        FilePickerBuilder.getInstance().setMaxCount(maxChoose).setMaxFileSizeMB(maxSingleFileSize).enableVideoPicker(true).addFileSupport("\u97f3\u89c6\u9891", audioTypes).addFileSupport("\u56fe\u7247", imageTypes, R.drawable.filepicker_icon_file_image).addFileSupport("\u6587\u6863", docTypes).addFileSupport("\u5e94\u7528", apkTypes, R.drawable.filepicker_icon_file_apk).addFileSupport("\u538b\u7f29\u5305", zipTypes, R.drawable.filepicker_icon_file_zip).setActivityTheme(style2).sortFilesBy(SortingTypes.ext).pickFile(context, requestCode);
    }
}

