/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.cursors;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.AsyncTask;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.moments.filepicker.PickerManager;
import com.moments.filepicker.cursors.loadercallbacks.FileMapResultCallback;
import com.moments.filepicker.models.FileType;
import com.moments.filepicker.models.PickFile;
import com.moments.filepicker.utils.FilePickerUtils;
import com.moments.filepicker.utils.FileUtils;
import io.reactivex.functions.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileScannerTask
extends AsyncTask<Void, Void, Map<FileType, List<PickFile>>> {
    final String[] FILE_PROJECTION = new String[]{"_id", "_data", "mime_type", "_size", "date_added", "title"};
    private final FileMapResultCallback resultCallback;
    private final Comparator<PickFile> comparator;
    private final List<FileType> fileTypes;
    private final ContentResolver contentResolver;

    public FileScannerTask(Context context, List<FileType> fileTypes, Comparator<PickFile> comparator, FileMapResultCallback fileResultCallback) {
        this.contentResolver = context.getContentResolver();
        this.fileTypes = fileTypes;
        this.comparator = comparator;
        this.resultCallback = fileResultCallback;
    }

    private HashMap<FileType, List<PickFile>> createDocumentType(ArrayList<PickFile> pickFiles) {
        HashMap<FileType, List<PickFile>> documentMap = new HashMap<FileType, List<PickFile>>();
        for (final FileType fileType : this.fileTypes) {
            Predicate<PickFile> docContainsTypeExtension = new Predicate<PickFile>(){

                public boolean test(PickFile pickFile) {
                    return pickFile.isThisType(fileType.extensions);
                }
            };
            ArrayList pickFileListFilteredByType = (ArrayList)FilePickerUtils.filter(pickFiles, docContainsTypeExtension);
            if (this.comparator != null) {
                Collections.sort(pickFileListFilteredByType, this.comparator);
            }
            documentMap.put(fileType, pickFileListFilteredByType);
        }
        return documentMap;
    }

    protected Map<FileType, List<PickFile>> doInBackground(Void ... voids) {
        ArrayList<PickFile> pickFiles = new ArrayList<PickFile>();
        String selection = "_data not like  '%/Android/data/%'  and _data not like  '%/Tencent/%' and _data not like  '%/.%/%'";
        Cursor cursor = this.contentResolver.query(MediaStore.Files.getContentUri((String)"external"), this.FILE_PROJECTION, selection, null, "date_added DESC");
        if (cursor != null) {
            pickFiles = this.getDocumentFromCursor(cursor);
            cursor.close();
        }
        return this.createDocumentType(pickFiles);
    }

    protected void onPostExecute(Map<FileType, List<PickFile>> documents) {
        if (this.resultCallback != null) {
            this.resultCallback.onResultCallback(documents);
        }
    }

    private ArrayList<PickFile> getDocumentFromCursor(Cursor data) {
        ArrayList<PickFile> pickFiles = new ArrayList<PickFile>();
        while (data.moveToNext()) {
            int imageId = data.getInt(data.getColumnIndexOrThrow("_id"));
            String path = data.getString(data.getColumnIndexOrThrow("_data"));
            String title = data.getString(data.getColumnIndexOrThrow("title"));
            long addDate = data.getLong(data.getColumnIndexOrThrow("date_added"));
            if (path == null) continue;
            FileType fileType = this.getFileType(PickerManager.getInstance().getFileTypes(), path);
            File file = new File(path);
            if (fileType == null || file.isDirectory() || !file.exists()) continue;
            PickFile pickFile = new PickFile(imageId, title, path, addDate);
            String fileDir = FileUtils.getFileDir(path);
            pickFile.setDir(fileDir);
            pickFile.setFileType(fileType);
            String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
            if (mimeType != null && !TextUtils.isEmpty((CharSequence)mimeType)) {
                pickFile.setMimeType(mimeType);
            } else {
                pickFile.setMimeType("");
            }
            pickFile.setSize(data.getString(data.getColumnIndexOrThrow("_size")));
            if (pickFiles.contains(pickFile)) continue;
            pickFiles.add(pickFile);
        }
        return pickFiles;
    }

    private FileType getFileType(ArrayList<FileType> types, String path) {
        for (int index = 0; index < types.size(); ++index) {
            for (String string2 : types.get((int)index).extensions) {
                if (!path.endsWith(string2)) continue;
                return types.get(index);
            }
        }
        return null;
    }
}

