/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.fragments;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.moments.filepicker.PickerManager;
import com.moments.filepicker.R;
import com.moments.filepicker.adapters.SectionsPagerAdapter;
import com.moments.filepicker.cursors.loadercallbacks.FileMapResultCallback;
import com.moments.filepicker.fragments.BaseFragment;
import com.moments.filepicker.fragments.FileFragment;
import com.moments.filepicker.models.FileType;
import com.moments.filepicker.models.PickFile;
import com.moments.filepicker.utils.FilePickerSPUtils;
import com.moments.filepicker.utils.MediaStoreHelper;
import com.moments.filepicker.views.magicindicator.MagicIndicator;
import com.moments.filepicker.views.magicindicator.buildins.UIUtil;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.CommonNavigator;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.CommonNavigatorAdapter;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IPagerIndicator;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IPagerTitleView;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.indicators.LinePagerIndicator;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.titles.ColorTransitionPagerTitleView;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.titles.badge.BadgePagerTitleView;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FilePickerFragment
extends BaseFragment {
    private static final String TAG = FilePickerFragment.class.getSimpleName();
    MagicIndicator magicIndicator;
    ViewPager viewPager;
    private ConstraintLayout loadingLayout;
    private DocPickerFragmentListener mListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.moments_filepicker_fragment_doc_picker, container, false);
    }

    public static FilePickerFragment newInstance() {
        FilePickerFragment filePickerFragment = new FilePickerFragment();
        return filePickerFragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof DocPickerFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement DocPickerFragmentListener");
        }
        this.mListener = (DocPickerFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.setViews(view);
        this.initView();
    }

    private void initView() {
        this.setUpViewPager();
        this.setData();
    }

    private void setViews(View view) {
        this.magicIndicator = (MagicIndicator)view.findViewById(R.id.tabs);
        this.viewPager = (ViewPager)view.findViewById(R.id.viewPager);
        this.loadingLayout = (ConstraintLayout)view.findViewById(R.id.loading);
        this.loadingLayout.setVisibility(0);
    }

    private void setData() {
        MediaStoreHelper.getDocs(this.getActivity(), PickerManager.getInstance().getFileTypes(), PickerManager.getInstance().getSortingType().getComparator(), new FileMapResultCallback(){

            @Override
            public void onResultCallback(Map<FileType, List<PickFile>> files) {
                if (!FilePickerFragment.this.isAdded()) {
                    return;
                }
                FilePickerFragment.this.setDataOnFragments(files);
                FilePickerFragment.this.loadingLayout.setVisibility(8);
            }
        });
    }

    private void setDataOnFragments(Map<FileType, List<PickFile>> filesMap) {
        SectionsPagerAdapter sectionsPagerAdapter = (SectionsPagerAdapter)this.viewPager.getAdapter();
        if (sectionsPagerAdapter != null) {
            for (int index = 0; index < sectionsPagerAdapter.getCount(); ++index) {
                List<PickFile> filesFilteredByType;
                FileType fileType;
                FileFragment fileFragment = (FileFragment)this.getChildFragmentManager().findFragmentByTag("android:switcher:" + R.id.viewPager + ":" + index);
                if (fileFragment == null || (fileType = fileFragment.getFileType()) == null || (filesFilteredByType = filesMap.get(fileType)) == null) continue;
                fileFragment.updateList(filesFilteredByType);
            }
        }
    }

    private void setUpViewPager() {
        SectionsPagerAdapter adapter = new SectionsPagerAdapter(this.getChildFragmentManager());
        ArrayList<FileType> supportedTypes = PickerManager.getInstance().getFileTypes();
        final ArrayList<String> mDataList = new ArrayList<String>();
        for (int index = 0; index < supportedTypes.size(); ++index) {
            adapter.addFragment(FileFragment.newInstance(supportedTypes.get(index)), supportedTypes.get((int)index).title);
            mDataList.add(supportedTypes.get((int)index).title);
        }
        this.viewPager.setOffscreenPageLimit(supportedTypes.size());
        this.viewPager.setAdapter((PagerAdapter)adapter);
        CommonNavigator commonNavigator = new CommonNavigator((Context)this.getActivity());
        commonNavigator.setAdapter(new CommonNavigatorAdapter(){

            @Override
            public int getCount() {
                return mDataList.size();
            }

            @Override
            public IPagerTitleView getTitleView(Context context, final int index) {
                BadgePagerTitleView badgePagerTitleView = new BadgePagerTitleView(context);
                ColorTransitionPagerTitleView simplePagerTitleView = new ColorTransitionPagerTitleView(context);
                simplePagerTitleView.setText((CharSequence)mDataList.get(index));
                simplePagerTitleView.setNormalColor(Color.parseColor((String)"#88ffffff"));
                simplePagerTitleView.setSelectedColor(-1);
                simplePagerTitleView.setTextSize(1, 16.0f);
                simplePagerTitleView.setPadding(20);
                simplePagerTitleView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        FilePickerFragment.this.viewPager.setCurrentItem(index);
                    }
                });
                badgePagerTitleView.setInnerPagerTitleView(simplePagerTitleView);
                badgePagerTitleView.setAutoCancelBadge(false);
                return badgePagerTitleView;
            }

            @Override
            public IPagerIndicator getIndicator(Context context) {
                LinePagerIndicator indicator = new LinePagerIndicator(context);
                indicator.setColors(Color.parseColor((String)"#ffffff"));
                indicator.setMode(2);
                indicator.setRoundRadius(UIUtil.dip2px(context, 2.0));
                indicator.setLineWidth(UIUtil.dip2px(context, 20.0));
                indicator.setLineHeight(UIUtil.dip2px(context, 2.0));
                return indicator;
            }
        });
        if (this.magicIndicator != null) {
            this.magicIndicator.setNavigator(commonNavigator);
            this.viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                    FilePickerFragment.this.magicIndicator.onPageScrolled(position, positionOffset, positionOffsetPixels);
                }

                public void onPageSelected(int position) {
                    FilePickerFragment.this.magicIndicator.onPageSelected(position);
                }

                public void onPageScrollStateChanged(int state) {
                    FilePickerFragment.this.magicIndicator.onPageScrollStateChanged(state);
                }
            });
        }
        this.viewPager.setCurrentItem(((Integer)FilePickerSPUtils.get((Context)this.getActivity(), "last_tab_position", 0)).intValue());
    }

    public void onDestroy() {
        FilePickerSPUtils.put((Context)this.getActivity(), "last_tab_position", this.viewPager.getCurrentItem());
        super.onDestroy();
    }

    public static interface DocPickerFragmentListener {
    }
}

