/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.utils;

import android.text.TextUtils;
import com.moments.filepicker.FilePickerConst;
import com.moments.filepicker.utils.FilePickerUtils;
import java.io.File;

public class FileUtils {
    private static String kB_UNIT_NAME = "KB";
    private static String B_UNIT_NAME = "B";
    private static String MB_UNIT_NAME = "MB";

    public static FilePickerConst.FILE_TYPE getFileType(String path) {
        String fileExtension = FilePickerUtils.getFileExtension(path);
        if (TextUtils.isEmpty((CharSequence)fileExtension)) {
            return FilePickerConst.FILE_TYPE.UNKNOWN;
        }
        if (FileUtils.isExcelFile(path)) {
            return FilePickerConst.FILE_TYPE.EXCEL;
        }
        if (FileUtils.isDocFile(path)) {
            return FilePickerConst.FILE_TYPE.WORD;
        }
        if (FileUtils.isPPTFile(path)) {
            return FilePickerConst.FILE_TYPE.PPT;
        }
        if (FileUtils.isPDFFile(path)) {
            return FilePickerConst.FILE_TYPE.PDF;
        }
        if (FileUtils.isTxtFile(path)) {
            return FilePickerConst.FILE_TYPE.TXT;
        }
        if (FileUtils.isImageFile(path)) {
            return FilePickerConst.FILE_TYPE.IMAGE;
        }
        if (FileUtils.isVoiceFile(path)) {
            return FilePickerConst.FILE_TYPE.VOICE;
        }
        if (FileUtils.isVideoFile(path)) {
            return FilePickerConst.FILE_TYPE.VIDEO;
        }
        return FilePickerConst.FILE_TYPE.UNKNOWN;
    }

    public static String getFileExtString(String path) {
        String fileExtension = FilePickerUtils.getFileExtension(path);
        if (TextUtils.isEmpty((CharSequence)fileExtension)) {
            return "UNKNOWN";
        }
        if (FileUtils.isExcelFile(path)) {
            return "EXCEL";
        }
        if (FileUtils.isDocFile(path)) {
            return "WORD";
        }
        if (FileUtils.isPPTFile(path)) {
            return "PPT";
        }
        if (FileUtils.isPDFFile(path)) {
            return "PDF";
        }
        if (FileUtils.isTxtFile(path)) {
            return "TXT";
        }
        if (FileUtils.isImageFile(path)) {
            return "IMAGE";
        }
        if (FileUtils.isVoiceFile(path)) {
            return "VOICE";
        }
        if (FileUtils.isVideoFile(path)) {
            return "VIDEO";
        }
        if (FileUtils.isAPkFile(path)) {
            return "APK";
        }
        return "UNKNOWN";
    }

    public static boolean isAllDoucmentFile(String path) {
        String[] types = new String[]{"xls", "xlsx", "doc", "docx", "dot", "dotx", "ppt", "pptx", "pdf", "txt"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isExcelFile(String path) {
        String[] types = new String[]{"xls", "xlsx"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isDocFile(String path) {
        String[] types = new String[]{"doc", "docx", "dot", "dotx"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isPPTFile(String path) {
        String[] types = new String[]{"ppt", "pptx"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isPDFFile(String path) {
        String[] types = new String[]{"pdf"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isTxtFile(String path) {
        String[] types = new String[]{"txt"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isVoiceFile(String path) {
        String[] types = new String[]{"mp3", "wav", "aac", "amr", "ogg", "m4a"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isVideoFile(String path) {
        String[] types = new String[]{"mp4", "3gp", "avi"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isImageFile(String path) {
        String[] types = new String[]{"png", "jpeg", "jpg", "gif", "bmp"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isAPkFile(String path) {
        String[] types = new String[]{"apk"};
        return FilePickerUtils.contains(types, path);
    }

    public static boolean isFileExist(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }

    public static long getFileSize(String path) {
        int temp = 0;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return 0L;
        }
        File file = new File(path);
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        if (!file.isDirectory()) {
            return 0L;
        }
        for (File f : file.listFiles()) {
            if (f.isFile()) {
                temp = (int)((long)temp + f.length());
                continue;
            }
            if (!f.isDirectory()) continue;
            temp = (int)((long)temp + FileUtils.getFileSize(f.getAbsolutePath()));
        }
        return temp;
    }

    public static String getSizeString(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + B_UNIT_NAME;
        }
        if ((size /= 1024L) < 1024L) {
            return String.valueOf(size) + kB_UNIT_NAME;
        }
        size = size * 100L / 1024L;
        return String.valueOf(size / 100L) + "." + (size % 100L < 10L ? "0" : "") + String.valueOf(size % 100L) + MB_UNIT_NAME;
    }

    public static String getFileDir(String filePath) {
        File file = new File(filePath);
        if (TextUtils.isEmpty((CharSequence)filePath) || !file.exists()) {
            return "";
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && parentFile.isDirectory() && !TextUtils.isEmpty((CharSequence)parentFile.getName())) {
            return parentFile.getName();
        }
        return "SdCard";
    }
}

