/*
 * Decompiled with CFR 0.152.
 */
package com.moments.filepicker.views.magicindicator.buildins.commonnavigator.titles;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.moments.filepicker.views.magicindicator.buildins.commonnavigator.abs.IMeasurablePagerTitleView;

public class CommonPagerTitleView
extends FrameLayout
implements IMeasurablePagerTitleView {
    private OnPagerTitleChangeListener mOnPagerTitleChangeListener;
    private ContentPositionDataProvider mContentPositionDataProvider;

    public CommonPagerTitleView(Context context) {
        super(context);
    }

    @Override
    public void onSelected(int index, int totalCount) {
        if (this.mOnPagerTitleChangeListener != null) {
            this.mOnPagerTitleChangeListener.onSelected(index, totalCount);
        }
    }

    @Override
    public void onDeselected(int index, int totalCount) {
        if (this.mOnPagerTitleChangeListener != null) {
            this.mOnPagerTitleChangeListener.onDeselected(index, totalCount);
        }
    }

    @Override
    public void onLeave(int index, int totalCount, float leavePercent, boolean leftToRight) {
        if (this.mOnPagerTitleChangeListener != null) {
            this.mOnPagerTitleChangeListener.onLeave(index, totalCount, leavePercent, leftToRight);
        }
    }

    @Override
    public void onEnter(int index, int totalCount, float enterPercent, boolean leftToRight) {
        if (this.mOnPagerTitleChangeListener != null) {
            this.mOnPagerTitleChangeListener.onEnter(index, totalCount, enterPercent, leftToRight);
        }
    }

    @Override
    public int getContentLeft() {
        if (this.mContentPositionDataProvider != null) {
            return this.mContentPositionDataProvider.getContentLeft();
        }
        return this.getLeft();
    }

    @Override
    public int getContentTop() {
        if (this.mContentPositionDataProvider != null) {
            return this.mContentPositionDataProvider.getContentTop();
        }
        return this.getTop();
    }

    @Override
    public int getContentRight() {
        if (this.mContentPositionDataProvider != null) {
            return this.mContentPositionDataProvider.getContentRight();
        }
        return this.getRight();
    }

    @Override
    public int getContentBottom() {
        if (this.mContentPositionDataProvider != null) {
            return this.mContentPositionDataProvider.getContentBottom();
        }
        return this.getBottom();
    }

    public void setContentView(View contentView) {
        this.setContentView(contentView, null);
    }

    public void setContentView(View contentView, FrameLayout.LayoutParams lp) {
        this.removeAllViews();
        if (contentView != null) {
            if (lp == null) {
                lp = new FrameLayout.LayoutParams(-1, -1);
            }
            this.addView(contentView, (ViewGroup.LayoutParams)lp);
        }
    }

    public void setContentView(int layoutId) {
        View child = LayoutInflater.from((Context)this.getContext()).inflate(layoutId, null);
        this.setContentView(child, null);
    }

    public OnPagerTitleChangeListener getOnPagerTitleChangeListener() {
        return this.mOnPagerTitleChangeListener;
    }

    public void setOnPagerTitleChangeListener(OnPagerTitleChangeListener onPagerTitleChangeListener) {
        this.mOnPagerTitleChangeListener = onPagerTitleChangeListener;
    }

    public ContentPositionDataProvider getContentPositionDataProvider() {
        return this.mContentPositionDataProvider;
    }

    public void setContentPositionDataProvider(ContentPositionDataProvider contentPositionDataProvider) {
        this.mContentPositionDataProvider = contentPositionDataProvider;
    }

    public static interface ContentPositionDataProvider {
        public int getContentLeft();

        public int getContentTop();

        public int getContentRight();

        public int getContentBottom();
    }

    public static interface OnPagerTitleChangeListener {
        public void onSelected(int var1, int var2);

        public void onDeselected(int var1, int var2);

        public void onLeave(int var1, int var2, float var3, boolean var4);

        public void onEnter(int var1, int var2, float var3, boolean var4);
    }
}

