/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.StyleRes;
import android.widget.Toast;
import com.alibaba.android.arouter.launcher.ARouter;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.moments.sdk.bean.FileBean;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.bean.SelectMomentsClassifyBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.bean.VideoBean;
import com.xdja.moments.sdk.bean.share.BaseShareBean;
import com.xdja.moments.sdk.http.bean.response.ClassifyDeptListResponse;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.utils.MomentComponentUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Navigation {
    public static final String MAIN_ACTIVITY_PATH = "/main/momentMain";
    public static final String MY_MOMENTS_ACTIVITY_PATH = "/mine/myMoments";
    public static final String OTHERS_MOMENTS_ACTIVITY_PATH = "/mine/othersMoments";
    public static final String MOMENT_REVIEW_ACTIVITY_PATH = "/review/reviewMain";
    public static final String NEW_COMMENTS_ACTIVITY_PATH = "/main/newComments";
    public static final String FILE_DETAIL_ACTIVITY_PATH = "/detail/fileDetail";
    public static final String URL_DETAIL_ACTIVITY_PATH = "/detail/urlDetail";
    public static final String PUBLISH_MOMENTS_ACTIVITY_PATH = "/publish/publishMoments";
    public static final String IMAGE_GALLERY_ACTIVITY_PATH = "/publish/gallery";
    public static final String SELECT_CLASSIFY_ACTIVITY_PATH = "/publish/selectClassify";
    public static final String SELECT_BROWSE_AUTH_ACTIVITY_PATH = "/publish/selectBrowseAuth";
    public static final String MOMENT_DETAIL_ACTIVITY_PATH = "/detail/momentDetail";
    public static final String VIDEO_DETAIL_ACTIVITY = "/detail/videoDetail";

    public static void navigationPersonDetail(Context context, String userId) {
        Intent personDetailIntent = MomentsManager.getInstance().getPersonDetailIntent(userId);
        if (personDetailIntent == null) {
            return;
        }
        if (!(context instanceof Activity)) {
            personDetailIntent.addFlags(0x10000000);
        }
        context.startActivity(personDetailIntent);
    }

    public static void navigationMomentsMain() {
        ARouter.getInstance().build(MAIN_ACTIVITY_PATH).navigation();
    }

    public static void navigationMyMoments() {
        ARouter.getInstance().build(MY_MOMENTS_ACTIVITY_PATH).navigation();
    }

    public static void navigationMomentDetail(String momentId) {
        Navigation.navigationMomentDetail(momentId, "", false, false, false);
    }

    public static void navigationMomentDetail(String momentId, String commentId) {
        Navigation.navigationMomentDetail(momentId, commentId, false, false, false);
    }

    public static void navigationMomentDetailAndScrollToFirstComment(String momentId, boolean showInputComment) {
        Navigation.navigationMomentDetail(momentId, "", showInputComment, true, false);
    }

    public static void navigationMomentDetail(String momentId, String commentId, boolean showKeyBoard, boolean scrollToFirstComment, boolean isFromVerifyActivity) {
        ARouter.getInstance().build(MOMENT_DETAIL_ACTIVITY_PATH).withString("moment_id", momentId).withString("comment_id", commentId).withBoolean("show_input_comment", showKeyBoard).withBoolean("show_first_comment", scrollToFirstComment).withBoolean("is_verify_to_detail", isFromVerifyActivity).navigation();
    }

    public static void navigationMomentDetailAndShowInputComment(String momentId) {
        ARouter.getInstance().build(MOMENT_DETAIL_ACTIVITY_PATH).withString("moment_id", momentId).withBoolean("show_input_comment", true).navigation();
    }

    public static void navigationMomentReview() {
        ARouter.getInstance().build(MOMENT_REVIEW_ACTIVITY_PATH).navigation();
    }

    public static void navigationNewComments(long lastTimeStamp, int newCount) {
        ARouter.getInstance().build(NEW_COMMENTS_ACTIVITY_PATH).withLong("last_item_time_stamp", lastTimeStamp).withInt("loadCount", newCount).navigation();
    }

    public static void navigationOtherMoments(String userId, String title) {
        ARouter.getInstance().build(OTHERS_MOMENTS_ACTIVITY_PATH).withString("userId", userId).withString("title", title).navigation();
    }

    public static void navigationFileDetail(FileBean fileBean) {
        ARouter.getInstance().build(FILE_DETAIL_ACTIVITY_PATH).withSerializable("file_bean", (Serializable)fileBean).navigation();
    }

    public static void navigationPublishMoments() {
        ARouter.getInstance().build(PUBLISH_MOMENTS_ACTIVITY_PATH).navigation();
    }

    public static void navigationPublishMomentsWithData(String content, String filePath) {
        ARouter.getInstance().build(PUBLISH_MOMENTS_ACTIVITY_PATH).withString("publish_content", content).withString("publish_file_path", filePath).navigation();
    }

    public static void navigationPublishMomentsWithData(BaseShareBean shareDataBean) {
        ARouter.getInstance().build(PUBLISH_MOMENTS_ACTIVITY_PATH).withSerializable("publish_share_bean", (Serializable)shareDataBean).navigation();
    }

    public static void navigationGallery(Context context, int position, ArrayList<ImageBean> imageBeanList) {
        ARouter.getInstance().build(IMAGE_GALLERY_ACTIVITY_PATH).withInt("image_index", position).withSerializable("image_urls", imageBeanList).navigation();
    }

    public static void navigationVideoDetailActivity(VideoBean videoBean) {
        ARouter.getInstance().build(VIDEO_DETAIL_ACTIVITY).withSerializable("extra_video", (Serializable)videoBean).navigation();
    }

    public static void navigationSelectClassify(Activity activity, List<SelectMomentsClassifyBean> list, String selectedClassifyId) {
        ARouter.getInstance().build(SELECT_CLASSIFY_ACTIVITY_PATH).withSerializable("classifyList", (Serializable)((ArrayList)list)).withString("classifyId", selectedClassifyId).navigation(activity, 264);
    }

    public static void navigationSelectBrowseAuthActivity(Activity activity, String classifyId, int browseType, String browseAuthValue) {
        ARouter.getInstance().build(SELECT_BROWSE_AUTH_ACTIVITY_PATH).withString("classify_id", classifyId).withInt("browse_auth", browseType).withString("browse_auth_value", browseAuthValue).navigation(activity, 263);
    }

    public static void navigationTakeVideo(Activity context) {
        Intent selectIntent = MomentsManager.getInstance().getSelectIntent(3, 0, null);
        if (selectIntent != null) {
            context.startActivityForResult(selectIntent, 258);
        } else if (MomentComponentUtil.getInstance().isVideoComponentExit()) {
            MomentComponentUtil.getInstance().captureVideo(context, 258);
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u627e\u5230\u76f8\u5e94\u9875\u9762", (int)0).show();
        }
    }

    public static void navigationSelectPerson(Activity context, List<UserInfoBean> hasChoosedUsers, int maxSelect) {
        Intent selectIntent;
        ArrayList<String> selectedPersons = new ArrayList<String>();
        if (!ListUtil.isEmpty(hasChoosedUsers)) {
            for (UserInfoBean hasChoosedUser : hasChoosedUsers) {
                selectedPersons.add(hasChoosedUser.getUserId());
            }
        }
        if ((selectIntent = MomentsManager.getInstance().getSelectIntent(0, maxSelect, selectedPersons)) != null) {
            context.startActivityForResult(selectIntent, 265);
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u627e\u5230\u76f8\u5e94\u9875\u9762", (int)0).show();
        }
    }

    public static void navigationFilePicker(Activity context, int maxChoose, int maxSingleFileSize, @StyleRes int style) {
        Intent selectIntent = MomentsManager.getInstance().getSelectIntent(5, maxChoose, null);
        if (selectIntent != null) {
            context.startActivityForResult(selectIntent, 259);
        } else if (MomentComponentUtil.getInstance().isFilePickerComponentExit()) {
            MomentComponentUtil.getInstance().pickFile(context, 259, maxChoose, maxSingleFileSize, style);
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u627e\u5230\u76f8\u5e94\u9875\u9762", (int)0).show();
        }
    }

    public static void navigationLocationActivity(Activity context, boolean isFromPublish, String address, String addressDetail, double longitude, double latitude, String cityCode) {
        Intent selectIntent = MomentsManager.getInstance().getLocationIntent(address, addressDetail, longitude, latitude, cityCode);
        if (selectIntent != null) {
            context.startActivityForResult(selectIntent, 262);
        } else if (MomentComponentUtil.getInstance().isLocationComponentExit()) {
            MomentComponentUtil.getInstance().startLocation(context, isFromPublish, address, addressDetail, longitude, latitude, cityCode, 262);
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u627e\u5230\u76f8\u5e94\u9875\u9762", (int)0).show();
        }
    }

    public static void navigationLocationActivity(Activity context, boolean isFromPublish) {
        Navigation.navigationLocationActivity(context, isFromPublish, "", "", 0.0, 0.0, "");
    }

    public static void navigationLocationDetailActivity(Activity context, String address, String addressDetail, double longitude, double latitude) {
        Intent locationDetailIntent = MomentsManager.getInstance().getLocationDetailIntent(address, addressDetail, longitude, latitude, "");
        if (locationDetailIntent != null) {
            context.startActivity(locationDetailIntent);
        } else if (MomentComponentUtil.getInstance().isLocationComponentExit()) {
            MomentComponentUtil.getInstance().startLocationDetail(context, address, addressDetail, longitude, latitude);
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u627e\u5230\u76f8\u5e94\u9875\u9762", (int)0).show();
        }
    }

    public static void navigationSelectPictureActivity(Activity activity, List<String> selectedPicturePaths) {
        Intent selectIntent = MomentsManager.getInstance().getSelectIntent(2, 9, selectedPicturePaths);
        if (selectIntent != null) {
            activity.startActivityForResult(selectIntent, 260);
        } else if (MomentComponentUtil.getInstance().isImagePickerComponentExit()) {
            MomentComponentUtil.getInstance().pickPicture(activity, selectedPicturePaths, 9, 260);
        } else {
            Toast.makeText((Context)activity, (CharSequence)"\u672a\u627e\u5230\u76f8\u5e94\u9875\u9762", (int)0).show();
        }
    }

    public static void navigationUrlDetailActivity(Activity activity, String title, String url) {
        Intent webDetailIntent = MomentsManager.getInstance().getWebDetailIntent(url, title);
        if (webDetailIntent == null) {
            ARouter.getInstance().build(URL_DETAIL_ACTIVITY_PATH).withString("title", title).withString("url", url).navigation();
        } else {
            activity.startActivity(webDetailIntent);
        }
    }

    public static void shareMomentTo(MomentsBean momentsBean) {
        if (MomentsManager.getInstance().getShareToListener() == null) {
            Logger.d((Object)"\u8bf7\u5728MomentsManager\u4e2d\u6ce8\u518cMomentShareToListener");
            return;
        }
        MomentsManager.getInstance().getShareToListener().shareMomentToListener(momentsBean);
    }

    public static void shareFileTo(String localFilePath) {
        if (MomentsManager.getInstance().getShareToListener() == null) {
            Logger.d((Object)"\u8bf7\u5728MomentsManager\u4e2d\u6ce8\u518cMomentShareToListener");
            return;
        }
        MomentsManager.getInstance().getShareToListener().shareFileToListener(localFilePath);
    }

    public static void navigationSelectDeptActivity(Activity context, List<ClassifyDeptListResponse> deptIds, List<String> hasChoosed) {
        Intent selectIntent = MomentsManager.getInstance().getSelectDeptIntent(Integer.MAX_VALUE, deptIds, hasChoosed);
        if (selectIntent != null) {
            context.startActivityForResult(selectIntent, 272);
        } else {
            Toast.makeText((Context)context, (CharSequence)"\u672a\u627e\u5230\u76f8\u5e94\u9875\u9762", (int)0).show();
        }
    }

    public static class ActivityResultCode {
        public static final int TAKE_PICTURE = 257;
        public static final int TAKE_VIDEO = 258;
        public static final int SELECT_FILE = 259;
        public static final int SELECT_MEDIA = 260;
        public static final int START_LOCATE = 262;
        public static final int PUBLISH_BROWSE_AUTH = 263;
        public static final int PUBLISH_TYPE = 264;
        public static final int SELECT_PERSON = 265;
        public static final int SELECT_DEPT = 272;
    }

    public static final class INTENT {
        public static final String LAST_ITEM_TIME_STAMP = "last_item_time_stamp";
        public static final String LOAD_COUNT = "loadCount";
        public static final String USER_ID = "userId";
        public static final String FILE_BEAN = "file_bean";
        public static final String MOMENT_ID = "moment_id";
        public static final String COMMENT_ID = "comment_id";
        public static final String SHOW_INPUT_COMMENT = "show_input_comment";
        public static final String SCROLL_TO_FIRST = "show_first_comment";
        public static final String IS_VERIFY_TO_DETAIL = "is_verify_to_detail";
        public static final String CLASSIFY_ID = "classify_id";
        public static final String BROWSE_AUTH = "browse_auth";
        public static final String BROWSE_AUTH_VALUE = "browse_auth_value";
        public static final String FROM_TOPIC_RELEASE = "from_topic_release";
        public static final String TITLE = "title";
        public static final String IS_MINE = "is_mine";
        public static final String URL = "url";
        public static final String EXTRA_IMAGE_INDEX = "image_index";
        public static final String EXTRA_IMAGE_URLS = "image_urls";
        public static final String EXTRA_VIDEO = "extra_video";
        public static final String EXTRA_PUBLISH_CONTENT = "publish_content";
        public static final String EXTRA_PUBLISH_FILE = "publish_file_path";
        public static final String EXTRA_PUBLISH_SHARE_BEAN = "publish_share_bean";
    }
}

