/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.database.dao;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityDeletionOrUpdateAdapter;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.persistence.room.RxRoom;
import android.arch.persistence.room.SharedSQLiteStatement;
import android.database.Cursor;
import com.xdja.moments.sdk.database.dao.NewMomentsDao;
import com.xdja.moments.sdk.database.domain.NewMomentsNotification;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public class NewMomentsDao_Impl
implements NewMomentsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfNewMomentsNotification;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfNewMomentsNotification;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfNewMomentsNotification;
    private final SharedSQLiteStatement __preparedStmtOfDeleteNewMomentsByClassify;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public NewMomentsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfNewMomentsNotification = new EntityInsertionAdapter<NewMomentsNotification>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `new_moments`(`moments_id`,`classify_id`,`create_time`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, NewMomentsNotification value) {
                if (value.getMomentsId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMomentsId());
                }
                if (value.getClassifyId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getClassifyId());
                }
                stmt.bindLong(3, value.getCreateTime());
            }
        };
        this.__deletionAdapterOfNewMomentsNotification = new EntityDeletionOrUpdateAdapter<NewMomentsNotification>(__db){

            public String createQuery() {
                return "DELETE FROM `new_moments` WHERE `moments_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, NewMomentsNotification value) {
                if (value.getMomentsId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMomentsId());
                }
            }
        };
        this.__updateAdapterOfNewMomentsNotification = new EntityDeletionOrUpdateAdapter<NewMomentsNotification>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `new_moments` SET `moments_id` = ?,`classify_id` = ?,`create_time` = ? WHERE `moments_id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, NewMomentsNotification value) {
                if (value.getMomentsId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMomentsId());
                }
                if (value.getClassifyId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getClassifyId());
                }
                stmt.bindLong(3, value.getCreateTime());
                if (value.getMomentsId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getMomentsId());
                }
            }
        };
        this.__preparedStmtOfDeleteNewMomentsByClassify = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM new_moments where classify_id=?";
                return "DELETE FROM new_moments where classify_id=?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM new_moments";
                return "DELETE FROM new_moments";
            }
        };
    }

    @Override
    public void insertItem(NewMomentsNotification item) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNewMomentsNotification.insert((Object)item);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertItems(List<NewMomentsNotification> items) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNewMomentsNotification.insert(items);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteItem(NewMomentsNotification item) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfNewMomentsNotification.handle((Object)item);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateItem(NewMomentsNotification item) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfNewMomentsNotification.handle((Object)item);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNewMomentsByClassify(String classifyId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteNewMomentsByClassify.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (classifyId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, classifyId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteNewMomentsByClassify.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Flowable<Integer> getNewMomentsCount() {
        String _sql = "SELECT  COUNT(*) FROM new_moments ";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT  COUNT(*) FROM new_moments ", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"new_moments"}, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = NewMomentsDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<List<NewMomentsNotification>> getNewMoments() {
        String _sql = "SELECT * FROM new_moments";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM new_moments", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"new_moments"}, (Callable)new Callable<List<NewMomentsNotification>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<NewMomentsNotification> call() throws Exception {
                try (Cursor _cursor = NewMomentsDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfMomentsId = _cursor.getColumnIndexOrThrow("moments_id");
                    int _cursorIndexOfClassifyId = _cursor.getColumnIndexOrThrow("classify_id");
                    int _cursorIndexOfCreateTime = _cursor.getColumnIndexOrThrow("create_time");
                    ArrayList<NewMomentsNotification> _result = new ArrayList<NewMomentsNotification>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        NewMomentsNotification _item = new NewMomentsNotification();
                        String _tmpMomentsId = _cursor.getString(_cursorIndexOfMomentsId);
                        _item.setMomentsId(_tmpMomentsId);
                        String _tmpClassifyId = _cursor.getString(_cursorIndexOfClassifyId);
                        _item.setClassifyId(_tmpClassifyId);
                        long _tmpCreateTime = _cursor.getLong(_cursorIndexOfCreateTime);
                        _item.setCreateTime(_tmpCreateTime);
                        _result.add(_item);
                    }
                    ArrayList<NewMomentsNotification> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<List<String>> getNewMomentClassify() {
        String _sql = "SELECT distinct classify_id FROM new_moments";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT distinct classify_id FROM new_moments", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"new_moments"}, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws Exception {
                try (Cursor _cursor = NewMomentsDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.getString(0);
                        _result.add(_item);
                    }
                    ArrayList<String> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<Integer> getNewMomentsCount(String classifyId) {
        String _sql = "SELECT  COUNT(*) FROM new_moments where classify_id=?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT  COUNT(*) FROM new_moments where classify_id=?", (int)1);
        int _argIndex = 1;
        if (classifyId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, classifyId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"new_moments"}, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = NewMomentsDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

