/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.database.domain.MomentsPower;
import com.xdja.moments.sdk.flow.MomentsFragment;
import com.xdja.moments.sdk.flow.MomentsMainActivityPermissionsDispatcher;
import com.xdja.moments.sdk.viewmodel.MomentsPowerViewModel;
import com.xdja.moments.sdk.viewmodel.MomentsReviewViewModel;
import com.xdja.moments.sdk.widget.popwindow.MomentsMainPop;
import permissions.dispatcher.NeedsPermission;
import permissions.dispatcher.OnNeverAskAgain;
import permissions.dispatcher.OnPermissionDenied;
import permissions.dispatcher.RuntimePermissions;

@RuntimePermissions
@Route(path="/main/momentMain")
public class MomentsMainActivity
extends BaseActivity
implements Toolbar.OnMenuItemClickListener,
MomentsMainPop.OnItemClickListener,
Observer<MomentsPower> {
    private View newDot;
    private View actionMoreView;
    private TextView myMomentsNumber;
    private MomentsMainPop pop;
    private MomentsPowerViewModel powerViewModel;
    private MomentsReviewViewModel reviewViewModel;

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        MomentsMainActivityPermissionsDispatcher.gaintPermissionsWithPermissionCheck(this);
    }

    protected void preGetRootView(Bundle savedInstanceState) {
        this.hideNavigationMenu();
        super.preGetRootView(savedInstanceState);
    }

    protected void initView() {
        this.setMomentsTitle("\u5de5\u4f5c\u5708");
        this.toolbar.setOnMenuItemClickListener((Toolbar.OnMenuItemClickListener)this);
    }

    protected int getRootView() {
        return R.layout.moments_activity_main;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.moments_menu_main, menu2);
        MenuItem itemMore = menu2.findItem(R.id.action_more);
        View moreRootView = itemMore.getActionView();
        this.newDot = moreRootView.findViewById(R.id.new_dot);
        this.actionMoreView = moreRootView.findViewById(R.id.moments_menu_more);
        moreRootView.setOnClickListener(view -> this.onMenuItemClick(itemMore));
        MenuItem itemMyMoments = menu2.findItem(R.id.action_my_moments);
        View myMomentRootView = itemMyMoments.getActionView();
        this.myMomentsNumber = (TextView)myMomentRootView.findViewById(R.id.tv_number);
        myMomentRootView.setOnClickListener(view -> this.onMenuItemClick(itemMyMoments));
        this.initViewModel();
        return super.onCreateOptionsMenu(menu2);
    }

    @NeedsPermission(value={"android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO", "android.permission.VIBRATE", "android.permission.CAMERA"})
    void gaintPermissions() {
        MomentsFragment momentsFragment = new MomentsFragment();
        this.getSupportFragmentManager().beginTransaction().replace(R.id.contentLayout, (Fragment)momentsFragment).commit();
    }

    @OnNeverAskAgain(value={"android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO", "android.permission.CAMERA"})
    void showNeverAskForPermissions() {
        this.showPermissionDeniedDialog(R.string.moments_permission_setting);
    }

    @OnPermissionDenied(value={"android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.RECORD_AUDIO", "android.permission.CAMERA"})
    void showDeniedForPermissions() {
        this.showPermissionDeniedDialog(R.string.moments_permission_setting);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        MomentsMainActivityPermissionsDispatcher.onRequestPermissionsResult(this, requestCode, grantResults);
    }

    private void initViewModel() {
        this.powerViewModel = (MomentsPowerViewModel)ViewModelProviders.of((FragmentActivity)this).get(MomentsPowerViewModel.class);
        this.powerViewModel.getMomentsPower().observe((LifecycleOwner)this, (Observer)this);
        this.reviewViewModel = (MomentsReviewViewModel)ViewModelProviders.of((FragmentActivity)this).get(MomentsReviewViewModel.class);
        this.reviewViewModel.getAllReviewCount().observe((LifecycleOwner)this, (Observer)new Observer<Integer>(){

            public void onChanged(@Nullable Integer integer) {
                if (integer != null && MomentsMainActivity.this.myMomentsNumber != null) {
                    if (integer > 0) {
                        MomentsMainActivity.this.myMomentsNumber.setVisibility(0);
                        MomentsMainActivity.this.myMomentsNumber.setText((CharSequence)(integer > 99 ? "99" : integer.toString()));
                        MomentsMainActivity.this.newDot.setVisibility(0);
                    } else {
                        MomentsMainActivity.this.myMomentsNumber.setVisibility(8);
                        MomentsMainActivity.this.newDot.setVisibility(8);
                    }
                }
            }
        });
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.action_release) {
            Navigation.navigationPublishMoments();
        } else if (menuItem.getItemId() == R.id.action_my_moments) {
            Navigation.navigationMyMoments();
            this.reviewViewModel.removeReviewByType("reviewFail");
        } else if (menuItem.getItemId() == R.id.action_more) {
            if (this.pop == null) {
                this.pop = new MomentsMainPop((AppCompatActivity)this, this.actionMoreView);
                this.pop.setOnItemClickLsitener(this);
            }
            this.pop.show(0, 0, -1);
        }
        return false;
    }

    @Override
    public void onMyCommentsClick() {
        Navigation.navigationMyMoments();
    }

    @Override
    public void onReviewCommentsClick() {
        Navigation.navigationMomentReview();
    }

    public void setMenuVisible(boolean visible, @IdRes int menuId) {
        Menu menu2 = this.toolbar.getMenu();
        if (menu2 == null) {
            return;
        }
        MenuItem menuItem = menu2.findItem(menuId);
        if (menuItem == null) {
            return;
        }
        menuItem.setVisible(visible);
    }

    public void onChanged(@Nullable MomentsPower momentsPower) {
        if (momentsPower == null) {
            return;
        }
        if (this.pop != null && this.pop.isShowing()) {
            this.pop.hide();
        }
        if ("1".equals(momentsPower.getPublishMomentPower())) {
            this.setMenuVisible(true, R.id.action_release);
        } else {
            this.setMenuVisible(false, R.id.action_release);
        }
        if ("1".equals(momentsPower.getVerifyMomentPower())) {
            this.setMenuVisible(true, R.id.action_more);
            this.setMenuVisible(false, R.id.action_my_moments);
        } else {
            this.setMenuVisible(true, R.id.action_my_moments);
            this.setMenuVisible(false, R.id.action_more);
        }
    }

    protected void hideNavigationMenu() {
        if (Build.VERSION.SDK_INT < 19) {
            View v = this.getWindow().getDecorView();
            if (v != null) {
                v.setSystemUiVisibility(8);
            }
        } else {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 4098;
            if (decorView != null) {
                decorView.setSystemUiVisibility(uiOptions);
            }
        }
    }
}

