/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.base.business.impl;

import android.arch.lifecycle.Lifecycle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.moments.sdk.flow.base.business.BaseMomentListBusiness;
import com.xdja.moments.sdk.flow.base.business.impl.BaseMomentBusinessImpl;
import com.xdja.moments.sdk.flow.detail.mvp.MomentsSaveCommentModel;
import com.xdja.moments.sdk.flow.main.mvp.DeleteCommentModel;
import com.xdja.moments.sdk.flow.main.mvp.MomentsHideModel;
import com.xdja.moments.sdk.flow.main.mvp.MomentsPraiseModel;
import com.xdja.moments.sdk.flow.review.mvp.MomentsDeleteModel;
import com.xdja.moments.sdk.http.bean.request.DeleteCommentParams;
import com.xdja.moments.sdk.http.bean.request.MomentDeleteParams;
import com.xdja.moments.sdk.http.bean.request.MomentHideParams;
import com.xdja.moments.sdk.http.bean.request.MomentPraiseParams;
import com.xdja.moments.sdk.http.bean.request.MomentsSaveComment;
import com.xdja.moments.sdk.http.bean.response.PraiseResponseBean;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Observable;

public class BaseMomentListBusinessImpl
extends BaseMomentBusinessImpl
implements BaseMomentListBusiness {
    private MomentsDeleteModel momentsDeleteModel;
    private MomentsHideModel momentsHideModel;
    private MomentsPraiseModel momentsPraiseModel;
    private DeleteCommentModel deleteCommentModel;
    private MomentsSaveCommentModel saveCommentModel;
    private LifecycleProvider<Lifecycle.Event> provider;

    public BaseMomentListBusinessImpl(LifecycleProvider<Lifecycle.Event> provider) {
        super(provider);
        this.provider = provider;
        this.momentsDeleteModel = new MomentsDeleteModel();
        this.momentsHideModel = new MomentsHideModel();
        this.momentsPraiseModel = new MomentsPraiseModel();
        this.deleteCommentModel = new DeleteCommentModel();
        this.saveCommentModel = new MomentsSaveCommentModel();
    }

    @Override
    public Observable<Object> deleteMoments(String momentId) {
        MomentDeleteParams requestBean = new MomentDeleteParams();
        requestBean.setMomentId(momentId);
        return this.momentsDeleteModel.deleteMoments(requestBean).compose(MomentsRxTransformer.momentsComposeNet(this.provider, requestBean));
    }

    @Override
    public Observable<Object> hideMoments(String momentId) {
        MomentHideParams requestBean = new MomentHideParams();
        requestBean.setMomentId(momentId);
        return this.momentsHideModel.hideMoments(requestBean).compose(MomentsRxTransformer.momentsComposeNet(this.provider, requestBean));
    }

    @Override
    public Observable<Object> deleteComment(String commentId) {
        DeleteCommentParams requestBean = new DeleteCommentParams();
        requestBean.setCommentId(commentId);
        return this.deleteCommentModel.deleteComment(requestBean).compose(MomentsRxTransformer.momentsComposeNet(this.provider, requestBean));
    }

    @Override
    public Observable<PraiseResponseBean> praiseMoments(String momentId, String praiseFlag) {
        MomentPraiseParams requestBean = new MomentPraiseParams();
        requestBean.setPraiseFlag(praiseFlag);
        requestBean.setMomentId(momentId);
        return this.momentsPraiseModel.praiseMoments(requestBean).compose(MomentsRxTransformer.momentsComposeNet(this.provider, requestBean));
    }

    @Override
    public Observable<Object> saveComment(MomentsSaveComment info) {
        return this.saveCommentModel.saveComment(info).compose(MomentsRxTransformer.momentsComposeNet(this.provider, info));
    }
}

