/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.base.fragment;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.constraint.Group;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.orhanobut.logger.Logger;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.xdja.baselibrary.base.BaseFragment;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.eventbus.MomentsPageInfo;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.widget.input.InputLinearLayout;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class BaseListFragment
extends BaseFragment
implements OnRefreshLoadMoreListener,
IBaseView {
    private boolean needCoverLoading = true;
    protected SmartRefreshLayout mRefreshLayout;
    protected RecyclerView mRecyclerView;
    protected long pageTimeStamp = 0L;
    protected boolean pageIsLast = false;
    protected boolean pageIsFirst = true;
    protected InputLinearLayout inputLinearLayout;
    protected Group commentGroupLayout;
    private XRecyclerViewAdapter xRecyclerViewAdapter;

    protected int getRootView() {
        return R.layout.moments_list_fragment;
    }

    protected void initView(View rootView, LayoutInflater inflater) {
        this.inputLinearLayout = (InputLinearLayout)rootView.findViewById(R.id.input_layout);
        this.commentGroupLayout = (Group)rootView.findViewById(R.id.comment_layout);
        this.commentGroupLayout.setVisibility(8);
        this.mRefreshLayout = (SmartRefreshLayout)rootView.findViewById(R.id.refreshLayout);
        if (!MomentsManager.getInstance().isCustomHeader()) {
            this.mRefreshLayout.setRefreshHeader((RefreshHeader)new ClassicsHeader(this.getActivity().getApplicationContext()).setProgressResource(R.drawable.moments_progressbar_loading));
        }
        if (!MomentsManager.getInstance().isCustomFooter()) {
            this.mRefreshLayout.setRefreshFooter((RefreshFooter)new ClassicsFooter(this.getActivity().getApplicationContext()).setProgressResource(R.drawable.moments_progressbar_loading));
        }
        this.mRefreshLayout.setOnRefreshLoadMoreListener((OnRefreshLoadMoreListener)this);
        this.mRecyclerView = (RecyclerView)rootView.findViewById(R.id.recyclerView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.xRecyclerViewAdapter = this.setUpAdapter();
    }

    protected abstract XRecyclerViewAdapter<MomentsBean> setUpAdapter();

    protected ViewGroup getErrorParentView() {
        return this.mRefreshLayout;
    }

    protected LoadingType getLoadingType() {
        return this.needCoverLoading ? LoadingType.LOAD_TYPE_COVER : LoadingType.LOAD_TYPE_NONE;
    }

    protected void showEmptyLayout(String emptyText, @DrawableRes int emptyImage) {
        super.showEmptyLayout(emptyText, emptyImage);
        this.needCoverLoading = true;
    }

    protected void showErrorLayout(String errorInfo, @DrawableRes int errorImage) {
        super.showErrorLayout(errorInfo, errorImage);
        this.needCoverLoading = true;
    }

    protected void showNoNetLayout(String netErrorText, String subText) {
        super.showNoNetLayout(netErrorText, subText);
        this.needCoverLoading = true;
    }

    public void showLoading(String msg, String key) {
        super.showLoading(msg, key);
    }

    public void hideLoading(String key) {
        super.hideLoading(key);
        this.needCoverLoading = false;
        this.mRefreshLayout.finishLoadMore();
        this.mRefreshLayout.finishRefresh();
    }

    public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
        this.initData(this.provider);
    }

    public void onRefresh(@NonNull RefreshLayout refreshLayout) {
        this.pageTimeStamp = 0L;
        this.initData(this.provider);
    }

    protected boolean initEventBus() {
        return true;
    }

    protected abstract String getPageListRequestId();

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onGetPageInfo(MomentsPageInfo pageInfo) {
        if (!pageInfo.getMessageId().equals(this.getPageListRequestId())) {
            return;
        }
        Logger.d((Object)("\u5206\u9875\u4fe1\u606f\uff1a" + pageInfo.toString()));
        this.pageTimeStamp = pageInfo.getTimeStamp();
        this.pageIsFirst = pageInfo.isFirstPage();
        this.pageIsLast = pageInfo.isLastPage();
        if (this.pageIsLast) {
            this.mRefreshLayout.setEnableLoadMore(false);
            if (this.xRecyclerViewAdapter != null) {
                this.xRecyclerViewAdapter.showLoadComplete(this.loadFinishText());
            }
        } else {
            this.mRefreshLayout.setEnableLoadMore(true);
        }
    }

    protected String loadFinishText() {
        return this.getString(R.string.moments_finish_load);
    }
}

