/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.base.fragment;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ViewModelProviders;
import android.support.annotation.DrawableRes;
import android.support.v4.app.Fragment;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.decoration.DividerDecoration;
import com.xdja.baselibrary.exception.MomentsBaseException;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.flow.base.adapter.MomentsListAdapter;
import com.xdja.moments.sdk.flow.base.fragment.BaseListFragment;
import com.xdja.moments.sdk.flow.base.moments.BaseMomentListPresenter;
import com.xdja.moments.sdk.flow.base.moments.IBaseMomentListView;
import com.xdja.moments.sdk.http.bean.request.MomentsSaveComment;
import com.xdja.moments.sdk.http.bean.response.PraiseResponseBean;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.utils.SoftHideKeyBoardUtil;
import com.xdja.moments.sdk.viewmodel.MomentsClassifyViewModel;
import com.xdja.moments.sdk.viewmodel.MomentsConfigViewModel;
import com.xdja.moments.sdk.widget.input.InputLinearLayout;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class BaseMomentListFragment
extends BaseListFragment
implements OnRefreshLoadMoreListener,
IBaseMomentListView,
MomentsListAdapter.OnMoreArrowClickListener,
MomentsListAdapter.OnDeleteCommentListener,
MomentsListAdapter.OnPraiseClickListener,
MomentsListAdapter.OnCommentIconClickListener,
InputLinearLayout.SendClickListener,
View.OnTouchListener {
    protected List<MomentsBean> momentsBeanList = new ArrayList<MomentsBean>();
    protected MomentsBean currentOperatorMoment;
    protected MomentsListAdapter momentsListAdapter;
    protected CommentBean currentCommentBean;
    protected boolean enableTransmit = true;
    protected boolean enableHide = true;
    private String commentToUserId;
    private String commentMomentId;
    private long praiseTime;

    protected abstract BaseMomentListPresenter getPresenter();

    @Override
    protected XRecyclerViewAdapter<MomentsBean> setUpAdapter() {
        SoftHideKeyBoardUtil.assistActivity((Activity)this.getActivity());
        this.inputLinearLayout.initView((Activity)this.getActivity(), false, this);
        this.momentsListAdapter = new MomentsListAdapter(this.mRecyclerView, this.momentsBeanList, (Activity)this.getActivity());
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.momentsListAdapter);
        this.momentsListAdapter.setOnMoreArrowClickListener(this);
        this.momentsListAdapter.setOnPraiseClickListener(this);
        this.momentsListAdapter.setOnDeleteCommentListener(this);
        this.momentsListAdapter.setOnCommentClickListener(this);
        this.mRecyclerView.setOnTouchListener((View.OnTouchListener)this);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerDecoration(this.getResources().getColor(R.color.moments_driver_line), 2));
        this.loadConfigAndClassify();
        return this.momentsListAdapter;
    }

    @Override
    public void onMoreArrowClick(MomentsBean data) {
        if (data.getUserInfo() == null) {
            return;
        }
        this.currentOperatorMoment = data;
    }

    @Override
    public void onPraiseClick(MomentsBean data) {
        this.praiseTime = System.currentTimeMillis();
        this.setOnceLoadingType(LoadingType.LOAD_TYPE_NONE);
        this.getPresenter().praiseMoments(data.getMomentId(), "1".equals(data.getPraiseFlag()) ? "2" : "1");
    }

    public void showError(MomentsBaseException ex) {
        super.showError(ex);
        if (ex.keyPath.equals("momentPraise/updateMomentPraise")) {
            this.momentsListAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onClickDeleteComment(MomentsBean momentsBean, CommentBean commentBean) {
        this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
        this.currentCommentBean = commentBean;
        this.currentOperatorMoment = momentsBean;
        this.getPresenter().deleteComment(commentBean.getCommentId());
    }

    @Override
    public void onDeleteMomentsSuccess() {
        this.momentsListAdapter.remove(this.currentOperatorMoment);
        if (this.momentsBeanList.size() == 0) {
            this.pageTimeStamp = 0L;
            this.showEmptyLayout(this.getString(R.string.moments_info_no_moment), R.drawable.moments_img_no_mement);
        }
    }

    @Override
    public void onDeleteCommentsSuccess() {
        if (this.currentCommentBean == null) {
            return;
        }
        for (MomentsBean momentsBean : this.momentsBeanList) {
            if (!this.currentOperatorMoment.equals(momentsBean)) continue;
            momentsBean.getCommentList().remove(this.currentCommentBean);
            break;
        }
        this.currentOperatorMoment.setCommentCount(this.currentOperatorMoment.getCommentCount() - 1);
        this.momentsListAdapter.notifyDataSetChanged();
        this.currentCommentBean = null;
    }

    @Override
    public void onPraiseSuccess(PraiseResponseBean praiseResponseBean) {
        for (MomentsBean momentsBean : this.momentsBeanList) {
            if (!momentsBean.getMomentId().equals(praiseResponseBean.getMomentId())) continue;
            momentsBean.setPraiseFlag(praiseResponseBean.getPraiseFlag());
            if ("1".equals(praiseResponseBean.getPraiseFlag())) {
                momentsBean.setPraiseCount(momentsBean.getPraiseCount() + 1);
            } else {
                momentsBean.setPraiseCount(momentsBean.getPraiseCount() - 1);
            }
            for (UserInfoBean userInfoBean : momentsBean.getPraiseList()) {
                if (userInfoBean == null || !userInfoBean.getUserId().equals(MomentsManager.getInstance().getLoginer().getUserId())) continue;
                momentsBean.getPraiseList().remove(userInfoBean);
                break;
            }
            if (!"1".equals(praiseResponseBean.getPraiseFlag())) continue;
            momentsBean.getPraiseList().add(MomentsManager.getInstance().getLoginer());
        }
        long underGo = System.currentTimeMillis() - this.praiseTime - 600L;
        if (underGo > 0L) {
            this.momentsListAdapter.notifyDataSetChanged();
        } else {
            Disposable disposable = Observable.create(emitter -> emitter.onNext(new Object())).delay(Math.abs(underGo), TimeUnit.MILLISECONDS).compose(ObservableTransfor.io_main()).compose((ObservableTransformer)this.provider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(o -> this.momentsListAdapter.notifyDataSetChanged());
        }
    }

    @Override
    public void onHideSuccess() {
        this.momentsListAdapter.remove(this.currentOperatorMoment);
        if (this.momentsBeanList.size() == 0) {
            this.pageTimeStamp = 0L;
            this.showEmptyLayout(this.getString(R.string.moments_info_no_moment), R.drawable.moments_img_no_mement);
        }
    }

    @Override
    protected void showErrorLayout(String errorInfo, @DrawableRes int errorImage) {
        super.showErrorLayout(errorInfo, R.drawable.moments_img_error_mement);
    }

    @Override
    public void onGetMomentsFinish(List<MomentsBean> momentsList) {
        if (this.getContext() == null) {
            return;
        }
        if (momentsList == null || momentsList.size() == 0) {
            if (this.pageIsFirst) {
                this.showEmptyLayout(this.getContext().getString(R.string.moments_info_no_moment), R.drawable.moments_img_no_mement);
            } else {
                this.mRefreshLayout.setEnableLoadMore(false);
            }
            return;
        }
        if (this.pageIsFirst) {
            this.momentsBeanList.clear();
        }
        this.momentsBeanList.addAll(momentsList);
        this.momentsListAdapter.notifyDataSetChanged();
    }

    @Override
    protected void showNoNetLayout(String netErrorText, String subText) {
        if (this.momentsBeanList.size() == 0) {
            super.showNoNetLayout(netErrorText, subText);
        } else {
            this.showToast(this.getResources().getString(R.string.moments_net_error_retry));
        }
    }

    protected BottomDialogType initBottomMenuDialog() {
        return BottomDialogType.BOTTOM_TYPE_LIST;
    }

    private void loadConfigAndClassify() {
        MomentsConfigViewModel configViewModel = (MomentsConfigViewModel)ViewModelProviders.of((Fragment)this).get(MomentsConfigViewModel.class);
        configViewModel.getMomentsConfig().observe((LifecycleOwner)this, momentsConfig -> {
            if (momentsConfig == null) {
                return;
            }
            this.momentsListAdapter.onMomentsConfigChanged((MomentsConfig)momentsConfig);
            this.enableTransmit = "on".equals(momentsConfig.getSwitchForwardMoment());
            this.enableHide = "on".equals(momentsConfig.getSwitchHideMoment());
        });
        MomentsClassifyViewModel classifyViewModel = (MomentsClassifyViewModel)ViewModelProviders.of((Fragment)this).get(MomentsClassifyViewModel.class);
        classifyViewModel.getAllMomentsClassIfy().observe((LifecycleOwner)this, classifyList -> this.momentsListAdapter.onMomentsClassifyChanged((List<MomentsClassify>)classifyList));
    }

    @Override
    public void hideLoading(String key) {
        if (!"momentComment/saveMomentComment".equals(key)) {
            super.hideLoading(key);
        }
        this.hideKeyboard();
    }

    @Override
    public void onCommentIconClick(MomentsBean data) {
        this.commentGroupLayout.setVisibility(0);
        this.commentMomentId = data.getMomentId();
        this.commentToUserId = null;
        this.inputLinearLayout.getEditText().requestFocus();
        this.showKeyboard(this.inputLinearLayout.getEditText());
        this.inputLinearLayout.setHint(this.getString(R.string.moments_comment_hint));
    }

    @Override
    public void onCommentItemClick(String momentId, CommentBean data) {
        this.commentGroupLayout.setVisibility(0);
        this.commentMomentId = momentId;
        this.commentToUserId = data.getUserInfo().getUserId();
        this.inputLinearLayout.getEditText().requestFocus();
        this.showKeyboard(this.inputLinearLayout.getEditText());
        if (!this.commentToUserId.equals(MomentsManager.getInstance().getLoginer().getUserId())) {
            this.inputLinearLayout.setHint(String.format(this.getString(R.string.moments_comment_to), data.getUserInfo().getUserName()));
        } else {
            this.inputLinearLayout.setHint(this.getString(R.string.moments_comment_hint));
        }
    }

    @Override
    public void onSendClick(String content) {
        this.inputLinearLayout.hideKeyboardAndEmoji();
        this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
        MomentsSaveComment params = new MomentsSaveComment();
        params.setCommentContent(content);
        params.setMomentId(this.commentMomentId);
        if (!TextUtils.isEmpty((CharSequence)this.commentToUserId) && !this.commentToUserId.equals(MomentsManager.getInstance().getLoginer().getUserId())) {
            params.setToUserId(this.commentToUserId);
        }
        this.getPresenter().saveComment(params);
    }

    @Override
    public void onCommentSuccess() {
        this.hideKeyboard();
        this.commentGroupLayout.setVisibility(8);
        this.inputLinearLayout.clear();
        this.pageTimeStamp = 0L;
        this.initData(this.provider);
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.hideKeyboard();
        this.inputLinearLayout.hideKeyboardAndEmoji();
        this.commentGroupLayout.setVisibility(8);
        return false;
    }
}

