/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.business.imp;

import android.arch.lifecycle.Lifecycle;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BasePageResponse;
import com.xdja.moments.sdk.bean.CommentBean;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.flow.base.business.impl.BaseMomentBusinessImpl;
import com.xdja.moments.sdk.flow.detail.business.MomentDetailBusiness;
import com.xdja.moments.sdk.flow.detail.mvp.CommentDetailModel;
import com.xdja.moments.sdk.flow.detail.mvp.MomentsDetailModel;
import com.xdja.moments.sdk.http.bean.request.GetCommentDetaiParam;
import com.xdja.moments.sdk.http.bean.request.GetMomentsDetailParam;
import com.xdja.moments.sdk.http.bean.response.CommentResponseBean;
import com.xdja.moments.sdk.http.bean.response.MomentsResponseBean;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Observable;
import java.util.List;

public class MomentDetailBusinessImp
extends BaseMomentBusinessImpl
implements MomentDetailBusiness {
    private MomentsDetailModel momentsDetailModel = new MomentsDetailModel();
    private CommentDetailModel commentDetailModel = new CommentDetailModel();

    public MomentDetailBusinessImp(LifecycleProvider provider) {
        super((LifecycleProvider<Lifecycle.Event>)provider);
    }

    @Override
    public Observable<MomentsBean> getMomentDetailFromNet(String momentId) {
        GetMomentsDetailParam param = new GetMomentsDetailParam();
        param.setMomentId(momentId);
        return this.momentsDetailModel.getDetail(param).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.provider, param)).map(momentsResponseBean -> this.getMomentsABean((MomentsResponseBean)momentsResponseBean));
    }

    @Override
    public Observable<BasePageResponse<List<CommentBean>>> getCommentDetailFromNet(String momentId, long timeStamp) {
        GetCommentDetaiParam param = new GetCommentDetaiParam();
        if (timeStamp > 0L) {
            param.setTimeStamp(timeStamp);
        }
        param.setMomentId(momentId);
        return this.commentDetailModel.getCommentsDetail(param).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.provider, param)).map(listBasePageResponse -> this.getCommentBeanList((BasePageResponse<List<CommentResponseBean>>)listBasePageResponse));
    }

    private BasePageResponse<List<CommentBean>> getCommentBeanList(BasePageResponse<List<CommentResponseBean>> listBasePageResponse) {
        List responseList = (List)listBasePageResponse.getData();
        List<CommentBean> resultList = this.buildCommentList(responseList);
        BasePageResponse result = new BasePageResponse();
        result.setData(resultList);
        result.setFirstPage(listBasePageResponse.isFirstPage());
        result.setLastPage(listBasePageResponse.isLastPage());
        result.setPageCount(listBasePageResponse.getPageCount());
        result.setPageNum(listBasePageResponse.getPageNum());
        result.setPageSize(listBasePageResponse.getPageSize());
        result.setTimeStamp(listBasePageResponse.getTimeStamp());
        result.setTotal(listBasePageResponse.getTotal());
        return result;
    }
}

