/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.file;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.orhanobut.logger.Logger;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.base.BottomDialogType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.exception.MomentsBaseException;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.FileBean;
import com.xdja.moments.sdk.database.domain.DownInfo;
import com.xdja.moments.sdk.http.download.DownLoadListener.HttpDownOnNextListener;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.http.download.HttpDownManager;
import com.xdja.moments.sdk.manager.FileTypeManager;
import com.xdja.moments.sdk.repository.DownInfoRepository;
import com.xdja.moments.sdk.utils.FileProviderUtils;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.widget.MyProgressWheel;
import io.reactivex.FlowableTransformer;
import java.io.File;
import java.util.ArrayList;

@Route(path="/detail/fileDetail")
public class FileDetailActivity
extends BaseActivity
implements View.OnClickListener {
    @Autowired(name="file_bean")
    public FileBean fileBean;
    private ImageView mImgMomentFileType;
    private TextView mTvFileName;
    private TextView mTvFileSize;
    private TextView mBtnDownload;
    private ImageView pBarBgImage;
    private MyProgressWheel myProgressWheel;
    private DownInfo downInfo;
    private HttpDownManager downloadManager;

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        this.downloadManager = HttpDownManager.getInstance();
        if (this.fileBean != null) {
            DownInfoRepository.getInstance().getDownloadInfoByFileId(this.fileBean.getDownLoadUrl()).compose(FlowableTransfor.io_main()).compose((FlowableTransformer)provider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(downInfo -> {
                downInfo.setUpdateProgress(true);
                this.downInfo = downInfo;
                this.mBtnDownload.setEnabled(true);
                if (this.downInfo != null) {
                    this.refresh();
                }
            }, Throwable::printStackTrace);
        }
    }

    protected void initView() {
        ARouter.getInstance().inject((Object)this);
        this.setMomentsTitle(this.getString(R.string.moments_file_detail));
        this.mImgMomentFileType = (ImageView)this.findViewById(R.id.img_moment_file_type);
        this.mTvFileName = (TextView)this.findViewById(R.id.tv_file_name);
        this.mTvFileSize = (TextView)this.findViewById(R.id.tv_file_size);
        this.mBtnDownload = (TextView)this.findViewById(R.id.btn_download);
        this.mBtnDownload.setOnClickListener((View.OnClickListener)this);
        this.pBarBgImage = (ImageView)this.findViewById(R.id.img_loadingbg);
        this.myProgressWheel = (MyProgressWheel)this.findViewById(R.id.pb_sending_file);
        this.mImgMomentFileType.setImageResource(FileUtil.getFileDrawable(this.fileBean.getFileExt()));
        this.mTvFileName.setText((CharSequence)this.fileBean.getFileName());
        this.mTvFileSize.setText((CharSequence)String.format(this.getString(R.string.moments_file_size), FileUtil.getSizeString(this.fileBean.getFileSize())));
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.moments_menu_detail, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    protected BottomDialogType initBottomMenuDialog() {
        return BottomDialogType.BOTTOM_TYPE_LIST;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.operate) {
            ArrayList<BottomMenuBean> list = new ArrayList<BottomMenuBean>();
            list.add(new BottomMenuBean(R.drawable.moments_icon_tran, this.getString(R.string.moments_bottom_menu_transmit)));
            this.showBottomMenu(list);
        }
        return false;
    }

    protected int getRootView() {
        return R.layout.moments_activity_file_detail;
    }

    protected void onBottomMenuItemClick(int position) {
        switch (position) {
            case 0: {
                if (this.downInfo != null && this.downInfo.getState() == DownState.FINISH) {
                    if (FileUtil.isFileExist(this.downInfo.getSavePath())) {
                        Navigation.shareFileTo(this.downInfo.getSavePath());
                        break;
                    }
                    this.downInfo.setState(DownState.START);
                    this.downInfo.setReadLength(0L);
                    this.mBtnDownload.setText(R.string.moments_download);
                    this.showToast(this.getString(R.string.moments_file_transmit_down_first));
                    break;
                }
                this.showToast(this.getString(R.string.moments_file_transmit_down_first));
            }
        }
        this.hideBottomMenu();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_download) {
            if (this.downInfo != null) {
                if (this.downInfo.getState() == DownState.START) {
                    this.downloadFile();
                } else if (this.downInfo.getState() == DownState.ERROR) {
                    this.downloadFile();
                } else if (this.downInfo.getState() == DownState.PAUSE) {
                    this.downloadFile();
                } else if (this.downInfo.getState() == DownState.FINISH) {
                    this.openFile(this.downInfo.getSavePath());
                } else if (this.downInfo.getState() == DownState.DOWN) {
                    this.downloadManager.pause(this.downInfo);
                }
            } else if (this.fileBean != null && FileUtil.isFileExist(FileUtil.getSavePath(this.fileBean.getDownLoadUrl()))) {
                this.openFile(FileUtil.getSavePath(this.fileBean.getDownLoadUrl()));
            }
        }
    }

    private void openFile(String path) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        File file = new File(path);
        String type = FileTypeManager.getMimeType(file.getAbsolutePath());
        if (!TextUtils.isEmpty((CharSequence)type)) {
            FileProviderUtils.setIntentDataAndType((Context)this, intent, type, file, true);
        } else {
            FileProviderUtils.setIntentDataAndType((Context)this, intent, "*/*", file, true);
        }
        try {
            this.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)this, (CharSequence)"\u6ca1\u6709\u53d1\u73b0\u6253\u5f00\u8be5\u7c7b\u578b\u6587\u4ef6\u7684\u8f6f\u4ef6", (int)0).show();
        }
    }

    private void downloadFile() {
        try {
            if (this.downInfo != null) {
                this.downInfo.setListener(new HttpDownOnNextListener(){

                    public void onNext(Object o) {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onStart() {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onComplete() {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onError(Throwable e) {
                        if (e instanceof MomentsBaseException) {
                            switch (((MomentsBaseException)e).code) {
                                case 1002: 
                                case 1003: 
                                case 1004: {
                                    FileDetailActivity.this.showToast(FileDetailActivity.this.getResources().getString(R.string.moments_net_error_retry));
                                    break;
                                }
                                default: {
                                    FileDetailActivity.this.showToast(e.getMessage());
                                }
                            }
                        }
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void onPause() {
                        FileDetailActivity.this.refresh();
                    }

                    @Override
                    public void updateProgress(long readLength, long countLength) {
                        Logger.i((String)("readLength:" + readLength + ",countLength:" + countLength), (Object[])new Object[0]);
                        FileDetailActivity.this.refresh();
                    }
                });
                this.downloadManager.startDown(this.downInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refresh() {
        if (this.downInfo != null) {
            switch (this.downInfo.getState()) {
                case START: {
                    break;
                }
                case DOWN: {
                    this.pBarBgImage.setVisibility(0);
                    this.myProgressWheel.setVisibility(0);
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_stop));
                    this.myProgressWheel.setProgress((int)(this.downInfo.getReadLength() * 360L / this.downInfo.getCountLength()));
                    break;
                }
                case PAUSE: {
                    this.pBarBgImage.setVisibility(0);
                    this.myProgressWheel.setVisibility(0);
                    this.myProgressWheel.setProgress((int)(this.downInfo.getReadLength() * 360L / this.downInfo.getCountLength()));
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_resume));
                    break;
                }
                case FINISH: {
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_open_file));
                    this.pBarBgImage.setVisibility(8);
                    this.myProgressWheel.setVisibility(8);
                    break;
                }
                case ERROR: {
                    this.pBarBgImage.setVisibility(0);
                    this.myProgressWheel.setVisibility(0);
                    this.mBtnDownload.setText((CharSequence)this.getString(R.string.moments_retry));
                    break;
                }
            }
        }
    }
}

