/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.gallery.fragment;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.media.ThumbnailUtils;
import android.os.Handler;
import android.os.Message;
import android.support.v4.util.LruCache;
import android.widget.ImageView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NativeImageLoader {
    private LruCache<String, Bitmap> mMemoryCache;
    private static NativeImageLoader mInstance = new NativeImageLoader();
    private ExecutorService mImageThreadPool = Executors.newFixedThreadPool(1);
    public static final int IMAGE_TYPE = 0;
    public static final int VIDEO_TYPE = 1;

    private NativeImageLoader() {
        int maxMemory = (int)Runtime.getRuntime().maxMemory();
        int cacheSize = maxMemory / 8;
        this.mMemoryCache = new LruCache<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap bitmap) {
                return bitmap.getByteCount();
            }
        };
    }

    public static NativeImageLoader getInstance() {
        return mInstance;
    }

    public Bitmap loadNativeImage(ImageView imageView, String path, NativeImageCallBack mCallBack, int type) {
        return this.loadNativeImage(imageView, path, null, mCallBack, type);
    }

    public Bitmap loadNativeImage(final ImageView imageView, final String path, final Point mPoint, final NativeImageCallBack mCallBack, final int type) {
        Bitmap bitmap = this.getBitmapFromMemCache(path);
        final Handler mHander = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                mCallBack.onImageLoader(imageView, (Bitmap)msg.obj, path);
            }
        };
        if (bitmap == null) {
            this.mImageThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    Bitmap mBitmap = null;
                    switch (type) {
                        case 0: {
                            mBitmap = NativeImageLoader.this.decodeThumbBitmapForFile(path, mPoint == null ? 0 : mPoint.x, mPoint == null ? 0 : mPoint.y);
                            break;
                        }
                        case 1: {
                            mBitmap = NativeImageLoader.this.createVideoThumbnail(path);
                            break;
                        }
                    }
                    Message msg = mHander.obtainMessage();
                    msg.obj = mBitmap;
                    mHander.sendMessage(msg);
                    NativeImageLoader.this.addBitmapToMemoryCache(path, mBitmap);
                }
            });
        } else {
            Message msg = mHander.obtainMessage();
            msg.obj = bitmap;
            mHander.sendMessage(msg);
        }
        return bitmap;
    }

    public void addBitmapToMemoryCache(String key, Bitmap bitmap) {
        if (this.getBitmapFromMemCache(key) == null && bitmap != null) {
            this.mMemoryCache.put((Object)key, (Object)bitmap);
        }
    }

    public void removeBitmapFromeMemoryCache(String key) {
        this.mMemoryCache.remove((Object)key);
    }

    public Bitmap getBitmapFromMemCache(String key) {
        return (Bitmap)this.mMemoryCache.get((Object)key);
    }

    private Bitmap decodeThumbBitmapForFile(String path, int viewWidth, int viewHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        options.inSampleSize = this.computeScale(options, viewWidth, viewHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    private Bitmap createVideoThumbnail(String path) {
        return ThumbnailUtils.createVideoThumbnail((String)path, (int)1);
    }

    private int computeScale(BitmapFactory.Options options, int viewWidth, int viewHeight) {
        int inSampleSize = 1;
        if (viewWidth == 0 || viewHeight == 0) {
            return inSampleSize;
        }
        int bitmapWidth = options.outWidth;
        int bitmapHeight = options.outHeight;
        if (bitmapWidth > viewWidth || bitmapHeight > viewWidth) {
            int heightScale;
            int widthScale = Math.round((float)bitmapWidth / (float)viewWidth);
            inSampleSize = widthScale < (heightScale = Math.round((float)bitmapHeight / (float)viewWidth)) ? widthScale : heightScale;
        }
        return inSampleSize;
    }

    public static interface NativeImageCallBack {
        public void onImageLoader(ImageView var1, Bitmap var2, String var3);
    }
}

