/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.detail.video;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.orhanobut.logger.Logger;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.VideoBean;
import com.xdja.moments.sdk.database.domain.DownInfo;
import com.xdja.moments.sdk.flow.detail.video.VideoDetailActivityPermissionsDispatcher;
import com.xdja.moments.sdk.http.download.DownLoadListener.HttpDownOnNextListener;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.http.download.HttpDownManager;
import com.xdja.moments.sdk.repository.DownInfoRepository;
import com.xdja.moments.sdk.utils.FileProviderUtils;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.widget.CircleProgressBar;
import io.reactivex.FlowableTransformer;
import io.reactivex.disposables.Disposable;
import java.io.File;
import permissions.dispatcher.NeedsPermission;
import permissions.dispatcher.OnNeverAskAgain;
import permissions.dispatcher.RuntimePermissions;

@RuntimePermissions
@Route(path="/detail/videoDetail")
public class VideoDetailActivity
extends BaseActivity
implements View.OnClickListener {
    @Autowired(name="extra_video")
    public VideoBean videoBean;
    private DownInfo downInfo;
    private HttpDownManager downloadManager;
    private ImageView videoPrev;
    private ImageView videoPlay;
    private ImageView operate;
    private CircleProgressBar progressBar;

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        ARouter.getInstance().inject((Object)this);
        if (this.videoBean == null) {
            Toast.makeText((Context)this, (CharSequence)"\u83b7\u53d6\u89c6\u9891\u5931\u8d25", (int)0).show();
            this.finish();
        }
        this.downloadManager = HttpDownManager.getInstance();
        if (FileUtil.isFileExist(FileUtil.getSavePath(this.videoBean.getVideoFileId()))) {
            this.videoPlay.setVisibility(0);
            this.progressBar.setVisibility(8);
            this.operate.setEnabled(true);
            this.play(FileUtil.getSavePath(this.videoBean.getVideoFileId()));
        } else {
            Disposable disposable = DownInfoRepository.getInstance().getDownloadInfoByFileId(this.videoBean.getVideoFileId()).compose(FlowableTransfor.io_main()).compose((FlowableTransformer)provider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(downInfo -> {
                this.downInfo = downInfo;
                if (FileUtil.isFileExist(downInfo.getSavePath()) && downInfo.getState() == DownState.FINISH) {
                    this.videoPlay.setVisibility(0);
                } else {
                    downInfo.setUpdateProgress(true);
                    this.downloadFile();
                }
            }, Throwable::printStackTrace);
        }
        Glide.with((FragmentActivity)this).load(this.videoBean.getVideoPrevPath()).diskCacheStrategy(DiskCacheStrategy.ALL).into(this.videoPrev);
    }

    protected void preGetRootView(Bundle savedInstanceState) {
        ARouter.getInstance().inject((Object)this);
        this.getWindow().setFlags(1024, 1024);
    }

    protected void initView() {
        this.videoPrev = (ImageView)this.findViewById(R.id.iv_prev);
        this.videoPlay = (ImageView)this.findViewById(R.id.iv_play);
        this.progressBar = (CircleProgressBar)this.findViewById(R.id.pb_loading);
        this.operate = (ImageView)this.findViewById(R.id.ib_operate);
        this.videoPlay.setOnClickListener((View.OnClickListener)this);
        this.operate.setOnClickListener((View.OnClickListener)this);
    }

    protected int getRootView() {
        return R.layout.moments_activity_video_detail;
    }

    private void downloadFile() {
        try {
            if (this.downInfo != null) {
                this.operate.setEnabled(false);
                this.progressBar.setMaxProgress(100);
                this.downInfo.setListener(new HttpDownOnNextListener(){

                    public void onNext(Object o) {
                    }

                    @Override
                    public void onStart() {
                        VideoDetailActivity.this.progressBar.setVisibility(0);
                    }

                    @Override
                    public void onComplete() {
                        VideoDetailActivity.this.videoPlay.setVisibility(0);
                        VideoDetailActivity.this.progressBar.setVisibility(8);
                        VideoDetailActivity.this.operate.setEnabled(true);
                        VideoDetailActivity.this.play(FileUtil.getSavePath(VideoDetailActivity.this.videoBean.getVideoFileId()));
                    }

                    @Override
                    public void updateProgress(long readLength, long countLength) {
                        VideoDetailActivity.this.progressBar.setProgress((int)(readLength * 100L / countLength));
                        Logger.d((Object)(readLength + "/" + countLength));
                    }
                });
                this.downloadManager.startDown(this.downInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void play(String path) {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0) {
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            intent.setAction("android.intent.action.VIEW");
            File file = new File(path);
            FileProviderUtils.setIntentDataAndType((Context)this, intent, FileUtil.getFileMineType(file), file, true);
            this.startActivity(intent);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_play) {
            this.play(FileUtil.getSavePath(this.videoBean.getVideoFileId()));
        } else if (v.getId() == R.id.ib_operate) {
            this.showDialog();
        }
    }

    public void showDialog() {
        CharSequence[] items = this.getResources().getStringArray(R.array.moments_gallery_operate);
        AlertDialog dlg = new AlertDialog.Builder((Context)this).setItems(items, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case 0: {
                        dialog.dismiss();
                        VideoDetailActivityPermissionsDispatcher.gaintWriteExtPermissionForFileWithPermissionCheck(VideoDetailActivity.this, true);
                        break;
                    }
                    case 1: {
                        dialog.dismiss();
                        VideoDetailActivityPermissionsDispatcher.gaintWriteExtPermissionForFileWithPermissionCheck(VideoDetailActivity.this, false);
                    }
                }
            }
        }).create();
        dlg.show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        VideoDetailActivityPermissionsDispatcher.onRequestPermissionsResult(this, requestCode, grantResults);
    }

    @NeedsPermission(value={"android.permission.WRITE_EXTERNAL_STORAGE"})
    void gaintWriteExtPermissionForFile(boolean isTransf) {
        if (isTransf) {
            this.forwardVideo();
        } else {
            this.saveVideo();
        }
    }

    @OnNeverAskAgain(value={"android.permission.WRITE_EXTERNAL_STORAGE"})
    void onWriteExtNeverAskAgain() {
        this.showPermissionDeniedDialog(R.string.moments_permission_setting);
    }

    private void forwardVideo() {
        if (FileUtil.isLocalHasFile(this.videoBean.getVideoFileId())) {
            Navigation.shareFileTo(FileUtil.getSavePath(this.videoBean.getVideoFileId()));
        } else {
            this.showToast(this.getString(R.string.moments_file_not_exit));
        }
    }

    private void saveVideo() {
        FileUtils.makeDirs((String)MomentsConstants.PICTURE_FOLDER);
        String destFilePath = FileUtil.getSavePath(this.videoBean.getVideoFileId());
        if (FileUtils.isFileExist((String)destFilePath)) {
            this.showToast("\u5df2\u4fdd\u5b58\u5728" + MomentsConstants.PICTURE_FOLDER + "\u6587\u4ef6\u5939\u4e0b\uff01");
            File destFile = new File(destFilePath);
            Uri uri = Uri.fromFile((File)destFile);
            Intent intent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri);
            this.sendBroadcast(intent);
        } else {
            this.downloadFile();
        }
    }
}

