/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.main;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.widget.Toast;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.OnToolBarTap;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.eventbus.MomentDetailEvent;
import com.xdja.moments.sdk.eventbus.OnPageSelectEvent;
import com.xdja.moments.sdk.flow.MomentsFragment;
import com.xdja.moments.sdk.flow.base.fragment.BaseMomentListFragment;
import com.xdja.moments.sdk.flow.base.moments.BaseMomentListPresenter;
import com.xdja.moments.sdk.flow.main.mvp.MainMomentsListPresenter;
import com.xdja.moments.sdk.http.bean.request.MomentsListByTypeParams;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.repository.NewMomentsRepository;
import com.xdja.moments.sdk.utils.UrlUtils;
import com.xdja.moments.sdk.viewmodel.NewMomentsViewModel;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class ColumnFragment
extends BaseMomentListFragment
implements Observer<List<String>> {
    public static final String CLASSIFY_ID = "CLASSIFY_ID";
    private MainMomentsListPresenter presenter;
    private List<BottomMenuBean> mineBottomMenu = new ArrayList<BottomMenuBean>();
    private List<BottomMenuBean> otherBottomMenu = new ArrayList<BottomMenuBean>();
    private NewMomentsViewModel newMomentsViewModel;
    private NewMomentsRepository newMomentsRepository;
    private List<String> mClassifyIds = new ArrayList<String>();

    public void setArguments(@Nullable Bundle args) {
        super.setArguments(args);
    }

    public static Fragment newInstance(String classify) {
        ColumnFragment fragment = new ColumnFragment();
        Bundle bundle = new Bundle();
        bundle.putString(CLASSIFY_ID, classify);
        fragment.setArguments(bundle);
        return fragment;
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.getArguments() == null) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"\u83b7\u53d6\u5de5\u4f5c\u5708\u5217\u8868\u5931\u8d25", (int)0).show();
            return;
        }
        String classifyId = this.getArguments().getString(CLASSIFY_ID);
        if (this.presenter == null) {
            this.presenter = new MainMomentsListPresenter(provider, this);
        }
        MomentsListByTypeParams params = new MomentsListByTypeParams();
        params.setExtType(classifyId);
        params.setClassifyId(classifyId);
        params.setTimeStamp(this.pageTimeStamp);
        this.presenter.getMomentsData(params);
    }

    @Override
    protected String getPageListRequestId() {
        return UrlUtils.buildRequestPath("momentInfo/queryMomentInfoList", this.getArguments().getString(CLASSIFY_ID));
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.newMomentsViewModel = (NewMomentsViewModel)ViewModelProviders.of((Fragment)this).get(NewMomentsViewModel.class);
        this.newMomentsViewModel.getNewMomentClassifyId().observe((LifecycleOwner)this, (Observer)this);
        this.newMomentsRepository = new NewMomentsRepository();
    }

    @Override
    protected BaseMomentListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void onMoreArrowClick(MomentsBean data) {
        super.onMoreArrowClick(data);
        this.mineBottomMenu.clear();
        this.otherBottomMenu.clear();
        if (this.enableTransmit) {
            this.mineBottomMenu.add(new BottomMenuBean(R.drawable.moments_icon_tran, this.getString(R.string.moments_bottom_menu_transmit)));
            this.otherBottomMenu.add(new BottomMenuBean(R.drawable.moments_icon_tran, this.getString(R.string.moments_bottom_menu_transmit)));
        }
        if (this.enableHide) {
            this.otherBottomMenu.add(new BottomMenuBean(R.drawable.moments_icon_hide, this.getString(R.string.moments_bottom_menu_hide)));
        }
        this.mineBottomMenu.add(new BottomMenuBean(R.drawable.moments_icon_delete, this.getString(R.string.moments_bottom_menu_delete)));
        if (data.getUserInfo().getUserId().equals(MomentsManager.getInstance().getLoginer().getUserId())) {
            this.showBottomMenu(this.mineBottomMenu);
        } else {
            if (this.otherBottomMenu.size() == 0) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"\u65e0\u6cd5\u64cd\u4f5c", (int)0).show();
                return;
            }
            this.showBottomMenu(this.otherBottomMenu);
        }
    }

    protected void onBottomMenuItemClick(BottomMenuBean menuBean) {
        this.hideBottomMenu();
        if (menuBean.getItemName().equals(this.getString(R.string.moments_bottom_menu_transmit))) {
            Navigation.shareMomentTo(this.currentOperatorMoment);
        } else if (menuBean.getItemName().equals(this.getString(R.string.moments_bottom_menu_delete))) {
            this.showAlertDialog("\u53d6\u6d88", "\u786e\u5b9a", this.getString(R.string.moments_delete_single_tip), v -> this.dismissAlertDialog(), v -> {
                this.dismissAlertDialog();
                this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
                this.presenter.deleteMoments(this.currentOperatorMoment.getMomentId());
            });
        } else if (menuBean.getItemName().equals(this.getString(R.string.moments_bottom_menu_hide))) {
            this.showAlertDialog("\u53d6\u6d88", "\u786e\u5b9a", this.getString(R.string.moments_hide_tip), v -> this.dismissAlertDialog(), v -> {
                this.dismissAlertDialog();
                this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
                this.presenter.hideMoments(this.currentOperatorMoment.getMomentId());
            });
        }
    }

    public void onChanged(@Nullable List<String> classifyIds) {
        if (classifyIds == null || classifyIds.size() == 0) {
            return;
        }
        this.mClassifyIds.clear();
        this.mClassifyIds.addAll(classifyIds);
        MomentsFragment parentFragment = (MomentsFragment)this.getParentFragment();
        if (parentFragment == null) {
            return;
        }
        String classifyId = this.getArguments().getString(CLASSIFY_ID);
        for (String id2 : classifyIds) {
            if (!id2.equals(classifyId)) continue;
            parentFragment.showPageDot(classifyId);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onToolbarTap(OnToolBarTap event) {
        MomentsFragment parentFragment = (MomentsFragment)this.getParentFragment();
        if (parentFragment == null) {
            return;
        }
        boolean isSelect = parentFragment.getIsSelect(this.getArguments().getString(CLASSIFY_ID));
        if (this.mRecyclerView != null && isSelect) {
            this.mRecyclerView.scrollToPosition(0);
            this.pageTimeStamp = 0L;
            this.mRefreshLayout.autoRefresh();
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshList(MomentDetailEvent event) {
        if (event.getClassifyId().equals(this.getArguments().getString(CLASSIFY_ID))) {
            this.pageTimeStamp = 0L;
            this.initData((LifecycleProvider<Lifecycle.Event>)this.provider);
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshList(OnPageSelectEvent event) {
        String classifyId = this.getArguments().getString(CLASSIFY_ID);
        if (event.getClassifyId().equals(classifyId)) {
            for (String mClassifyId : this.mClassifyIds) {
                if (!mClassifyId.equals(classifyId)) continue;
                this.pageTimeStamp = 0L;
                this.mRefreshLayout.autoRefresh();
            }
        }
    }

    public void onResume() {
        super.onResume();
    }

    @Override
    protected void showEmptyLayout(String emptyText, int emptyImage) {
        super.showEmptyLayout(this.getString(R.string.moments_info_no_moment_main), R.drawable.moments_img_no_mement_main);
    }

    @Override
    protected void showErrorLayout(String errorInfo, int errorImage) {
        super.showErrorLayout(errorInfo, R.drawable.moments_img_error_mement_main);
    }

    @Override
    public void onGetMomentsFinish(List<MomentsBean> momentsList) {
        super.onGetMomentsFinish(momentsList);
        if (this.pageIsFirst) {
            this.newMomentsViewModel.clearUnReadNumber(this.getArguments().getString(CLASSIFY_ID));
            this.mClassifyIds.clear();
            MomentsFragment parentFragment = (MomentsFragment)this.getParentFragment();
            if (parentFragment == null) {
                return;
            }
            parentFragment.hidePageDot(this.getArguments().getString(CLASSIFY_ID));
        }
    }
}

