/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine;

import android.arch.lifecycle.Lifecycle;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.orhanobut.logger.Logger;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.flow.mine.ui.MyMomentsFragment;
import com.xdja.moments.sdk.flow.mine.ui.OthersMomentsFragment;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

@Route(path="/mine/othersMoments")
public class OthersMomentsActivity
extends BaseActivity {
    @Autowired(name="userId")
    public String userId;
    @Autowired(name="title")
    public String title;
    @Autowired(name="is_mine")
    public boolean isMine;

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.isMine) {
            this.getSupportFragmentManager().beginTransaction().add(R.id.fragment, (Fragment)new MyMomentsFragment()).commit();
        } else {
            this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment, OthersMomentsFragment.newInstance(this.userId)).commit();
        }
    }

    protected void initView() {
        ARouter.getInstance().inject((Object)this);
        if (this.isMine && !TextUtils.isEmpty((CharSequence)this.title)) {
            this.setMomentsTitle(this.title);
        } else {
            MomentsDataManager.getInstance().queryObservableUserInfo(this.userId).subscribe((Observer)new Observer<UserInfoBean>(){

                public void onSubscribe(Disposable d) {
                }

                public void onNext(UserInfoBean userInfoBean) {
                    OthersMomentsActivity.this.setMomentsTitle(String.format(OthersMomentsActivity.this.getString(R.string.moments_others_moments), userInfoBean.getUserName()));
                }

                public void onError(Throwable e) {
                    e.printStackTrace();
                }

                public void onComplete() {
                }
            });
        }
    }

    protected int getRootView() {
        return R.layout.moments_activity_others_moments;
    }

    protected void onDestroy() {
        Logger.d((Object)this.userId);
        super.onDestroy();
    }
}

