/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import com.orhanobut.logger.Logger;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.XViewHolder;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.AtPraiseMomentBean;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import java.util.List;

public class AtPraiseMomentListAdapter
extends XRecyclerViewAdapter<AtPraiseMomentBean> {
    private List<MomentsClassify> momentsClassifyList;
    private MomentsConfig momentsConfig;
    private Activity mContext;
    private Drawable drawablePraise;
    private int imageSize;
    private Boolean mIsAtMine;

    public AtPraiseMomentListAdapter(@NonNull RecyclerView mRecyclerView, List<AtPraiseMomentBean> dataLists, Activity context, boolean isAtMine) {
        super(mRecyclerView, dataLists, R.layout.moments_comment_item);
        this.mContext = context;
        this.mIsAtMine = isAtMine;
        if (!this.mIsAtMine.booleanValue()) {
            this.drawablePraise = context.getResources().getDrawable(R.drawable.moments_receive_praise);
            this.drawablePraise.setBounds(0, 0, this.drawablePraise.getMinimumWidth(), this.drawablePraise.getMinimumHeight());
        }
        this.imageSize = (int)context.getResources().getDimension(R.dimen.moments_60dp);
    }

    protected void bindData(XViewHolder holder, AtPraiseMomentBean data, int position) {
        UserInfoBean userInfo = data.getUserInfo();
        holder.setImageUrl((Context)this.mContext, R.id.iv_head_image, userInfo.getUserAvatar(), R.drawable.moments_person_default, true, true);
        holder.setVisible(R.id.iv_auxpolice_mark, userInfo.isAuxPolice());
        holder.setText(R.id.tv_topic_user_name, (CharSequence)(TextUtils.isEmpty((CharSequence)userInfo.getUserName()) ? "\u5df2\u5220\u9664\u7528\u6237" : userInfo.getUserName()));
        holder.setText(R.id.tv_comment_time, (CharSequence)data.getTimeString());
        holder.setText(R.id.tv_comment_content, (CharSequence)(this.mIsAtMine != false ? "\u63d0\u5230\u4e86\u6211" : ""));
        holder.setOnClickListener(R.id.tv_comment_content, v -> this.enterToDetail(data));
        if (!this.mIsAtMine.booleanValue()) {
            holder.setCompoundDrawables(R.id.tv_comment_content, null, null, null, this.drawablePraise);
        } else {
            holder.setCompoundDrawables(R.id.tv_comment_content, null, null, null, null);
        }
        List<ImageBean> momentPicturePath = data.getMomentPicturePath();
        String imageUrl = "";
        if (momentPicturePath.size() > 0) {
            imageUrl = MomentImageUtil.getThumbnail(momentPicturePath.get(0).getPath(), this.imageSize, this.imageSize);
        }
        switch (data.getMomentType()) {
            case 1: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, true);
                holder.setVisible(R.id.iv_moment_image, false);
                holder.setText(R.id.tv_moments_content, (CharSequence)(TextUtils.isEmpty((CharSequence)data.getMomentContent()) ? "\u5de5\u4f5c\u5708\u5185\u5bb9" : data.getMomentContent()));
                break;
            }
            case 2: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, false);
                holder.setVisible(R.id.iv_moment_image, true);
                holder.setImageUrl((Context)this.mContext, R.id.iv_moment_image, imageUrl, R.drawable.moments_img_pic_default, false);
                break;
            }
            case 3: {
                holder.setVisible(R.id.tv_moments_content, false);
                holder.setVisible(R.id.iv_video_play, true);
                holder.setVisible(R.id.iv_moment_image, true);
                holder.setImageUrl((Context)this.mContext, R.id.iv_moment_image, imageUrl, R.drawable.moments_img_pic_default, false);
                break;
            }
            case 4: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, false);
                holder.setVisible(R.id.iv_moment_image, true);
                holder.setImageResource(R.id.iv_moment_image, FileUtil.getFileDrawable(data.getMomentFileType()));
                break;
            }
            case 5: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, true);
                holder.setVisible(R.id.iv_moment_image, false);
                holder.setText(R.id.tv_moments_content, (CharSequence)(TextUtils.isEmpty((CharSequence)data.getMomentShareContent()) ? "\u5de5\u4f5c\u5708\u5185\u5bb9" : data.getMomentShareContent()));
                break;
            }
            default: {
                holder.setVisible(R.id.iv_video_play, false);
                holder.setVisible(R.id.tv_moments_content, true);
                holder.setVisible(R.id.iv_moment_image, false);
                holder.setText(R.id.tv_moments_content, (CharSequence)(TextUtils.isEmpty((CharSequence)data.getMomentContent()) ? "\u5de5\u4f5c\u5708\u5185\u5bb9" : data.getMomentContent()));
            }
        }
        holder.itemView.setOnClickListener(v -> this.enterToDetail(data));
    }

    private void enterToDetail(AtPraiseMomentBean data) {
        if (this.hasReadPower(data.getClassifyId()) && "2".equals(this.momentsConfig.getSwitchShowCommentWay())) {
            Navigation.navigationMomentDetail(data.getMomentId());
        } else {
            Logger.d((Object)"\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u5de5\u4f5c\u5708");
        }
    }

    private boolean hasReadPower(String classifyId) {
        MomentsClassify myMomentsClassify = this.getClassIfyById(classifyId);
        if (myMomentsClassify == null) {
            return false;
        }
        return "1".equals(myMomentsClassify.getLookMomentPower());
    }

    private MomentsClassify getClassIfyById(String classifyId) {
        if (this.momentsClassifyList == null) {
            return null;
        }
        for (MomentsClassify classify : this.momentsClassifyList) {
            if (!classify.getClassifyId().equals(classifyId)) continue;
            return classify;
        }
        return null;
    }

    public void onClassifyPowerChanged(List<MomentsClassify> momentsClassifyList) {
        this.momentsClassifyList = momentsClassifyList;
        this.notifyDataSetChanged();
    }

    public void onMomentConfigChanged(MomentsConfig momentsConfig) {
        this.momentsConfig = momentsConfig;
        this.notifyDataSetChanged();
    }
}

