/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine.business.impl;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BasePageResponse;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.bean.AtPraiseMomentBean;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.flow.mine.business.AtPraiseMomentsBusiness;
import com.xdja.moments.sdk.flow.mine.mvp.AtMineMomentsModel;
import com.xdja.moments.sdk.flow.mine.mvp.ReceivePraiseMomentsModel;
import com.xdja.moments.sdk.http.bean.request.BaseListParams;
import com.xdja.moments.sdk.http.bean.response.AtPraiseMomentsResponseBean;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AtPraiseMomentsBusinessImpl
implements AtPraiseMomentsBusiness {
    private LifecycleProvider<Lifecycle.Event> provider;
    private AtMineMomentsModel atMineMomentsModel = new AtMineMomentsModel();
    private ReceivePraiseMomentsModel receivePraiseMomentsModel = new ReceivePraiseMomentsModel();

    public AtPraiseMomentsBusinessImpl(LifecycleProvider<Lifecycle.Event> provider) {
        this.provider = provider;
    }

    @NonNull
    private AtPraiseMomentBean getAtPraiseMoment(AtPraiseMomentsResponseBean praiseMomentsResponse) {
        AtPraiseMomentBean atPraiseMomentBean = new AtPraiseMomentBean();
        atPraiseMomentBean.setClassifyId(praiseMomentsResponse.getClassifyId());
        atPraiseMomentBean.setCreateTime(praiseMomentsResponse.getCreateTime());
        atPraiseMomentBean.setMomentContent(praiseMomentsResponse.getMomentContent());
        atPraiseMomentBean.setMomentFileName(praiseMomentsResponse.getMomentFileName());
        atPraiseMomentBean.setMomentFilePath(praiseMomentsResponse.getMomentFilePath());
        List<ImageBean> imageBeans = this.buildImageList(praiseMomentsResponse.getMomentPicturePath());
        atPraiseMomentBean.setMomentPicturePath(imageBeans);
        atPraiseMomentBean.setMomentFileType(praiseMomentsResponse.getMomentFileType());
        atPraiseMomentBean.setMomentId(praiseMomentsResponse.getMomentId());
        atPraiseMomentBean.setMomentShareContent(praiseMomentsResponse.getMomentShareContent());
        atPraiseMomentBean.setMomentSharePicture(praiseMomentsResponse.getMomentSharePicture());
        atPraiseMomentBean.setMomentShareUrl(praiseMomentsResponse.getMomentShareUrl());
        atPraiseMomentBean.setMomentType(praiseMomentsResponse.getMomentType());
        atPraiseMomentBean.setMomentVideoTime(praiseMomentsResponse.getMomentVideoTime());
        UserInfoBean userInfoBean = MomentsDataManager.getInstance().queryUserInfo(praiseMomentsResponse.getUserId());
        atPraiseMomentBean.setUserInfo(userInfoBean);
        return atPraiseMomentBean;
    }

    @NonNull
    private List<ImageBean> buildImageList(String imageFileIds) {
        ArrayList<ImageBean> imageList = new ArrayList<ImageBean>();
        if (!TextUtils.isEmpty((CharSequence)imageFileIds)) {
            List<String> imageFileIdList = Arrays.asList(imageFileIds.split("\\,"));
            for (String imageFileId : imageFileIdList) {
                ImageBean imageBean = new ImageBean();
                imageBean.setHeight(MomentImageUtil.getImageHeight(imageFileId));
                imageBean.setWidth(MomentImageUtil.getImageWidth(imageFileId));
                imageBean.setPath(MomentImageUtil.getImageUrl(imageFileId));
                imageList.add(imageBean);
            }
        }
        return imageList;
    }

    @Override
    public Observable<List<AtPraiseMomentBean>> getAtMomentsData(BaseListParams info) {
        return this.atMineMomentsModel.getAtMineMoments(info).compose(MomentsRxTransformer.momentsCompose(this.provider, info)).map(BasePageResponse::getData).flatMap(Observable::fromIterable).map(this::getAtPraiseMoment).toList().toObservable().compose(ObservableTransfor.io_main());
    }

    @Override
    public Observable<List<AtPraiseMomentBean>> getReceivePraiseMomentsData(BaseListParams info) {
        return this.receivePraiseMomentsModel.getReceivePraiseMoments(info).compose(MomentsRxTransformer.momentsCompose(this.provider, info)).map(BasePageResponse::getData).flatMap(Observable::fromIterable).map(this::getAtPraiseMoment).toList().toObservable().compose(ObservableTransfor.io_main());
    }
}

