/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine.comment;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.RecyclerView;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.decoration.LeftOffsetItemDecoration;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.MyCommentsBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.eventbus.MomentDetailEvent;
import com.xdja.moments.sdk.flow.base.fragment.BaseListFragment;
import com.xdja.moments.sdk.flow.mine.comment.adapter.MyCommentsAdapter;
import com.xdja.moments.sdk.flow.mine.comment.mvp.MyCommentListPresenter;
import com.xdja.moments.sdk.flow.mine.comment.mvp.MyCommentsListConstruct;
import com.xdja.moments.sdk.http.bean.request.MyCommentsParams;
import com.xdja.moments.sdk.viewmodel.MomentsClassifyViewModel;
import com.xdja.moments.sdk.viewmodel.MomentsConfigViewModel;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public abstract class BaseCommentsFragment
extends BaseListFragment
implements MyCommentsListConstruct.View {
    private List<MyCommentsBean> myCommentsBeanList = new ArrayList<MyCommentsBean>();
    private MyCommentsAdapter myCommentsAdapter;
    private MyCommentListPresenter myCommentListPresenter;
    private MomentsClassifyViewModel classifyViewModel;
    private MomentsConfigViewModel momentConfigModel;
    protected static final String TYPE_ALL = "1";
    protected static final String TYPE_OTHER = "2";
    protected static final String TYPE_MINE = "3";

    protected XRecyclerViewAdapter setUpAdapter() {
        this.myCommentsAdapter = new MyCommentsAdapter(this.mRecyclerView, this.myCommentsBeanList, (Activity)this.getActivity());
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.myCommentsAdapter);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new LeftOffsetItemDecoration(this.getResources().getColor(R.color.moments_driver_line), 2, this.getResources().getDimensionPixelOffset(R.dimen.moments_item_content_margin_left)));
        this.classifyViewModel = (MomentsClassifyViewModel)ViewModelProviders.of((Fragment)this).get(MomentsClassifyViewModel.class);
        this.momentConfigModel = (MomentsConfigViewModel)ViewModelProviders.of((Fragment)this).get(MomentsConfigViewModel.class);
        this.momentConfigModel.getMomentsConfig().observe((LifecycleOwner)this, (Observer)new Observer<MomentsConfig>(){

            public void onChanged(@Nullable MomentsConfig momentsConfig) {
                if (momentsConfig == null) {
                    return;
                }
                BaseCommentsFragment.this.myCommentsAdapter.onMomentConfigChanged(momentsConfig);
            }
        });
        this.classifyViewModel.getAllMomentsClassIfy().observe((LifecycleOwner)this, classifyList -> this.myCommentsAdapter.onClassifyPowerChanged((List<MomentsClassify>)classifyList));
        return this.myCommentsAdapter;
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.myCommentListPresenter == null) {
            this.myCommentListPresenter = new MyCommentListPresenter(provider, this);
        }
        MyCommentsParams params = new MyCommentsParams();
        params.setCommentType(this.getShowType());
        params.setExtType(this.getShowType());
        params.setTimeStamp(this.pageTimeStamp);
        this.myCommentListPresenter.getMyCommentsListData(params);
    }

    protected abstract String getShowType();

    @Override
    protected void showErrorLayout(String errorInfo, @DrawableRes int errorImage) {
        super.showErrorLayout(errorInfo, R.drawable.moments_img_error_comment);
    }

    @Override
    public void onGetMyCommentsFinish(List<MyCommentsBean> commentsList) {
        if (this.getContext() == null) {
            return;
        }
        if (commentsList == null || commentsList.size() == 0) {
            if (this.pageIsFirst) {
                this.showEmptyLayout(this.getContext().getString(R.string.moments_info_no_comment), R.drawable.moments_img_no_comment);
            } else {
                this.mRefreshLayout.setEnableLoadMore(false);
                this.myCommentsAdapter.showLoadComplete();
            }
            return;
        }
        if (this.pageIsFirst) {
            this.myCommentsBeanList.clear();
        }
        this.myCommentsBeanList.addAll(commentsList);
        this.myCommentsAdapter.notifyDataSetChanged();
    }

    @Override
    protected void showNoNetLayout(String netErrorText, String subText) {
        if (this.myCommentsBeanList.size() == 0) {
            super.showNoNetLayout(netErrorText, subText);
        } else {
            this.showToast(this.getResources().getString(R.string.moments_net_error_retry));
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshList(MomentDetailEvent event) {
        if (event.getOperatorType() == MomentDetailEvent.TYPE_COMMENT) {
            this.pageTimeStamp = 0L;
            this.initData((LifecycleProvider<Lifecycle.Event>)this.provider);
        }
    }
}

