/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine.ui;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.widget.Toast;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.eventbus.MomentDetailEvent;
import com.xdja.moments.sdk.flow.base.fragment.BaseMomentListFragment;
import com.xdja.moments.sdk.flow.base.moments.BaseMomentListPresenter;
import com.xdja.moments.sdk.flow.mine.mvp.OtherMomentsListPresenter;
import com.xdja.moments.sdk.http.bean.request.OthersMomentsParams;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class OthersMomentsFragment
extends BaseMomentListFragment {
    public static final String PERSON_USER_ID = "PERSON_USER_ID";
    private OtherMomentsListPresenter presenter;
    private List<BottomMenuBean> bottomMenuBeanList = new ArrayList<BottomMenuBean>();

    public void setArguments(@Nullable Bundle args) {
        super.setArguments(args);
    }

    public static Fragment newInstance(String userId) {
        OthersMomentsFragment fragment = new OthersMomentsFragment();
        Bundle bundle = new Bundle();
        bundle.putString(PERSON_USER_ID, userId);
        fragment.setArguments(bundle);
        return fragment;
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.presenter == null) {
            this.presenter = new OtherMomentsListPresenter(provider, this);
        }
        String userId = this.getArguments().getString(PERSON_USER_ID);
        OthersMomentsParams params = new OthersMomentsParams();
        params.setUserId(userId);
        params.setTimeStamp(this.pageTimeStamp);
        this.presenter.getMomentsData(params);
    }

    @Override
    protected BaseMomentListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void onMoreArrowClick(MomentsBean data) {
        super.onMoreArrowClick(data);
        this.bottomMenuBeanList.clear();
        if (this.enableTransmit) {
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_tran, this.getString(R.string.moments_bottom_menu_transmit)));
        }
        if (this.enableHide) {
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_hide, this.getString(R.string.moments_bottom_menu_hide)));
        }
        if (this.bottomMenuBeanList.size() == 0) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)"\u65e0\u6cd5\u64cd\u4f5c", (int)0).show();
            return;
        }
        this.showBottomMenu(this.bottomMenuBeanList);
    }

    protected void onBottomMenuItemClick(BottomMenuBean menuBean) {
        this.hideBottomMenu();
        if (menuBean.getItemName().equals(this.getString(R.string.moments_bottom_menu_transmit))) {
            Navigation.shareMomentTo(this.currentOperatorMoment);
        } else if (menuBean.getItemName().equals(this.getString(R.string.moments_bottom_menu_hide))) {
            this.showAlertDialog("\u53d6\u6d88", "\u786e\u5b9a", this.getString(R.string.moments_hide_tip), v -> this.dismissAlertDialog(), v -> {
                this.dismissAlertDialog();
                this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
                this.presenter.hideMoments(this.currentOperatorMoment.getMomentId());
            });
        }
    }

    @Override
    protected String getPageListRequestId() {
        return "momentInfo/queryUserMomentInfoList";
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void refreshList(MomentDetailEvent event) {
        this.pageTimeStamp = 0L;
        this.initData((LifecycleProvider<Lifecycle.Event>)this.provider);
    }
}

