/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.mine.ui;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.RecyclerView;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.decoration.LeftOffsetItemDecoration;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.AtPraiseMomentBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.flow.base.fragment.BaseListFragment;
import com.xdja.moments.sdk.flow.mine.adapter.AtPraiseMomentListAdapter;
import com.xdja.moments.sdk.flow.mine.mvp.AtPraiseMomentsConstruct;
import com.xdja.moments.sdk.flow.mine.mvp.AtPraiseMomentsPresenter;
import com.xdja.moments.sdk.http.bean.request.BaseListParams;
import com.xdja.moments.sdk.viewmodel.MomentsClassifyViewModel;
import com.xdja.moments.sdk.viewmodel.MomentsConfigViewModel;
import java.util.ArrayList;
import java.util.List;

public class ReceivePraiseFragment
extends BaseListFragment
implements AtPraiseMomentsConstruct.View {
    private AtPraiseMomentListAdapter atPraiseMomentListAdapter;
    private AtPraiseMomentsPresenter atPraiseMomentsPresenter;
    private List<AtPraiseMomentBean> receivePraiseMomentBeanList = new ArrayList<AtPraiseMomentBean>();

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.atPraiseMomentsPresenter == null) {
            this.atPraiseMomentsPresenter = new AtPraiseMomentsPresenter(provider, this);
        }
        BaseListParams baseListParams = new BaseListParams();
        baseListParams.setTimeStamp(this.pageTimeStamp);
        this.atPraiseMomentsPresenter.getReceivePraiseMomentsData(baseListParams);
    }

    protected XRecyclerViewAdapter setUpAdapter() {
        this.atPraiseMomentListAdapter = new AtPraiseMomentListAdapter(this.mRecyclerView, this.receivePraiseMomentBeanList, (Activity)this.getActivity(), false);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.atPraiseMomentListAdapter);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new LeftOffsetItemDecoration(this.getResources().getColor(R.color.moments_driver_line), 2, this.getResources().getDimensionPixelOffset(R.dimen.moments_item_content_margin_left)));
        this.loadConfigAndClassify();
        return this.atPraiseMomentListAdapter;
    }

    private void loadConfigAndClassify() {
        MomentsClassifyViewModel classifyViewModel = (MomentsClassifyViewModel)ViewModelProviders.of((Fragment)this).get(MomentsClassifyViewModel.class);
        MomentsConfigViewModel momentsConfigViewModel = (MomentsConfigViewModel)ViewModelProviders.of((Fragment)this).get(MomentsConfigViewModel.class);
        momentsConfigViewModel.getMomentsConfig().observe((LifecycleOwner)this, (Observer)new Observer<MomentsConfig>(){

            public void onChanged(@Nullable MomentsConfig momentsConfig) {
                if (momentsConfig == null) {
                    return;
                }
                ReceivePraiseFragment.this.atPraiseMomentListAdapter.onMomentConfigChanged(momentsConfig);
            }
        });
        classifyViewModel.getAllMomentsClassIfy().observe((LifecycleOwner)this, classifyList -> this.atPraiseMomentListAdapter.onClassifyPowerChanged((List<MomentsClassify>)classifyList));
    }

    @Override
    protected String getPageListRequestId() {
        return "momentPraise/queryMomentPraisePageList";
    }

    @Override
    protected void showErrorLayout(String errorInfo, @DrawableRes int errorImage) {
        super.showErrorLayout(errorInfo, R.drawable.moments_img_error_praise);
    }

    @Override
    protected void showNoNetLayout(String netErrorText, String subText) {
        if (this.receivePraiseMomentBeanList.size() == 0) {
            super.showNoNetLayout(netErrorText, subText);
        } else {
            this.showToast(this.getResources().getString(R.string.moments_net_error_retry));
        }
    }

    @Override
    public void onAtPraiseMomentsFinish(List<AtPraiseMomentBean> praiseMomentBeanList) {
        if (this.getContext() == null) {
            return;
        }
        if (praiseMomentBeanList == null || praiseMomentBeanList.size() == 0) {
            if (this.pageIsFirst) {
                this.showEmptyLayout(this.getString(R.string.moments_info_no_praise), R.drawable.moments_img_no_praise);
            } else {
                this.mRefreshLayout.setEnableLoadMore(false);
            }
            return;
        }
        if (this.pageIsFirst) {
            this.receivePraiseMomentBeanList.clear();
        }
        this.receivePraiseMomentBeanList.addAll(praiseMomentBeanList);
        this.atPraiseMomentListAdapter.notifyDataSetChanged();
    }
}

