/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.newcomment;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.adapter.XRecyclerViewAdapter;
import com.xdja.baselibrary.base.adapter.decoration.LeftOffsetItemDecoration;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.MyCommentsBean;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.database.domain.MomentsConfig;
import com.xdja.moments.sdk.eventbus.MomentsPageInfo;
import com.xdja.moments.sdk.flow.mine.comment.adapter.MyCommentsAdapter;
import com.xdja.moments.sdk.flow.newcomment.mvp.NewCommentListPresenter;
import com.xdja.moments.sdk.flow.newcomment.mvp.NewCommentsListConstruct;
import com.xdja.moments.sdk.http.bean.request.BaseListParams;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.viewmodel.MomentsClassifyViewModel;
import com.xdja.moments.sdk.viewmodel.MomentsConfigViewModel;
import java.util.ArrayList;
import java.util.List;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

@Route(path="/main/newComments")
public class NewCommentsActivity
extends BaseActivity
implements OnLoadMoreListener,
NewCommentsListConstruct.View,
XRecyclerViewAdapter.OnItemClickListener {
    public long pageTimeStamp = 0L;
    public int loadCount = 20;
    private boolean firstLoading = true;
    private SmartRefreshLayout mRefreshLayout;
    private RecyclerView mRecyclerView;
    private List<MyCommentsBean> newCommentList = new ArrayList<MyCommentsBean>();
    private NewCommentListPresenter newCommentListPresenter;
    private MyCommentsAdapter newCommentsAdapter;
    MomentsClassifyViewModel classifyViewModel;
    MomentsConfigViewModel momentConfigModel;

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.newCommentListPresenter == null) {
            this.newCommentListPresenter = new NewCommentListPresenter(provider, this);
        }
        BaseListParams params = new BaseListParams();
        params.setTimeStamp(this.pageTimeStamp);
        params.setPageSize(this.loadCount);
        this.newCommentListPresenter.getNewCommentsListData(params);
    }

    protected LoadingType getLoadingType() {
        return this.firstLoading ? LoadingType.LOAD_TYPE_COVER : LoadingType.LOAD_TYPE_NONE;
    }

    public void hideLoading(String key) {
        super.hideLoading(key);
        this.firstLoading = false;
        this.mRefreshLayout.finishLoadMore();
        this.mRefreshLayout.finishRefresh();
    }

    protected ViewGroup getErrorParentView() {
        return this.mRefreshLayout;
    }

    protected void initView() {
        this.setMomentsTitle("\u65b0\u8bc4\u8bba");
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.refreshLayout);
        if (!MomentsManager.getInstance().isCustomHeader()) {
            this.mRefreshLayout.setRefreshHeader((RefreshHeader)new ClassicsHeader(this.getApplicationContext()).setProgressResource(R.drawable.moments_progressbar_loading));
        }
        if (!MomentsManager.getInstance().isCustomFooter()) {
            this.mRefreshLayout.setRefreshFooter((RefreshFooter)new ClassicsFooter(this.getApplicationContext()).setProgressResource(R.drawable.moments_progressbar_loading));
        }
        this.mRefreshLayout.setEnableRefresh(false);
        this.mRefreshLayout.setOnLoadMoreListener((OnLoadMoreListener)this);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.newCommentsAdapter = new MyCommentsAdapter(this.mRecyclerView, this.newCommentList, (Activity)this);
        this.newCommentsAdapter.setOnItemClickListener(this);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.newCommentsAdapter);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new LeftOffsetItemDecoration(this.getResources().getColor(R.color.moments_driver_line), 2, this.getResources().getDimensionPixelOffset(R.dimen.moments_item_content_margin_left)));
        this.classifyViewModel = (MomentsClassifyViewModel)ViewModelProviders.of((FragmentActivity)this).get(MomentsClassifyViewModel.class);
        this.classifyViewModel.getAllMomentsClassIfy().observe((LifecycleOwner)this, classifyList -> this.newCommentsAdapter.onClassifyPowerChanged((List<MomentsClassify>)classifyList));
        this.momentConfigModel = (MomentsConfigViewModel)ViewModelProviders.of((FragmentActivity)this).get(MomentsConfigViewModel.class);
        this.momentConfigModel.getMomentsConfig().observe((LifecycleOwner)this, (Observer)new Observer<MomentsConfig>(){

            public void onChanged(@Nullable MomentsConfig momentsConfig) {
                NewCommentsActivity.this.newCommentsAdapter.onMomentConfigChanged(momentsConfig);
            }
        });
    }

    protected void showNoNetLayout(String netErrorText) {
        if (this.newCommentList.size() == 0) {
            super.showNoNetLayout(netErrorText);
        } else {
            this.showToast(this.getResources().getString(R.string.moments_net_error_retry));
        }
    }

    protected int getRootView() {
        return R.layout.moments_activity_new_comments;
    }

    public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
        this.initData((LifecycleProvider<Lifecycle.Event>)this.provider);
    }

    protected void showErrorLayout(String errorInfo, int errorImage) {
        super.showErrorLayout(errorInfo, R.drawable.moments_img_error_comment);
    }

    @Override
    public void onGetNewCommentsFinish(List<MyCommentsBean> commentsList) {
        if (commentsList != null && commentsList.size() > 0) {
            this.newCommentList.addAll(commentsList);
            this.newCommentsAdapter.notifyDataSetChanged();
        } else {
            this.showEmptyLayout(this.getString(R.string.moments_info_no_comment), R.drawable.moments_img_no_comment);
        }
    }

    protected boolean initEventBus() {
        return true;
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onGetPageInfo(MomentsPageInfo pageInfo) {
        if (pageInfo.getMessageId().equals("momentComment/queryMomentNewCommentAndPraiseList")) {
            this.pageTimeStamp = pageInfo.getTimeStamp();
            this.loadCount = 20;
            if (pageInfo.isLastPage()) {
                this.mRefreshLayout.setEnableLoadMore(false);
                if (this.newCommentsAdapter != null) {
                    this.newCommentsAdapter.showLoadComplete(this.getString(R.string.moments_finish_load));
                }
            } else {
                this.mRefreshLayout.setEnableLoadMore(true);
            }
        }
    }

    public void onItemClick(View v, int position) {
    }
}

