/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.newcomment.business.impl;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BasePageResponse;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.MyCommentsBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.flow.newcomment.business.NewCommentListBusiness;
import com.xdja.moments.sdk.flow.newcomment.mvp.NewCommentsModel;
import com.xdja.moments.sdk.http.bean.request.BaseListParams;
import com.xdja.moments.sdk.http.bean.response.MyCommentsResponseBean;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import com.xdja.moments.sdk.utils.MomentImageUtil;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Observable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NewCommentListBusinessImpl
implements NewCommentListBusiness {
    NewCommentsModel newCommentsModel;
    private LifecycleProvider<Lifecycle.Event> provider;

    public NewCommentListBusinessImpl(LifecycleProvider<Lifecycle.Event> provider) {
        this.provider = provider;
        this.newCommentsModel = new NewCommentsModel();
    }

    @Override
    public Observable<List<MyCommentsBean>> getNewCommentsListData(BaseListParams requestBean) {
        return this.newCommentsModel.getNewComments(requestBean).compose(MomentsRxTransformer.momentsCompose(this.provider, requestBean)).map(BasePageResponse::getData).flatMap(Observable::fromIterable).map(this::getMyCommentsBean).toList().toObservable().compose(ObservableTransfor.io_main());
    }

    @NonNull
    private MyCommentsBean getMyCommentsBean(MyCommentsResponseBean comment) {
        MyCommentsBean myCommentsBean = new MyCommentsBean();
        myCommentsBean.setClassifyId(comment.getClassifyId());
        myCommentsBean.setCommentContent(comment.getCommentContent());
        myCommentsBean.setCommentFlag(comment.getCommentFlag());
        myCommentsBean.setIfComment(comment.getIfComment());
        myCommentsBean.setCommentId(comment.getCommentId());
        myCommentsBean.setCreateTime(comment.getCreateTime());
        myCommentsBean.setMomentContent(comment.getMomentContent());
        myCommentsBean.setMomentFileName(comment.getMomentFileName());
        myCommentsBean.setMomentFilePath(comment.getMomentFilePath());
        List<ImageBean> imageBeans = this.buildImageList(comment.getMomentPicturePath());
        myCommentsBean.setMomentPicturePath(imageBeans);
        myCommentsBean.setMomentFileType(comment.getMomentFileType());
        myCommentsBean.setMomentId(comment.getMomentId());
        myCommentsBean.setMomentShareContent(comment.getMomentShareContent());
        myCommentsBean.setMomentSharePicture(comment.getMomentSharePicture());
        myCommentsBean.setMomentShareUrl(comment.getMomentShareUrl());
        myCommentsBean.setMomentType(comment.getMomentType());
        myCommentsBean.setMomentVideoTime(comment.getMomentVideoTime());
        UserInfoBean userInfoBean = MomentsDataManager.getInstance().queryUserInfo(comment.getUserId());
        myCommentsBean.setUserInfo(userInfoBean);
        return myCommentsBean;
    }

    @NonNull
    private List<ImageBean> buildImageList(String imageFileIds) {
        ArrayList<ImageBean> imageList = new ArrayList<ImageBean>();
        if (!TextUtils.isEmpty((CharSequence)imageFileIds)) {
            List<String> imageFileIdList = Arrays.asList(imageFileIds.split("\\,"));
            for (String imageFileId : imageFileIdList) {
                ImageBean imageBean = new ImageBean();
                imageBean.setHeight(MomentImageUtil.getImageHeight(imageFileId));
                imageBean.setWidth(MomentImageUtil.getImageWidth(imageFileId));
                imageBean.setPath(MomentImageUtil.getImageUrl(imageFileId));
                imageList.add(imageBean);
            }
        }
        return imageList;
    }
}

