/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;
import com.xdja.moments.sdk.flow.publish.PublishActivity;
import permissions.dispatcher.PermissionUtils;

final class PublishActivityPermissionsDispatcher {
    private static final int REQUEST_GAINTLOCATIONPERMISSION = 3;
    private static final String[] PERMISSION_GAINTLOCATIONPERMISSION = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    private static final int REQUEST_TAKEMEDIA = 4;
    private static final String[] PERMISSION_TAKEMEDIA = new String[]{"android.permission.CAMERA"};

    private PublishActivityPermissionsDispatcher() {
    }

    static void takeMediaWithPermissionCheck(PublishActivity target) {
        if (PermissionUtils.hasSelfPermissions((Context)target, (String[])PERMISSION_TAKEMEDIA)) {
            target.takeMedia();
        } else {
            ActivityCompat.requestPermissions((Activity)target, (String[])PERMISSION_TAKEMEDIA, (int)4);
        }
    }

    static void gaintLocationPermissionWithPermissionCheck(PublishActivity target) {
        if (PermissionUtils.hasSelfPermissions((Context)target, (String[])PERMISSION_GAINTLOCATIONPERMISSION)) {
            target.gaintLocationPermission();
        } else {
            ActivityCompat.requestPermissions((Activity)target, (String[])PERMISSION_GAINTLOCATIONPERMISSION, (int)3);
        }
    }

    static void onRequestPermissionsResult(PublishActivity target, int requestCode, int[] grantResults) {
        switch (requestCode) {
            case 4: {
                if (PermissionUtils.verifyPermissions((int[])grantResults)) {
                    target.takeMedia();
                    break;
                }
                if (!PermissionUtils.shouldShowRequestPermissionRationale((Activity)target, (String[])PERMISSION_TAKEMEDIA)) {
                    target.showNeverAskForPermissions();
                    break;
                }
                target.showDeniedForPermissions();
                break;
            }
            case 3: {
                if (!PermissionUtils.verifyPermissions((int[])grantResults)) break;
                target.gaintLocationPermission();
                break;
            }
        }
    }
}

