/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.RadioButton;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.util.NetworkUtil;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.flow.publish.enumm.BrowseAuthType;
import com.xdja.moments.sdk.flow.publish.mvp.SelectBrowseAuthConstruct;
import com.xdja.moments.sdk.flow.publish.mvp.SelectBrowseAuthPresenter;

@Route(path="/publish/selectBrowseAuth")
public class SelectBrowseAuthActivity
extends BaseActivity
implements View.OnClickListener,
SelectBrowseAuthConstruct.View {
    private RadioButton radioPublic;
    private RadioButton radioFriend;
    private RadioButton radioDeptment;
    @Autowired(name="classify_id")
    public String classifyId;
    @Autowired(name="browse_auth_value")
    public String browseAuthValue;
    @Autowired(name="browse_auth", required=true)
    public int browseAuth;
    private SelectBrowseAuthPresenter selectBrowseAuthPresenter;

    protected void preGetRootView(Bundle savedInstanceState) {
        ARouter.getInstance().inject((Object)this);
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        this.selectBrowseAuthPresenter = new SelectBrowseAuthPresenter(this, provider);
        switch (this.browseAuth) {
            case 1: {
                this.radioPublic.setChecked(true);
                break;
            }
            case 2: {
                this.radioFriend.setChecked(true);
                break;
            }
            case 3: {
                this.radioDeptment.setChecked(true);
                break;
            }
            case 4: {
                break;
            }
            default: {
                this.browseAuth = 1;
                this.radioPublic.setChecked(true);
            }
        }
        this.selectBrowseAuthPresenter.getClassifyDeptDat(this.classifyId);
    }

    protected void initView() {
        this.setMomentsTitle("\u9009\u62e9\u8c01\u53ef\u4ee5\u770b");
        this.radioPublic = (RadioButton)this.findViewById(R.id.radio_public);
        this.radioFriend = (RadioButton)this.findViewById(R.id.radio_friend);
        this.radioDeptment = (RadioButton)this.findViewById(R.id.radio_deptment);
        this.radioPublic.setOnClickListener((View.OnClickListener)this);
        this.radioFriend.setOnClickListener((View.OnClickListener)this);
        this.radioDeptment.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.layout_public).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.layout_friend).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.layout_deptment).setOnClickListener((View.OnClickListener)this);
    }

    protected int getRootView() {
        return R.layout.moments_activity_select_viewers;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.radio_public || i == R.id.layout_public) {
            if (!NetworkUtil.isNetworkAvailable((Context)this)) {
                this.showToast(this.getString(R.string.moments_net_error_hint));
                return;
            }
            this.setChecked(true, false, false);
            Intent data1 = new Intent();
            data1.putExtra("android.intent.bundle.BROWSEAUTH_TYPE", BrowseAuthType.DEFAULT.getKey());
            this.setResult(-1, data1);
            this.finish();
        } else if (i == R.id.radio_friend || i == R.id.layout_friend) {
            if (!NetworkUtil.isNetworkAvailable((Context)this)) {
                this.showToast(this.getString(R.string.moments_net_error_hint));
                return;
            }
            this.setChecked(false, true, false);
            Intent data2 = new Intent();
            data2.putExtra("android.intent.bundle.BROWSEAUTH_TYPE", BrowseAuthType.FRIEND.getKey());
            this.setResult(-1, data2);
            this.finish();
        } else if (i == R.id.radio_deptment || i == R.id.layout_deptment) {
            this.setChecked(false, false, true);
            this.selectBrowseAuthPresenter.onSelectDeptClick(this.browseAuthValue);
        }
    }

    private void setChecked(boolean isPublic, boolean isFriend, boolean isDept) {
        this.radioPublic.setChecked(isPublic);
        this.radioFriend.setChecked(isFriend);
        this.radioDeptment.setChecked(isDept);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.selectBrowseAuthPresenter.onActivityResult(requestCode, resultCode, data);
    }

    protected LoadingType getLoadingType() {
        return LoadingType.LOAD_TYPE_DIALOG;
    }

    @Override
    public void setBrowseValue(String browseValue) {
        Intent data2 = new Intent();
        data2.putExtra("android.intent.bundle.BROWSEAUTH_TYPE", BrowseAuthType.DEPTMENT.getKey());
        data2.putExtra("android.intent.bundle.BROWSEAUTH_VALUE", browseValue);
        this.setResult(-1, data2);
        this.finish();
    }
}

