/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.moments.sdk.R;
import java.util.ArrayList;
import java.util.List;

public class PhotoReleaseGridAdapter
extends BaseAdapter {
    public static final int MAX_NUM = 9;
    private Context context;
    private LayoutInflater mLayoutInflater;
    private ArrayList<AppendixBean> dataLists;
    private OnItemClickListener listener;

    public PhotoReleaseGridAdapter(Context mContext) {
        this.mLayoutInflater = LayoutInflater.from((Context)mContext);
        this.context = mContext;
        this.dataLists = new ArrayList();
    }

    public int getCount() {
        if (this.dataLists.size() == 0) {
            return 0;
        }
        if (this.dataLists.size() == 1) {
            AppendixBean appendixBean = this.dataLists.get(0);
            switch (appendixBean.getType()) {
                case IMAGE: {
                    return 2;
                }
                case VIDEO: {
                    return 1;
                }
            }
            return 0;
        }
        if (this.dataLists.size() < 9) {
            return this.dataLists.size() + 1;
        }
        return 9;
    }

    public AppendixBean getItem(int position) {
        return this.dataLists.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        MyGridViewHolder viewHolder;
        if (convertView == null) {
            viewHolder = new MyGridViewHolder();
            convertView = this.mLayoutInflater.inflate(R.layout.moments_item_media, parent, false);
            viewHolder.content = (ImageView)convertView.findViewById(R.id.iv_content);
            viewHolder.play = (ImageView)convertView.findViewById(R.id.iv_video_play);
            viewHolder.delete = convertView.findViewById(R.id.btn_delete);
            viewHolder.gifSign = convertView.findViewById(R.id.gif_sign);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (MyGridViewHolder)convertView.getTag();
        }
        if (position < this.dataLists.size()) {
            viewHolder.content.setScaleType(ImageView.ScaleType.CENTER_CROP);
            AppendixBean bean = this.dataLists.get(position);
            viewHolder.delete.setVisibility(0);
            Glide.with((Context)this.context).load(bean.getPath()).fitCenter().error(R.drawable.moments_img_pic_default).placeholder(R.drawable.moments_img_pic_default).diskCacheStrategy(bean.getType() == AppendixBean.TYPE.IMAGE ? DiskCacheStrategy.ALL : DiskCacheStrategy.RESULT).into(viewHolder.content);
            viewHolder.content.setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onViewClick(bean);
                }
            });
            viewHolder.delete.setOnClickListener(v -> {
                AppendixBean deleteBean = this.getItem(position);
                this.dataLists.remove(deleteBean);
                this.notifyDataSetChanged();
                if (this.listener != null) {
                    this.listener.onDeleteClick(deleteBean);
                }
            });
            if (bean.getType() == AppendixBean.TYPE.VIDEO) {
                Glide.with((Context)this.context).load(bean.getPath()).fitCenter().error(R.drawable.moments_gray_rect_press).placeholder(R.drawable.moments_gray_rect_press).diskCacheStrategy(bean.getType() == AppendixBean.TYPE.IMAGE ? DiskCacheStrategy.ALL : DiskCacheStrategy.RESULT).into(viewHolder.content);
                viewHolder.play.setVisibility(0);
            } else {
                Glide.with((Context)this.context).load(bean.getPath()).fitCenter().error(R.drawable.moments_img_pic_default).placeholder(R.drawable.moments_img_pic_default).diskCacheStrategy(bean.getType() == AppendixBean.TYPE.IMAGE ? DiskCacheStrategy.ALL : DiskCacheStrategy.RESULT).into(viewHolder.content);
                viewHolder.play.setVisibility(8);
            }
        } else {
            viewHolder.content.setScaleType(ImageView.ScaleType.FIT_XY);
            viewHolder.content.setImageResource(R.drawable.moments_picture_add);
            viewHolder.delete.setVisibility(8);
            viewHolder.content.setOnClickListener(v -> {
                if (this.listener != null) {
                    this.listener.onAddClick();
                }
            });
        }
        return convertView;
    }

    public void add(AppendixBean o) {
        if (this.dataLists != null) {
            this.dataLists.add(o);
            this.notifyDataSetChanged();
        }
    }

    public void clear() {
        if (this.dataLists != null) {
            this.dataLists.clear();
            this.notifyDataSetChanged();
        }
    }

    public void addAll(List<AppendixBean> list) {
        if (this.dataLists != null) {
            this.dataLists.addAll(list);
            this.notifyDataSetChanged();
        }
    }

    public ArrayList<AppendixBean> getDataLists() {
        return this.dataLists;
    }

    public void setDataLists(ArrayList<AppendixBean> dataLists) {
        this.dataLists.clear();
        this.dataLists.addAll(dataLists);
        this.notifyDataSetChanged();
    }

    public void setListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public static interface OnItemClickListener {
        public void onViewClick(AppendixBean var1);

        public void onAddClick();

        public void onDeleteClick(AppendixBean var1);
    }

    private static class MyGridViewHolder {
        private ImageView content;
        private ImageView play;
        private View delete;
        private View gifSign;

        private MyGridViewHolder() {
        }
    }
}

