/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish.business.imp;

import android.arch.lifecycle.Lifecycle;
import android.text.TextUtils;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.baselibrary.rx.FlowableTransfor;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.moments.sdk.bean.PublishMomentsParam;
import com.xdja.moments.sdk.bean.SelectMomentsClassifyBean;
import com.xdja.moments.sdk.database.domain.MomentDraft;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.flow.publish.business.FastdfsBusiness;
import com.xdja.moments.sdk.flow.publish.business.PublishBusiness;
import com.xdja.moments.sdk.flow.publish.business.imp.FastdfsBusinessImp;
import com.xdja.moments.sdk.flow.publish.mvp.PublishModel;
import com.xdja.moments.sdk.http.bean.response.MomentsResponseBean;
import com.xdja.moments.sdk.repository.MomentDraftRepository;
import com.xdja.moments.sdk.repository.MomentsClassifyRepository;
import com.xdja.moments.sdk.utils.BitmapUtils;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;

public class PublishBusinessImp
implements PublishBusiness {
    private MomentsClassifyRepository classifyRepository = new MomentsClassifyRepository();
    private MomentDraftRepository draftRepository = new MomentDraftRepository();
    private FastdfsBusiness fastdfsBusiness = new FastdfsBusinessImp();
    private PublishModel publishModel = new PublishModel();
    private LifecycleProvider<Lifecycle.Event> lifecycleProvider;

    public PublishBusinessImp(LifecycleProvider<Lifecycle.Event> lifecycleProvider) {
        this.lifecycleProvider = lifecycleProvider;
    }

    @Override
    public Observable<MomentsResponseBean> publicMoments(PublishMomentsParam param, List<AppendixBean> appendixBeanList) {
        ArrayList<AppendixBean> list = new ArrayList<AppendixBean>();
        if (!ListUtil.isEmpty(appendixBeanList)) {
            for (AppendixBean bean : appendixBeanList) {
                switch (bean.getType()) {
                    case IMAGE: 
                    case FILE: {
                        list.add(bean);
                        break;
                    }
                    case VIDEO: {
                        AppendixBean thumbAppendixBean = new AppendixBean();
                        thumbAppendixBean.setPath(bean.getThumbPath());
                        thumbAppendixBean.setType(AppendixBean.TYPE.IMAGE);
                        list.add(thumbAppendixBean);
                        list.add(bean);
                    }
                }
            }
        }
        return Observable.fromIterable(list).map(appendixBean -> {
            if (appendixBean.getType() == AppendixBean.TYPE.IMAGE) {
                appendixBean.setPath(BitmapUtils.compPicture(appendixBean.getPath()));
            }
            return appendixBean;
        }).map(appendixBean -> {
            String fileId = this.fastdfsBusiness.uploadFile(appendixBean.getPath());
            appendixBean.setFileId(fileId);
            return appendixBean;
        }).toList().toObservable().map(appendixBeans -> this.operateFileId((List<AppendixBean>)appendixBeans, param)).flatMap(param1 -> this.publishModel.publishMoments((PublishMomentsParam)((Object)param1)).compose(MomentsRxTransformer.momentsComposeNet(this.lifecycleProvider, param1))).compose(ObservableTransfor.io_main());
    }

    private PublishMomentsParam operateFileId(List<AppendixBean> appendixBeans, PublishMomentsParam param) {
        for (AppendixBean bean : appendixBeans) {
            String fileId = bean.getFileId();
            if (TextUtils.isEmpty((CharSequence)fileId)) continue;
            if (bean.getType() == AppendixBean.TYPE.IMAGE) {
                int[] widthAndHeight = BitmapUtils.getImageWidthHeight(bean.getPath());
                fileId = fileId + "&" + widthAndHeight[0] + "*" + widthAndHeight[1];
                String picturePath = param.getMomentPicturePath();
                if (!TextUtils.isEmpty((CharSequence)picturePath)) {
                    param.setMomentPicturePath(picturePath + "," + fileId);
                    continue;
                }
                param.setMomentPicturePath(fileId);
                continue;
            }
            param.setMomentFilePath(fileId);
        }
        return param;
    }

    @Override
    public Flowable<List<SelectMomentsClassifyBean>> getCanPublishClassifyBean() {
        return this.classifyRepository.getCanPublishClassifyList().map(this::covert).compose(FlowableTransfor.io_main()).compose((FlowableTransformer)this.lifecycleProvider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY));
    }

    private List<SelectMomentsClassifyBean> covert(List<MomentsClassify> momentsClassifies) {
        ArrayList<SelectMomentsClassifyBean> list = new ArrayList<SelectMomentsClassifyBean>();
        for (MomentsClassify momentsClassify : momentsClassifies) {
            SelectMomentsClassifyBean bean = new SelectMomentsClassifyBean();
            bean.setClassifyId(momentsClassify.getClassifyId());
            bean.setClassifyName(momentsClassify.getClassifyName());
            list.add(bean);
        }
        return list;
    }

    @Override
    public Maybe<Boolean> saveMomentDraft(MomentDraft draft) {
        return this.draftRepository.insert(draft);
    }

    @Override
    public Single<MomentDraft> getMomentDraft() {
        return this.draftRepository.getMomentDraft().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    @Override
    public void deleteDraft(MomentDraft momentDraft) {
        this.draftRepository.delete(momentDraft).subscribe();
    }
}

