/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish.mvp;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseObserver;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.media.AppendixBean;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.baselibrary.util.FileUtils;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.ImageBean;
import com.xdja.moments.sdk.bean.PublishMomentsParam;
import com.xdja.moments.sdk.bean.SelectMomentsClassifyBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.bean.VideoBean;
import com.xdja.moments.sdk.bean.location.LocationBean;
import com.xdja.moments.sdk.bean.location.MomentsLocationHelper;
import com.xdja.moments.sdk.bean.share.BaseShareBean;
import com.xdja.moments.sdk.bean.share.ShareFileBean;
import com.xdja.moments.sdk.bean.share.ShareImageBean;
import com.xdja.moments.sdk.bean.share.ShareLinkBean;
import com.xdja.moments.sdk.bean.share.ShareVideoBean;
import com.xdja.moments.sdk.database.domain.MomentDraft;
import com.xdja.moments.sdk.eventbus.MomentDetailEvent;
import com.xdja.moments.sdk.flow.publish.adapter.PhotoReleaseGridAdapter;
import com.xdja.moments.sdk.flow.publish.business.PublishBusiness;
import com.xdja.moments.sdk.flow.publish.business.imp.PublishBusinessImp;
import com.xdja.moments.sdk.flow.publish.mvp.PublishActivityConstruct;
import com.xdja.moments.sdk.http.bean.response.MomentsResponseBean;
import com.xdja.moments.sdk.manager.FileTypeManager;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import com.xdja.moments.sdk.manager.location.MomentsLocationManager;
import com.xdja.moments.sdk.utils.DeviceUtil;
import com.xdja.moments.sdk.utils.FileUtil;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.ObservableTransformer;
import io.reactivex.Observer;
import io.reactivex.SingleTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;

public class PublishPresenter
implements PublishActivityConstruct.Presenter {
    @NonNull
    private PublishActivityConstruct.View view;
    private LifecycleProvider<Lifecycle.Event> lifecycleProvider;
    private Context context;
    private AlertDialog choseMediaTypeDialog;
    private AlertDialog addPictureDialog;
    private String takePicturePath;
    private AppendixBean fileBean;
    private LocationBean location;
    private PublishBusiness publishBusiness;
    private PhotoReleaseGridAdapter adapter;
    private List<SelectMomentsClassifyBean> classifyBeanList;
    private List<UserInfoBean> atUsers;
    private MomentDraft momentDraft;
    private MomentsLocationHelper locationHelper;
    private BaseShareBean shareBean = null;
    private boolean hasPowerPublish;
    private int browseAuthType = 1;
    private String browseAuthValue;
    private String classifyId;
    private int momentType = 1;

    public PublishPresenter(@NonNull PublishActivityConstruct.View view) {
        this.view = view;
        this.lifecycleProvider = view.getLifecycleProvider();
        this.context = (Context)view;
        this.publishBusiness = new PublishBusinessImp(this.lifecycleProvider);
    }

    @Override
    public void initDefaultData(BaseShareBean baseShareBean) {
        this.getDefaultLocation();
        this.getClassifyInfos();
        if (baseShareBean == null) {
            this.getDraft();
        } else {
            this.shareBean = baseShareBean;
            this.initShareData(this.shareBean);
        }
    }

    private void initShareData(BaseShareBean bean) {
        if (bean == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)bean.getContent())) {
            this.view.setContentText(bean.getContent());
        }
        if (bean.getType() == 1) {
            this.momentType = 1;
        } else if (bean.getType() == 2) {
            String[] filePaths;
            this.momentType = 2;
            for (String tempFilePath : filePaths = ((ShareImageBean)bean).getPath().split(",")) {
                this.handleFile(tempFilePath);
            }
        } else if (bean.getType() == 3) {
            this.momentType = 3;
            this.handleFile(((ShareVideoBean)bean).getPath());
        } else if (bean.getType() == 4) {
            this.momentType = 4;
            this.handleFile(((ShareFileBean)bean).getPath());
            this.view.showFileView(true);
            this.view.setFileView(this.fileBean);
        } else if (bean.getType() == 5) {
            this.momentType = 5;
            String url = ((ShareLinkBean)bean).getShareUrl();
            String description = ((ShareLinkBean)bean).getDescription();
            String thumbPath = ((ShareLinkBean)bean).getThumbPath();
            this.view.setLinkView(thumbPath, url, description);
        }
        new Handler().postDelayed(() -> this.refreshPublishButton(), 100L);
    }

    private void getDraft() {
        Disposable disposable = this.publishBusiness.getMomentDraft().compose((SingleTransformer)this.lifecycleProvider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(momentDraft -> this.initMomentDraft((MomentDraft)momentDraft), throwable -> throwable.printStackTrace());
    }

    private void initMomentDraft(MomentDraft momentDraft) {
        if (momentDraft == null) {
            return;
        }
        this.momentDraft = momentDraft;
        this.classifyId = momentDraft.getClassifyId();
        this.momentType = momentDraft.getMomentType();
        this.browseAuthType = momentDraft.getBrowseAuth();
        this.browseAuthValue = momentDraft.getBrowseAuthValue();
        if (!TextUtils.isEmpty((CharSequence)momentDraft.getMomentContent())) {
            this.view.setContentText(momentDraft.getMomentContent());
        }
        this.view.setBrowseAuthTypeView(this.browseAuthType);
        this.view.setClassifyView(momentDraft.getClassifyName());
        String picListStr = momentDraft.getMomentPicturePath();
        if (!TextUtils.isEmpty((CharSequence)picListStr)) {
            String[] picArray = picListStr.split(",");
            ArrayList<AppendixBean> list = new ArrayList<AppendixBean>();
            for (String s : picArray) {
                AppendixBean bean = new AppendixBean();
                if (this.momentType == 2) {
                    bean.setType(AppendixBean.TYPE.IMAGE);
                    bean.setPath(s);
                } else if (this.momentType == 3) {
                    bean.setType(AppendixBean.TYPE.VIDEO);
                    bean.setPath(momentDraft.getMomentFilePath());
                    bean.setVideoTime((long)Integer.parseInt(momentDraft.getMomentVideoTime()));
                    bean.setThumbPath(s);
                }
                list.add(bean);
            }
            this.adapter.addAll(list);
        }
        if (!TextUtils.isEmpty((CharSequence)momentDraft.getMomentFilePath()) && FileTypeManager.getFileType(momentDraft.getMomentFilePath()) != FileTypeManager.FileType.VIDEO) {
            this.fileBean = new AppendixBean();
            this.fileBean.setType(AppendixBean.TYPE.FILE);
            this.fileBean.setPath(momentDraft.getMomentFilePath());
            this.fileBean.setFileId(momentDraft.getMomentFileId());
            this.fileBean.setResId(FileTypeManager.getFileIconRes(momentDraft.getMomentFileType()));
            this.view.setFileView(this.fileBean);
        }
        new Handler().postDelayed(() -> this.refreshPublishButton(), 100L);
    }

    private String getClassifyName(String classifyId) {
        for (SelectMomentsClassifyBean bean : this.classifyBeanList) {
            if (!TextUtils.equals((CharSequence)classifyId, (CharSequence)bean.getClassifyId())) continue;
            return bean.getClassifyName();
        }
        return "";
    }

    private void getDefaultLocation() {
        this.locationHelper = MomentsLocationManager.getInstance().getHelper();
        if (this.locationHelper == null) {
            return;
        }
        this.locationHelper.init(((Activity)this.context).getApplication());
        this.locationHelper.startLocation();
        this.locationHelper.addObserver(new java.util.Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (arg instanceof LocationBean) {
                    PublishPresenter.this.onLocationChange((LocationBean)arg);
                }
            }
        });
    }

    private void getClassifyInfos() {
        Disposable disposable = this.publishBusiness.getCanPublishClassifyBean().subscribe(items -> {
            if (items != null && items.size() > 0) {
                ((SelectMomentsClassifyBean)items.get(0)).setClassifyName("\u9ed8\u8ba4");
                this.classifyBeanList = items;
                if (TextUtils.isEmpty((CharSequence)this.classifyId)) {
                    this.classifyId = ((SelectMomentsClassifyBean)items.get(0)).getClassifyId();
                }
                this.hasPowerPublish = true;
                this.refreshPublishButton();
            } else {
                this.refreshPublishButton();
                this.view.showToast(this.context.getString(R.string.moments_no_publish_power_classify));
            }
        }, throwable -> {
            throwable.printStackTrace();
            this.view.showToast(throwable.getMessage());
        });
    }

    @Override
    public void publishMomentsData() {
        if (TextUtils.isEmpty((CharSequence)this.view.getContentText()) && this.mediaIsEmpty()) {
            this.view.showToast(this.context.getString(R.string.moments_input_first));
            return;
        }
        if (this.classifyBeanList == null) {
            this.view.showToast(this.context.getString(R.string.moments_no_publish_power_classify));
            return;
        }
        ArrayList<Object> uploadList = null;
        switch (this.momentType) {
            case 2: 
            case 3: {
                uploadList = this.adapter.getDataLists();
                break;
            }
            case 4: {
                uploadList = new ArrayList();
                uploadList.add(this.fileBean);
            }
        }
        this.publishBusiness.publicMoments(this.generatePublishMomentParam(), uploadList).subscribe((Observer)new BaseObserver<MomentsResponseBean>((IBaseView)this.view, this.context.getString(R.string.moments_publish_loading), "momentInfo/publishMomentInfo"){

            public void onNext(MomentsResponseBean responseBean) {
                if (PublishPresenter.this.momentDraft != null) {
                    PublishPresenter.this.publishBusiness.deleteDraft(PublishPresenter.this.momentDraft);
                }
                if (responseBean != null && responseBean.getMomentVerifyStatus() == 1) {
                    PublishPresenter.this.view.showToast(PublishPresenter.this.context.getString(R.string.moments_wait_for_verify));
                } else if (responseBean != null) {
                    EventBus.getDefault().post((Object)new MomentDetailEvent(MomentDetailEvent.TYPE_RELEASE, responseBean.getClassifyId(), responseBean.getMomentId()));
                }
                PublishPresenter.this.view.finish();
            }
        });
    }

    private boolean mediaIsEmpty() {
        switch (this.momentType) {
            case 2: 
            case 3: {
                return ListUtil.isEmpty(this.adapter.getDataLists());
            }
            case 4: {
                return this.fileBean == null;
            }
            case 5: {
                return this.shareBean == null;
            }
        }
        return true;
    }

    private PublishMomentsParam generatePublishMomentParam() {
        PublishMomentsParam publishParam = new PublishMomentsParam();
        publishParam.setMomentContent(this.view.getContentText());
        if (this.location != null) {
            publishParam.setAddress(this.location.getAddress());
            publishParam.setLatitude(this.location.getLatitude() + "");
            publishParam.setLongitude(this.location.getLongitude() + "");
            publishParam.setAddressDetail(this.location.getAddressDetail());
        }
        publishParam.setClassifyId(this.classifyId);
        switch (this.momentType) {
            case 2: {
                break;
            }
            case 3: {
                AppendixBean bean = this.adapter.getItem(0);
                publishParam.setMomentFileSize(FileUtils.getFileSize((String)bean.getPath()));
                publishParam.setMomentFileName(FileUtils.getFileName((String)bean.getPath()));
                publishParam.setMomentVideoTime(String.valueOf(bean.getVieoTime()));
                publishParam.setMomentFileType(FileUtils.getFileExtension((String)bean.getPath()));
                break;
            }
            case 4: {
                publishParam.setMomentFileSize(FileUtils.getFileSize((String)this.fileBean.getPath()));
                publishParam.setMomentFileName(FileUtils.getFileName((String)this.fileBean.getPath()));
                publishParam.setMomentFileType(FileUtils.getFileExtension((String)this.fileBean.getPath()));
                break;
            }
            case 5: {
                if (this.shareBean == null || !(this.shareBean instanceof ShareLinkBean)) break;
                publishParam.setMomentSharePicture(((ShareLinkBean)this.shareBean).getThumbPath());
                publishParam.setMomentShareUrl(((ShareLinkBean)this.shareBean).getShareUrl());
                publishParam.setMomentShareContent(((ShareLinkBean)this.shareBean).getDescription());
            }
        }
        if (this.shareBean != null) {
            publishParam.setShareFlag("2");
            publishParam.setShareSource(this.shareBean.getShareFrom());
        } else {
            publishParam.setShareFlag("1");
        }
        publishParam.setMomentType(String.valueOf(this.momentType));
        publishParam.setAtIds(this.generateAtIds());
        publishParam.setBrowseAuth(String.valueOf(this.browseAuthType));
        publishParam.setBrowseAuthValue(this.browseAuthValue);
        return publishParam;
    }

    private String generatePicturePath() {
        ArrayList<AppendixBean> appendixBeans = this.adapter.getDataLists();
        if (ListUtil.isEmpty(appendixBeans)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (AppendixBean bean : appendixBeans) {
            stringBuilder.append(bean.getPath());
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private List<String> generatePicturePathToList() {
        ArrayList<AppendixBean> appendixBeans = this.adapter.getDataLists();
        ArrayList<String> list = new ArrayList<String>();
        for (AppendixBean bean : appendixBeans) {
            list.add(bean.getPath());
        }
        return list;
    }

    private String generateAtIds() {
        if (ListUtil.isEmpty(this.atUsers)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (UserInfoBean atUser : this.atUsers) {
            stringBuilder.append(atUser.getUserId());
            stringBuilder.append(",");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public PhotoReleaseGridAdapter getPictureAdapter() {
        if (this.adapter == null) {
            this.adapter = new PhotoReleaseGridAdapter(this.context);
            this.adapter.setListener(new PhotoReleaseGridAdapter.OnItemClickListener(){

                @Override
                public void onViewClick(AppendixBean bean) {
                    if (bean.getType() == AppendixBean.TYPE.IMAGE) {
                        PublishPresenter.this.viewPictureDetail(PublishPresenter.this.adapter.getDataLists().indexOf(bean));
                    } else if (bean.getType() == AppendixBean.TYPE.VIDEO) {
                        PublishPresenter.this.playVideo(bean);
                    }
                }

                @Override
                public void onAddClick() {
                    PublishPresenter.this.onAddPictureClick();
                }

                @Override
                public void onDeleteClick(AppendixBean item) {
                    if (ListUtil.isEmpty(PublishPresenter.this.adapter.getDataLists())) {
                        PublishPresenter.this.browseAuthType = 1;
                    }
                    PublishPresenter.this.refreshPublishButton();
                }
            });
        }
        return this.adapter;
    }

    @Override
    public void onFaceIconClick(boolean isCheck) {
        if (isCheck) {
            this.view.hideKeyboard();
            Disposable disposable = io.reactivex.Observable.timer((long)200L, (TimeUnit)TimeUnit.MILLISECONDS).compose(MomentsRxTransformer.momentsComposeIoAndError(this.lifecycleProvider)).subscribe(aLong -> this.view.showFaceGridView(true));
        } else {
            this.view.showKeyBoard();
            this.view.showFaceGridView(false);
        }
    }

    @Override
    public void onCameraIconClick() {
        if (!this.checkCanAddMedia()) {
            return;
        }
        if (this.choseMediaTypeDialog == null) {
            this.choseMediaTypeDialog = new AlertDialog.Builder(this.context).setItems((CharSequence[])this.context.getResources().getStringArray(R.array.moments_medias), (dialogInterface, i) -> {
                switch (i) {
                    case 0: {
                        this.takePicture();
                        break;
                    }
                    case 1: {
                        this.takeVideo();
                        break;
                    }
                    case 2: {
                        this.selectPictureFromMobile();
                        break;
                    }
                    case 3: {
                        this.selectVideoFromMobile();
                    }
                }
            }).create();
        }
        this.choseMediaTypeDialog.show();
    }

    @Override
    public void onAddPictureClick() {
        if (this.addPictureDialog == null) {
            this.addPictureDialog = new AlertDialog.Builder(this.context).setItems((CharSequence[])this.context.getResources().getStringArray(R.array.moments_medias_picture), (dialogInterface, i) -> {
                switch (i) {
                    case 0: {
                        this.takePicture();
                        break;
                    }
                    case 1: {
                        this.selectPictureFromMobile();
                    }
                }
            }).create();
        }
        this.addPictureDialog.show();
    }

    public void viewPictureDetail(int currentIndex) {
        ArrayList<AppendixBean> list = this.adapter.getDataLists();
        ArrayList<ImageBean> imageBeanList = new ArrayList<ImageBean>();
        for (AppendixBean appendixBean : list) {
            if (appendixBean == null) continue;
            ImageBean imageBean = new ImageBean();
            imageBean.setPath(appendixBean.getPath());
            imageBeanList.add(imageBean);
        }
        Navigation.navigationGallery(this.context, currentIndex, imageBeanList);
    }

    private void playVideo(AppendixBean appendixBean) {
        VideoBean videoBean = new VideoBean();
        videoBean.setVideoFileId(appendixBean.getPath());
        videoBean.setTitle(FileUtil.getFileName(appendixBean.getPath()));
        videoBean.setVideoPrevPath(appendixBean.getThumbPath());
        Navigation.navigationVideoDetailActivity(videoBean);
    }

    @Override
    public void onDeleteFileClick() {
        this.fileBean = null;
        this.view.showFileView(false);
        this.view.setFileView(null);
        this.browseAuthType = 1;
        this.refreshPublishButton();
    }

    @Override
    public void onBrowseAuthClick() {
        Navigation.navigationSelectBrowseAuthActivity((Activity)this.view, this.classifyId, this.browseAuthType, this.browseAuthValue);
    }

    @Override
    public void onBackPressed() {
        if (!TextUtils.isEmpty((CharSequence)this.view.getContentText()) || !this.mediaIsEmpty()) {
            this.view.showSaveDraftDialog();
        } else {
            this.view.hideKeyboard();
            this.view.showExitDialog();
        }
    }

    @Override
    public void onFolderIconClick() {
        if (!this.checkCanAddFile()) {
            return;
        }
        Navigation.navigationFilePicker((Activity)this.context, 1, 50, R.style.moments_AppTheme);
    }

    @Override
    public void onAtIconClick() {
        Navigation.navigationSelectPerson((Activity)this.view, this.atUsers, 9);
    }

    @Override
    public void onLocationIconClick() {
        if (this.location != null) {
            Navigation.navigationLocationActivity((Activity)this.view, true, this.location.getAddress(), this.location.getAddressDetail(), this.location.getLongitude(), this.location.getLatitude(), this.location.getCityCode());
        } else {
            Navigation.navigationLocationActivity((Activity)this.view, true);
        }
    }

    @Override
    public void onDeleteLocationClick() {
        this.location = null;
        this.view.setLocation("");
    }

    @Override
    public void onClassifyClick() {
        Navigation.navigationSelectClassify((Activity)this.view, this.classifyBeanList, this.classifyId);
    }

    private void takePicture() {
        if (!this.checkCanAddPicture()) {
            return;
        }
        StringBuilder fileName = new StringBuilder();
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        fileName.append(UUID.randomUUID()).append(".png");
        File tempFile = new File(this.context.getExternalFilesDir(Environment.DIRECTORY_PICTURES), fileName.toString());
        if (Build.VERSION.SDK_INT >= 24) {
            intent.setFlags(3);
            Uri uri = FileProvider.getUriForFile((Context)this.context, (String)(this.context.getPackageName() + ".fileProvider"), (File)tempFile);
            intent.putExtra("output", (Parcelable)uri);
        } else {
            Uri uri = Uri.fromFile((File)tempFile);
            intent.putExtra("output", (Parcelable)uri);
        }
        this.takePicturePath = tempFile.getAbsolutePath();
        this.view.mStartActivityForResult(intent, 257);
    }

    private void takeVideo() {
        if (!this.checkCanAddVideo()) {
            return;
        }
        if (!DeviceUtil.isExitsSdcard()) {
            this.view.showToast(this.context.getString(R.string.moments_no_sdcard_no_take_picture));
            return;
        }
        Navigation.navigationTakeVideo((Activity)this.view);
    }

    private void selectPictureFromMobile() {
        if (!this.checkCanAddPicture()) {
            return;
        }
        Navigation.navigationSelectPictureActivity((Activity)this.view, this.generatePicturePathToList());
    }

    private void selectVideoFromMobile() {
        if (!this.checkCanAddVideo()) {
            return;
        }
        Navigation.navigationSelectPictureActivity((Activity)this.view, this.generatePicturePathToList());
    }

    public void onLocationChange(LocationBean bean) {
        if (null != bean) {
            this.location = bean;
            this.view.showLocationView(true);
            this.view.showDefaultLocationView(false);
            this.view.setLocation(this.location.getAddress());
            this.locationHelper.release();
        }
    }

    private boolean checkCanAddMedia() {
        if (this.fileBean != null) {
            this.view.showToast(this.context.getString(R.string.moments_pic_file_video_conflict));
            return false;
        }
        if (!ListUtil.isEmpty(this.adapter.getDataLists())) {
            if (this.adapter.getDataLists().get(0).getType() == AppendixBean.TYPE.VIDEO) {
                this.view.showToast(this.context.getString(R.string.moments_pic_video_conflict));
                return false;
            }
            if (this.adapter.getDataLists().size() >= 9) {
                this.view.showToast(this.context.getString(R.string.moments_pic_max_num));
                return false;
            }
        }
        return true;
    }

    private boolean checkCanAddPicture() {
        ArrayList<AppendixBean> list = this.adapter.getDataLists();
        if (ListUtil.isEmpty(list)) {
            return true;
        }
        if (list.size() >= 9) {
            this.view.showToast(this.context.getString(R.string.moments_pic_max_num));
            return false;
        }
        AppendixBean bean = (AppendixBean)list.get(0);
        if (bean.getType() == AppendixBean.TYPE.VIDEO) {
            this.view.showToast(this.context.getString(R.string.moments_pic_video_conflict));
            return false;
        }
        return true;
    }

    private boolean checkCanAddVideo() {
        ArrayList<AppendixBean> list = this.adapter.getDataLists();
        if (ListUtil.isEmpty(list)) {
            return true;
        }
        AppendixBean bean = (AppendixBean)list.get(0);
        if (bean.getType() == AppendixBean.TYPE.VIDEO) {
            this.view.showToast(this.context.getString(R.string.moments_video_max_num));
            return false;
        }
        this.view.showToast(this.context.getString(R.string.moments_pic_video_conflict));
        return false;
    }

    private boolean checkCanAddFile() {
        if (this.fileBean != null) {
            this.view.showToast(this.context.getString(R.string.moments_file_max_num));
            return false;
        }
        ArrayList<AppendixBean> list = this.adapter.getDataLists();
        if (!ListUtil.isEmpty(list)) {
            this.view.showToast(this.context.getString(R.string.moments_pic_file_video_conflict));
            return false;
        }
        return true;
    }

    @Override
    public void onActivityResult(int requestCode, Intent data) {
        switch (requestCode) {
            case 257: {
                this.momentType = 2;
                this.handleFile(this.takePicturePath);
                break;
            }
            case 258: {
                this.momentType = 3;
                String videoPath = data.getStringExtra("com.jmolsmobile.extraoutputfilename");
                this.handleFile(videoPath);
                break;
            }
            case 260: {
                ArrayList selectedPicPaths = data.getStringArrayListExtra("selected_media");
                if (ListUtil.isEmpty((List)selectedPicPaths)) break;
                this.handleSelcetList(selectedPicPaths);
                break;
            }
            case 259: {
                ArrayList fileList = (ArrayList)data.getSerializableExtra("selected_file");
                if (ListUtil.isEmpty((List)fileList)) break;
                this.handleSelcetList(fileList);
                break;
            }
            case 263: {
                this.browseAuthType = data.getIntExtra("android.intent.bundle.BROWSEAUTH_TYPE", 1);
                this.browseAuthValue = data.getStringExtra("android.intent.bundle.BROWSEAUTH_VALUE");
                this.view.setBrowseAuthTypeView(this.browseAuthType);
                break;
            }
            case 264: {
                this.classifyId = data.getStringExtra("classifyId");
                String classifyName = data.getStringExtra("classifyName");
                this.view.setClassifyView(classifyName);
                break;
            }
            case 265: {
                ArrayList atUsersIdList = (ArrayList)data.getSerializableExtra("select_users");
                io.reactivex.Observable.just((Object)atUsersIdList).map(strings -> MomentsDataManager.getInstance().queryUserList((List<String>)strings)).compose(ObservableTransfor.io_main()).compose((ObservableTransformer)this.lifecycleProvider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(userInfoBeans -> {
                    this.atUsers = userInfoBeans;
                    this.view.setAtView(this.atUsers);
                });
                break;
            }
            case 262: {
                if (this.location == null) {
                    this.location = new LocationBean();
                }
                String address = data.getStringExtra("address");
                String addressDetail = data.getStringExtra("addressdetail");
                double longitude = data.getDoubleExtra("longitude", 0.0);
                double latitude = data.getDoubleExtra("latitude", 0.0);
                String cityCode = data.getStringExtra("cityCode");
                this.location.setAddress(address);
                this.location.setAddressDetail(addressDetail);
                this.location.setLatitude(latitude);
                this.location.setLongitude(longitude);
                this.location.setCityCode(cityCode);
                this.view.setLocation(address);
            }
        }
    }

    @Override
    public void saveDraft() {
        MomentDraft momentDraft = new MomentDraft();
        momentDraft.setAtIds(this.generateAtIds());
        momentDraft.setBrowseAuth(this.browseAuthType);
        momentDraft.setBrowseAuthValue(this.browseAuthValue);
        momentDraft.setCreateTime(System.currentTimeMillis());
        momentDraft.setMomentContent(this.view.getContentText());
        momentDraft.setMomentType(this.momentType);
        if (this.fileBean != null) {
            switch (this.fileBean.getType()) {
                case FILE: {
                    momentDraft.setMomentFileType(FileUtils.getFileExtension((String)this.fileBean.getPath()));
                }
            }
            momentDraft.setMomentFileName(FileUtils.getFileName((String)this.fileBean.getPath()));
            momentDraft.setMomentFilePath(this.fileBean.getPath());
            momentDraft.setMomentFileSize(FileUtils.getFileSize((String)this.fileBean.getPath()));
        }
        if (!ListUtil.isEmpty(this.adapter.getDataLists())) {
            if (this.momentType == 2) {
                momentDraft.setMomentPicturePath(this.generatePicturePath());
            } else if (this.momentType == 3) {
                AppendixBean appendixBean = this.adapter.getDataLists().get(0);
                momentDraft.setMomentFilePath(appendixBean.getPath());
                momentDraft.setMomentVideoTime(appendixBean.getVideoTime() > 0L ? String.valueOf(appendixBean.getVideoTime()) : "0");
                momentDraft.setMomentPicturePath(appendixBean.getThumbPath());
            }
        }
        if (this.shareBean != null && this.shareBean instanceof ShareLinkBean) {
            momentDraft.setMomentShareContent(this.shareBean.getContent());
            momentDraft.setMomentSharePicture(((ShareLinkBean)this.shareBean).getThumbPath());
            momentDraft.setMomentShareUrl(((ShareLinkBean)this.shareBean).getShareUrl());
        }
        momentDraft.setUserId(MomentsManager.getInstance().getLoginer().getUserId());
        momentDraft.setClassifyId(this.classifyId);
        momentDraft.setClassifyName(this.getClassifyName(this.classifyId));
        Disposable disposable = this.publishBusiness.saveMomentDraft(momentDraft).subscribe(aBoolean -> {
            if (aBoolean.booleanValue()) {
                this.view.showToast(this.context.getString(R.string.moments_draft_save_success));
                this.view.finish();
            } else {
                this.view.showToast(this.context.getString(R.string.moments_draft_save_fail));
            }
        }, throwable -> {
            throwable.printStackTrace();
            this.view.showToast(this.context.getString(R.string.moments_draft_save_fail));
        });
    }

    @Override
    public void release() {
        if (this.locationHelper != null) {
            this.locationHelper.release();
        }
    }

    @Override
    public void refreshPublishButton() {
        if (!this.hasPowerPublish) {
            this.view.setCanPublish(false);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.view.getContentText()) && this.mediaIsEmpty()) {
            this.view.setCanPublish(false);
        } else {
            this.view.setCanPublish(true);
        }
    }

    @Override
    public void onClickDialogFinish() {
        if (this.momentDraft != null) {
            this.deleteDraft();
        }
        this.view.finish();
    }

    private void handleFile(String filePath) {
        FileTypeManager.FileType fileType = FileTypeManager.getType(FileUtils.getFileExtension((String)filePath));
        if (fileType == FileTypeManager.FileType.IMAGE) {
            if (FileUtils.getFileSize((String)filePath) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddPicture()) {
                this.momentType = 2;
                this.operateFile(filePath, (Observer<AppendixBean>)new BaseObserver<AppendixBean>((IBaseView)this.view, "\u56fe\u7247\u538b\u7f29\u4e2d..."){

                    public void onNext(AppendixBean o) {
                        super.onNext((Object)o);
                        PublishPresenter.this.adapter.add(o);
                        PublishPresenter.this.refreshPublishButton();
                    }
                });
            }
        } else if (fileType == FileTypeManager.FileType.VIDEO) {
            if (FileUtils.getFileSize((String)filePath) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddVideo()) {
                this.momentType = 3;
                this.operateFile(filePath, (Observer<AppendixBean>)new BaseObserver<AppendixBean>((IBaseView)this.view, "\u89c6\u9891\u5904\u7406\u4e2d..."){

                    public void onNext(AppendixBean o) {
                        super.onNext((Object)o);
                        PublishPresenter.this.adapter.add(o);
                        PublishPresenter.this.refreshPublishButton();
                    }
                });
            }
        } else {
            if (FileUtils.getFileSize((String)filePath) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddFile()) {
                this.momentType = 4;
                this.fileBean = FileTypeManager.fileAppendixBean(filePath);
                this.refreshPublishButton();
            }
        }
    }

    private void handleSelcetList(List<String> selectedPathList) {
        if (ListUtil.isEmpty(selectedPathList)) {
            return;
        }
        if (FileTypeManager.getFileType(selectedPathList.get(0)) == FileTypeManager.FileType.IMAGE) {
            if (selectedPathList.size() > 9) {
                this.view.showToast(this.context.getString(R.string.moments_pic_max_num));
                return;
            }
            this.adapter.clear();
            Iterator<String> iterator = selectedPathList.iterator();
            while (iterator.hasNext()) {
                String selectedPicture = iterator.next();
                if (FileUtils.getFileSize((String)selectedPicture) < 0x3200000L) continue;
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                iterator.remove();
            }
            this.momentType = 2;
            io.reactivex.Observable.fromIterable(selectedPathList).flatMap(path -> io.reactivex.Observable.just((Object)path).map(s -> FileTypeManager.fileAppendixBean(s))).toList().toObservable().compose(MomentsRxTransformer.momentsComposeIoAndError(this.lifecycleProvider)).subscribe((Observer)new BaseObserver<List<AppendixBean>>((IBaseView)this.view, "\u56fe\u7247\u538b\u7f29\u4e2d\u2026\u2026"){

                public void onNext(List<AppendixBean> appendixBeans) {
                    super.onNext(appendixBeans);
                    PublishPresenter.this.adapter.addAll(appendixBeans);
                    PublishPresenter.this.refreshPublishButton();
                }
            });
        } else if (FileTypeManager.getFileType(selectedPathList.get(0)) == FileTypeManager.FileType.VIDEO) {
            if (selectedPathList.size() > 1) {
                this.view.showToast(this.context.getString(R.string.moments_video_max_num));
                return;
            }
            if (FileUtils.getFileSize((String)selectedPathList.get(0)) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            this.adapter.clear();
            this.momentType = 3;
            this.operateFile(selectedPathList.get(0), (Observer<AppendixBean>)new BaseObserver<AppendixBean>((IBaseView)this.view, "\u89c6\u9891\u5904\u7406\u4e2d..."){

                public void onNext(AppendixBean o) {
                    super.onNext((Object)o);
                    PublishPresenter.this.adapter.add(o);
                    PublishPresenter.this.refreshPublishButton();
                }
            });
        } else {
            if (selectedPathList.size() > 1) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_num));
                return;
            }
            if (FileUtils.getFileSize((String)selectedPathList.get(0)) >= 0x3200000L) {
                this.view.showToast(this.context.getString(R.string.moments_file_max_size));
                return;
            }
            if (this.checkCanAddFile()) {
                this.momentType = 4;
                this.fileBean = FileTypeManager.fileAppendixBean(selectedPathList.get(0));
                this.view.showFileView(true);
                this.view.setFileView(this.fileBean);
                this.refreshPublishButton();
            }
        }
    }

    private void operateFile(String filePath, Observer<AppendixBean> observer) {
        io.reactivex.Observable.just((Object)filePath).map(s -> FileTypeManager.fileAppendixBean(s)).compose(MomentsRxTransformer.momentsComposeIoAndError(this.lifecycleProvider)).subscribe(observer);
    }

    public void deleteDraft() {
        if (this.momentDraft != null) {
            this.publishBusiness.deleteDraft(this.momentDraft);
            this.view.finish();
        } else {
            this.view.finish();
        }
    }
}

