/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.publish.mvp;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.content.Intent;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseObserver;
import com.xdja.baselibrary.base.IBaseView;
import com.xdja.baselibrary.util.ListUtil;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.flow.publish.mvp.GetClassifyDeptModel;
import com.xdja.moments.sdk.flow.publish.mvp.SelectBrowseAuthConstruct;
import com.xdja.moments.sdk.http.bean.request.GetClassifyDeptParam;
import com.xdja.moments.sdk.http.bean.response.ClassifyDeptListResponse;
import com.xdja.moments.sdk.utils.MomentsRxTransformer;
import io.reactivex.Observer;
import java.util.ArrayList;
import java.util.List;

public class SelectBrowseAuthPresenter
implements SelectBrowseAuthConstruct.Presenter {
    private SelectBrowseAuthConstruct.View view;
    private LifecycleProvider lifecycleProvider;
    private GetClassifyDeptModel model;
    private List<ClassifyDeptListResponse> canSelectDeptIds;
    private String classifyId;

    public SelectBrowseAuthPresenter(SelectBrowseAuthConstruct.View view, LifecycleProvider lifecycleProvider) {
        this.view = view;
        this.lifecycleProvider = lifecycleProvider;
        this.model = new GetClassifyDeptModel();
    }

    @Override
    public void getClassifyDeptDat(String classifyId) {
        this.classifyId = classifyId;
        GetClassifyDeptParam param = new GetClassifyDeptParam();
        param.setClassifyId(classifyId);
        this.model.getClassifyDeptList(param).compose(MomentsRxTransformer.momentsComposeNet((LifecycleProvider<Lifecycle.Event>)this.lifecycleProvider, param)).subscribe((Observer)new BaseObserver<List<ClassifyDeptListResponse>>((IBaseView)this.view, "\u52a0\u8f7d\u4e2d..."){

            public void onNext(List<ClassifyDeptListResponse> response) {
                super.onNext(response);
                SelectBrowseAuthPresenter.this.canSelectDeptIds = response;
            }
        });
    }

    @Override
    public void onSelectDeptClick(String browseAuthValue) {
        if (this.canSelectDeptIds != null) {
            Navigation.navigationSelectDeptActivity((Activity)this.view, this.canSelectDeptIds, ListUtil.stringToList((String)browseAuthValue, (String)","));
        } else {
            this.getClassifyDeptDat(this.classifyId);
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        ArrayList deptList;
        if (resultCode == -1 && requestCode == 272 && !ListUtil.isEmpty((List)(deptList = (ArrayList)data.getSerializableExtra("selected_dept_ids")))) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String dept : deptList) {
                stringBuilder.append(dept);
                stringBuilder.append(",");
            }
            this.view.setBrowseValue(stringBuilder.substring(0, stringBuilder.length() - 1));
        }
    }
}

