/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.review;

import android.arch.lifecycle.Lifecycle;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.BaseActivity;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.flow.base.adapter.MomentsPagerAdapter;
import com.xdja.moments.sdk.flow.review.ui.PendingReviewFragment;
import com.xdja.moments.sdk.flow.review.ui.ReviewFailFragment;
import com.xdja.moments.sdk.flow.review.ui.ReviewSuccessFragment;
import com.xdja.moments.sdk.widget.tablayout.MomentsTabLayout;
import java.util.ArrayList;
import java.util.List;

@Route(path="/review/reviewMain")
public class MomentReviewActivity
extends BaseActivity
implements Toolbar.OnMenuItemClickListener {
    private MomentsTabLayout mTabLayout;
    private ViewPager mViewPager;
    private List<String> titleList = new ArrayList<String>();
    private List<Fragment> fragmentList = new ArrayList<Fragment>();
    private PendingReviewFragment pendingReviewFragment;
    private ReviewSuccessFragment reviewSuccessFragment;
    private ReviewFailFragment reviewFailFragment;
    private boolean multiChoose = false;
    private List<OnMultiStatueChangedListener> listenerList = new ArrayList<OnMultiStatueChangedListener>();

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
    }

    protected void initView() {
        this.setMomentsTitle(this.getString(R.string.moments_review_moments));
        this.toolbar.setOnMenuItemClickListener((Toolbar.OnMenuItemClickListener)this);
        this.mTabLayout = (MomentsTabLayout)this.findViewById(R.id.moments_tabLayout);
        this.mViewPager = (ViewPager)this.findViewById(R.id.moments_viewPager);
        this.titleList.add(this.getString(R.string.moments_pending_review));
        this.titleList.add(this.getString(R.string.moments__review_success));
        this.titleList.add(this.getString(R.string.moments__fail));
        this.pendingReviewFragment = new PendingReviewFragment();
        this.reviewSuccessFragment = new ReviewSuccessFragment();
        this.reviewFailFragment = new ReviewFailFragment();
        this.fragmentList.add((Fragment)this.pendingReviewFragment);
        this.fragmentList.add((Fragment)this.reviewSuccessFragment);
        this.fragmentList.add((Fragment)this.reviewFailFragment);
        this.initViewPager();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.moments_menu_review, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    private void initViewPager() {
        this.mTabLayout.setTabMode(1);
        this.mViewPager.setAdapter((PagerAdapter)new MomentsPagerAdapter(this.fragmentList, this.titleList, this.getSupportFragmentManager()));
        this.mTabLayout.setupWithViewPager(this.mViewPager);
        this.mViewPager.setOffscreenPageLimit(3);
    }

    protected int getRootView() {
        return R.layout.moments_activity_moment_review;
    }

    public boolean onMenuItemClick(MenuItem menuItem) {
        if (menuItem.getItemId() == R.id.action_multi_choose) {
            this.multiChoose = !this.multiChoose;
            menuItem.setTitle((CharSequence)(this.multiChoose ? this.getString(R.string.moments_cancel_multi_select) : this.getString(R.string.moments_multi_select)));
            if (this.listenerList != null && this.listenerList.size() > 0) {
                for (OnMultiStatueChangedListener onMultiStatueChangedListener : this.listenerList) {
                    onMultiStatueChangedListener.onMultiStatueChanged(this.multiChoose);
                }
            }
        }
        return false;
    }

    public void setOnMultiStatusChangeListener(OnMultiStatueChangedListener listener) {
        this.listenerList.add(listener);
    }

    public void resetMultiSelect() {
        this.multiChoose = false;
        this.toolbar.getMenu().findItem(R.id.action_multi_choose).setTitle((CharSequence)this.getString(R.string.moments_multi_select));
        if (this.listenerList != null && this.listenerList.size() > 0) {
            for (OnMultiStatueChangedListener onMultiStatueChangedListener : this.listenerList) {
                onMultiStatueChangedListener.onMultiStatueChanged(false);
            }
        }
    }

    public static interface OnMultiStatueChangedListener {
        public void onMultiStatueChanged(boolean var1);
    }
}

