/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.flow.review.ui;

import android.arch.lifecycle.Lifecycle;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.trello.rxlifecycle2.LifecycleProvider;
import com.xdja.baselibrary.base.LoadingType;
import com.xdja.baselibrary.base.bottommenu.BottomMenuBean;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.R;
import com.xdja.moments.sdk.bean.MomentsBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.eventbus.MomentReviewEvent;
import com.xdja.moments.sdk.flow.base.adapter.MomentsListAdapter;
import com.xdja.moments.sdk.flow.base.fragment.BaseMomentListFragment;
import com.xdja.moments.sdk.flow.base.moments.BaseMomentListPresenter;
import com.xdja.moments.sdk.flow.review.MomentReviewActivity;
import com.xdja.moments.sdk.flow.review.mvp.MomentReviewConstruct;
import com.xdja.moments.sdk.flow.review.mvp.MomentReviewPresenter;
import com.xdja.moments.sdk.http.bean.request.MomentReviewParams;
import com.xdja.moments.sdk.http.bean.request.MomentReviewStatusParams;
import com.xdja.moments.sdk.http.bean.response.PraiseResponseBean;
import com.xdja.moments.sdk.manager.MomentsManager;
import com.xdja.moments.sdk.widget.dialog.MomentsReviewDialog;
import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;

public abstract class BaseReviewFragment
extends BaseMomentListFragment
implements MomentReviewActivity.OnMultiStatueChangedListener,
View.OnClickListener,
MomentsListAdapter.OnCheckNumberChangedClickListener,
MomentReviewConstruct.View {
    protected static final int REVIEW_STATUS_PENDING = 1;
    protected static final int REVIEW_STATUS_SUCCESS = 2;
    protected static final int REVIEW_STATUS_FAIL = 3;
    protected TextView tvDeleteOperator;
    protected TextView tvDelete;
    protected TextView tvReview;
    protected View groupReviewAndDelete;
    protected View bottomLine;
    protected List<BottomMenuBean> bottomMenuBeanList = new ArrayList<BottomMenuBean>();
    private MomentReviewPresenter reviewPresenter;
    private Drawable mDrawableDelete;
    private Drawable mDrawableReview;
    private MomentsReviewDialog reviewFailDialog;
    private List<String> reviewOrDeleteList = new ArrayList<String>();
    private long praiseTime;

    @Override
    protected BaseMomentListPresenter getPresenter() {
        return this.reviewPresenter;
    }

    @Override
    protected void initView(View rootView, LayoutInflater inflater) {
        super.initView(rootView, inflater);
        this.groupReviewAndDelete = rootView.findViewById(R.id.group_review_delete);
        this.tvDeleteOperator = (TextView)rootView.findViewById(R.id.tv_delete_operator);
        this.bottomLine = rootView.findViewById(R.id.bottom_line);
        this.tvDelete = (TextView)rootView.findViewById(R.id.tv_delete);
        this.tvReview = (TextView)rootView.findViewById(R.id.tv_review);
        this.tvDeleteOperator.setOnClickListener((View.OnClickListener)this);
        this.tvReview.setOnClickListener((View.OnClickListener)this);
        this.tvDelete.setOnClickListener((View.OnClickListener)this);
        Drawable drawableDelete = this.getResources().getDrawable(R.drawable.moments_icon_delete);
        this.mDrawableDelete = drawableDelete.mutate();
        Drawable drawableReview = this.getResources().getDrawable(R.drawable.moments_icon_review);
        this.mDrawableReview = drawableReview.mutate();
        this.setUpOperatorBar(0);
        this.momentsListAdapter.setOnCheckNumberChangedListener(this);
        this.momentsListAdapter.setIsReview(true);
        ((MomentReviewActivity)this.getActivity()).setOnMultiStatusChangeListener(this);
    }

    protected void initData(LifecycleProvider<Lifecycle.Event> provider) {
        if (this.reviewPresenter == null) {
            this.reviewPresenter = new MomentReviewPresenter(provider, this);
        }
        MomentReviewParams params = new MomentReviewParams();
        params.setTimeStamp(this.pageTimeStamp);
        params.setExtType(String.valueOf(this.getReviewStatue()));
        params.setMomentVerifyStatus(this.getReviewStatue());
        this.reviewPresenter.getMomentsReviewData(params);
    }

    protected abstract int getReviewStatue();

    @Override
    public void onMultiStatueChanged(boolean multiChoose) {
        this.momentsListAdapter.clearCheckedMoments();
        this.momentsListAdapter.setMultiSelectEnable(multiChoose);
        if (this.getReviewStatue() == 1) {
            if (multiChoose) {
                this.bottomLine.setVisibility(0);
                this.groupReviewAndDelete.setVisibility(0);
            } else {
                this.groupReviewAndDelete.setVisibility(8);
                this.bottomLine.setVisibility(8);
            }
        } else if (multiChoose) {
            this.bottomLine.setVisibility(0);
            this.tvDeleteOperator.setVisibility(0);
        } else {
            this.bottomLine.setVisibility(8);
            this.tvDeleteOperator.setVisibility(8);
        }
    }

    public void onClick(View view) {
        this.reviewOrDeleteList.clear();
        this.reviewOrDeleteList.addAll(this.momentsListAdapter.getCheckedMoments());
        if (view.getId() == R.id.tv_delete) {
            this.showDeleteMomentDialog();
        } else if (view.getId() == R.id.tv_review) {
            this.showBottomDialog(false, false);
        } else if (view.getId() == R.id.tv_delete_operator) {
            this.showDeleteMomentDialog();
        }
    }

    private void reviewMoments(String momentsId, int status, String reason) {
        MomentReviewStatusParams params = new MomentReviewStatusParams();
        params.setMomentId(momentsId);
        params.setMomentVerifyStatus(status);
        params.setMomentVerifyContent(reason);
        this.reviewPresenter.updateReviewStatus(params);
    }

    private void setUpOperatorBar(int number) {
        if (number > 0) {
            this.tvDeleteOperator.setEnabled(true);
            this.tvDelete.setEnabled(true);
            this.tvReview.setEnabled(true);
            this.setDrawableEnable(true);
        } else {
            this.tvDeleteOperator.setEnabled(false);
            this.tvDelete.setEnabled(false);
            this.tvReview.setEnabled(false);
            this.setDrawableEnable(false);
        }
        this.tvDeleteOperator.setText((CharSequence)String.format(this.getString(R.string.moments_delete), number));
        this.tvDelete.setText((CharSequence)String.format(this.getString(R.string.moments_delete), number));
        this.tvReview.setText((CharSequence)String.format(this.getString(R.string.moments_review), number));
    }

    protected void onBottomMenuItemClick(BottomMenuBean bottomMenuBean) {
        this.hideBottomMenu();
        if (bottomMenuBean.getItemName().equals(this.getString(R.string.moments__review_success))) {
            this.showReviewSuccessDialog();
        } else if (bottomMenuBean.getItemName().equals(this.getString(R.string.moments__fail))) {
            this.showReviewFailDialog();
        } else if (bottomMenuBean.getItemName().equals(this.getString(R.string.moments__review_delete))) {
            this.showDeleteMomentDialog();
        }
    }

    private void showReviewSuccessDialog() {
        this.showAlertDialog("\u53d6\u6d88", "\u5ba1\u6838\u901a\u8fc7", "\u786e\u5b9a\u5ba1\u6838\u901a\u8fc7\u5de5\u4f5c\u5708\uff1f", new View.OnClickListener(){

            public void onClick(View view) {
                BaseReviewFragment.this.dismissAlertDialog();
            }
        }, new View.OnClickListener(){

            public void onClick(View view) {
                BaseReviewFragment.this.dismissAlertDialog();
                BaseReviewFragment.this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
                BaseReviewFragment.this.reviewMoments(BaseReviewFragment.this.getMomentsIds(BaseReviewFragment.this.reviewOrDeleteList), 2, "");
            }
        });
    }

    private void showDeleteMomentDialog() {
        this.showAlertDialog("\u53d6\u6d88", "\u5220\u9664", "\u786e\u5b9a\u5220\u9664\u52a8\u6001\uff1f", new View.OnClickListener(){

            public void onClick(View view) {
                BaseReviewFragment.this.dismissAlertDialog();
            }
        }, new View.OnClickListener(){

            public void onClick(View view) {
                BaseReviewFragment.this.dismissAlertDialog();
                BaseReviewFragment.this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
                BaseReviewFragment.this.reviewPresenter.deleteMoments(BaseReviewFragment.this.getMomentsIds(BaseReviewFragment.this.reviewOrDeleteList));
            }
        });
    }

    private void showReviewFailDialog() {
        if (this.reviewFailDialog == null) {
            this.reviewFailDialog = new MomentsReviewDialog();
        }
        this.reviewFailDialog.show((Context)this.getActivity(), view -> {
            this.reviewFailDialog.hideKeyBoard(view);
            this.reviewFailDialog.dismiss();
        }, view -> {
            String reviewFailReason = this.reviewFailDialog.getReviewFailReason();
            this.reviewFailDialog.hideKeyBoard(view);
            this.reviewFailDialog.dismiss();
            this.setOnceLoadingType(LoadingType.LOAD_TYPE_DIALOG);
            this.reviewMoments(this.getMomentsIds(this.reviewOrDeleteList), 3, reviewFailReason);
        }, false, false);
    }

    private void showBottomDialog(boolean onlyShowDeleteItem, boolean showDeleteItem) {
        this.bottomMenuBeanList.clear();
        if (onlyShowDeleteItem) {
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_delete, this.getString(R.string.moments__review_delete)));
        } else {
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_review_success, this.getString(R.string.moments__review_success)));
            this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_review_fail, this.getString(R.string.moments__fail)));
            if (showDeleteItem) {
                this.bottomMenuBeanList.add(new BottomMenuBean(R.drawable.moments_icon_delete, this.getString(R.string.moments__review_delete)));
            }
        }
        this.showBottomMenu(this.bottomMenuBeanList);
    }

    private void setDrawableEnable(boolean enable) {
        if (this.getReviewStatue() == 1) {
            this.mDrawableDelete.setAlpha(enable ? 255 : 100);
            this.mDrawableReview.setAlpha(enable ? 255 : 100);
            this.tvDelete.setCompoundDrawablesRelativeWithIntrinsicBounds(this.mDrawableDelete, null, null, null);
            this.tvReview.setCompoundDrawablesRelativeWithIntrinsicBounds(this.mDrawableReview, null, null, null);
        } else {
            this.mDrawableDelete.setAlpha(enable ? 255 : 100);
            this.tvDeleteOperator.setCompoundDrawablesRelativeWithIntrinsicBounds(this.mDrawableDelete, null, null, null);
        }
    }

    @Override
    public void OnCheckNumberChanged(int number) {
        this.setUpOperatorBar(number);
    }

    @Override
    public void onReviewSuccess() {
        this.pageTimeStamp = 0L;
        ((MomentReviewActivity)this.getActivity()).resetMultiSelect();
        this.initData((LifecycleProvider<Lifecycle.Event>)this.provider);
        this.momentsListAdapter.setMultiSelectEnable(false);
        EventBus.getDefault().post((Object)new MomentReviewEvent());
    }

    @Override
    public void hideLoading(String key) {
        if (key.equals("momentInfo/deleteMomentInfo") || key.equals("momentVerify/updateMomentInfoVerifyStatus")) {
            return;
        }
        super.hideLoading(key);
    }

    @Override
    public void onDeleteMomentsSuccess() {
        this.pageTimeStamp = 0L;
        ((MomentReviewActivity)this.getActivity()).resetMultiSelect();
        this.initData((LifecycleProvider<Lifecycle.Event>)this.provider);
        this.momentsListAdapter.setMultiSelectEnable(false);
    }

    @Override
    public void onMoreArrowClick(MomentsBean data) {
        super.onMoreArrowClick(data);
        this.reviewOrDeleteList.clear();
        this.reviewOrDeleteList.add(data.getMomentId());
        if (this.getReviewStatue() == 1) {
            this.showBottomDialog(false, true);
        } else {
            this.showBottomDialog(true, true);
        }
    }

    private String getMomentsIds(List<String> momentsBeanList) {
        return TextUtils.join((CharSequence)",", momentsBeanList);
    }

    @Override
    public void onPraiseClick(MomentsBean data) {
        this.praiseTime = System.currentTimeMillis();
        this.setOnceLoadingType(LoadingType.LOAD_TYPE_NONE);
        this.reviewPresenter.praiseMoments(data.getMomentId(), "1".equals(data.getPraiseFlag()) ? "2" : "1");
    }

    @Override
    public void onPraiseSuccess(PraiseResponseBean praiseResponseBean) {
        for (MomentsBean momentsBean : this.momentsBeanList) {
            if (!momentsBean.getMomentId().equals(praiseResponseBean.getMomentId())) continue;
            momentsBean.setPraiseFlag(praiseResponseBean.getPraiseFlag());
            if ("1".equals(praiseResponseBean.getPraiseFlag())) {
                momentsBean.setPraiseCount(momentsBean.getPraiseCount() + 1);
            } else {
                momentsBean.setPraiseCount(momentsBean.getPraiseCount() - 1);
            }
            for (UserInfoBean userInfoBean : momentsBean.getPraiseList()) {
                if (!userInfoBean.getUserId().equals(MomentsManager.getInstance().getLoginer().getUserId())) continue;
                momentsBean.getPraiseList().remove(userInfoBean);
                break;
            }
            if (!"1".equals(praiseResponseBean.getPraiseFlag())) continue;
            momentsBean.getPraiseList().add(MomentsManager.getInstance().getLoginer());
        }
        long underGo = System.currentTimeMillis() - this.praiseTime - 600L;
        if (underGo > 0L) {
            this.momentsListAdapter.notifyDataSetChanged();
        } else {
            Disposable disposable = Observable.create(emitter -> emitter.onNext(new Object())).delay(Math.abs(underGo), TimeUnit.MILLISECONDS).compose(ObservableTransfor.io_main()).compose((ObservableTransformer)this.provider.bindUntilEvent((Object)Lifecycle.Event.ON_DESTROY)).subscribe(o -> this.momentsListAdapter.notifyDataSetChanged());
        }
    }
}

