/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.http.download;

import android.os.Handler;
import android.os.Looper;
import com.xdja.baselibrary.base.BaseParams;
import com.xdja.baselibrary.constant.ConstantUrl;
import com.xdja.moments.sdk.database.domain.DownInfo;
import com.xdja.moments.sdk.http.download.DownLoadListener.DownloadInterceptor;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.http.download.HttpDownApi;
import com.xdja.moments.sdk.http.download.ProgressDownSubscriber;
import com.xdja.moments.sdk.repository.DownInfoRepository;
import com.xdja.moments.sdk.utils.MomentsRetryWithTime;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class HttpDownManager {
    private Set<DownInfo> downInfos = new HashSet<DownInfo>();
    private HashMap<String, ProgressDownSubscriber> subMap = new HashMap();
    private static volatile HttpDownManager INSTANCE;
    private DownInfoRepository repository = DownInfoRepository.getInstance();
    private Handler handler = new Handler(Looper.getMainLooper());

    private HttpDownManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpDownManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<HttpDownManager> clazz = HttpDownManager.class;
        synchronized (HttpDownManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new HttpDownManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void startDown(final DownInfo info) {
        HttpDownApi httpService;
        if (info == null || this.subMap.get(info.getUrl()) != null) {
            this.subMap.get(info.getUrl()).setDownInfo(info);
            return;
        }
        ProgressDownSubscriber subscriber = new ProgressDownSubscriber(info, this.handler);
        this.subMap.put(info.getUrl(), subscriber);
        if (this.downInfos.contains(info)) {
            httpService = info.getService();
        } else {
            DownloadInterceptor interceptor = new DownloadInterceptor(subscriber);
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            builder.connectTimeout((long)info.getConnectionTime(), TimeUnit.SECONDS);
            builder.addInterceptor((Interceptor)interceptor);
            Retrofit retrofit = new Retrofit.Builder().client(builder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).baseUrl(ConstantUrl.getFastdfsUrl()).build();
            httpService = (HttpDownApi)retrofit.create(HttpDownApi.class);
            info.setService(httpService);
            this.downInfos.add(info);
        }
        httpService.download("bytes=" + info.getReadLength() + "-", info.getUrl()).subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io()).retryWhen((Function)new MomentsRetryWithTime(new BaseParams(), 3, 2000)).map((Function)new Function<ResponseBody, DownInfo>(){

            public DownInfo apply(ResponseBody responseBody) throws Exception {
                HttpDownManager.this.writeCaches(responseBody, new File(info.getSavePath()), info);
                return info;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    public void stopDown(DownInfo info) {
        if (info == null) {
            return;
        }
        info.setState(DownState.STOP);
        info.getListener().onStop();
        if (this.subMap.containsKey(info.getUrl())) {
            ProgressDownSubscriber subscriber = this.subMap.get(info.getUrl());
            subscriber.unSubscribe();
            this.subMap.remove(info.getUrl());
        }
        this.repository.insert(info).subscribe();
    }

    public void pause(DownInfo info) {
        if (info == null) {
            return;
        }
        info.setState(DownState.PAUSE);
        info.getListener().onPause();
        if (this.subMap.containsKey(info.getUrl())) {
            ProgressDownSubscriber subscriber = this.subMap.get(info.getUrl());
            subscriber.unSubscribe();
            this.subMap.remove(info.getUrl());
        }
        this.repository.update(info).subscribe();
    }

    public void stopAllDown() {
        for (DownInfo downInfo : this.downInfos) {
            this.stopDown(downInfo);
        }
        this.subMap.clear();
        this.downInfos.clear();
    }

    public void pauseAll() {
        for (DownInfo downInfo : this.downInfos) {
            this.pause(downInfo);
        }
        this.subMap.clear();
        this.downInfos.clear();
    }

    public Set<DownInfo> getDownInfos() {
        return this.downInfos;
    }

    public void remove(DownInfo info) {
        this.subMap.remove(info.getUrl());
        this.downInfos.remove(info);
    }

    public void writeCaches(ResponseBody responseBody, File file, DownInfo info) throws IOException {
        RandomAccessFile randomAccessFile = null;
        AbstractInterruptibleChannel channelOut = null;
        InputStream inputStream = null;
        try {
            int len;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            long allLength = 0L == info.getCountLength() ? responseBody.contentLength() : info.getReadLength() + responseBody.contentLength();
            inputStream = responseBody.byteStream();
            randomAccessFile = new RandomAccessFile(file, "rwd");
            channelOut = randomAccessFile.getChannel();
            MappedByteBuffer mappedBuffer = ((FileChannel)channelOut).map(FileChannel.MapMode.READ_WRITE, info.getReadLength(), allLength - info.getReadLength());
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer)) != -1) {
                mappedBuffer.put(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (channelOut != null) {
                channelOut.close();
            }
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }
}

