/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.http.download;

import android.os.Handler;
import com.xdja.baselibrary.exception.ExceptionEngine;
import com.xdja.moments.sdk.database.domain.DownInfo;
import com.xdja.moments.sdk.http.download.DownLoadListener.DownloadProgressListener;
import com.xdja.moments.sdk.http.download.DownLoadListener.HttpDownOnNextListener;
import com.xdja.moments.sdk.http.download.DownState;
import com.xdja.moments.sdk.http.download.HttpDownManager;
import com.xdja.moments.sdk.repository.DownInfoRepository;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import java.lang.ref.SoftReference;

public class ProgressDownSubscriber<T>
implements DownloadProgressListener,
Observer<T> {
    private SoftReference<HttpDownOnNextListener> mSubscriberOnNextListener;
    private DownInfo downInfo;
    private Handler handler;
    private Disposable disposable;

    public ProgressDownSubscriber(DownInfo downInfo, Handler handler) {
        this.mSubscriberOnNextListener = new SoftReference<HttpDownOnNextListener>(downInfo.getListener());
        this.downInfo = downInfo;
        this.handler = handler;
    }

    public void setDownInfo(DownInfo downInfo) {
        this.mSubscriberOnNextListener = new SoftReference<HttpDownOnNextListener>(downInfo.getListener());
        this.downInfo = downInfo;
    }

    public void onSubscribe(Disposable d) {
        this.downInfo.setState(DownState.START);
        if (this.mSubscriberOnNextListener.get() != null) {
            this.mSubscriberOnNextListener.get().onStart();
        }
        this.disposable = d;
    }

    public void onComplete() {
        this.downInfo.setState(DownState.FINISH);
        if (this.mSubscriberOnNextListener.get() != null) {
            this.mSubscriberOnNextListener.get().onComplete();
        }
        HttpDownManager.getInstance().remove(this.downInfo);
        DownInfoRepository.getInstance().delete(this.downInfo).subscribe();
    }

    public void onError(Throwable e) {
        this.downInfo.setState(DownState.ERROR);
        if (this.mSubscriberOnNextListener.get() != null) {
            this.mSubscriberOnNextListener.get().onError((Throwable)ExceptionEngine.handleException((Throwable)e));
        }
        HttpDownManager.getInstance().remove(this.downInfo);
        DownInfoRepository.getInstance().update(this.downInfo).subscribe();
    }

    public void onNext(T t) {
        if (this.mSubscriberOnNextListener.get() != null) {
            this.mSubscriberOnNextListener.get().onNext(t);
        }
    }

    @Override
    public void update(long read, long count, boolean done) {
        if (this.downInfo.getCountLength() > count) {
            read = this.downInfo.getCountLength() - count + read;
        } else {
            this.downInfo.setCountLength(count);
        }
        this.downInfo.setReadLength(read);
        if (this.mSubscriberOnNextListener.get() == null || !this.downInfo.isUpdateProgress()) {
            return;
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                if (ProgressDownSubscriber.this.downInfo.getState() == DownState.PAUSE || ProgressDownSubscriber.this.downInfo.getState() == DownState.STOP) {
                    return;
                }
                ProgressDownSubscriber.this.downInfo.setState(DownState.DOWN);
                ((HttpDownOnNextListener)ProgressDownSubscriber.this.mSubscriberOnNextListener.get()).updateProgress(ProgressDownSubscriber.this.downInfo.getReadLength(), ProgressDownSubscriber.this.downInfo.getCountLength());
            }
        });
    }

    public void unSubscribe() {
        this.disposable.dispose();
    }
}

