/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.http.upload;

import android.text.TextUtils;
import com.orhanobut.logger.Logger;
import com.xdja.moments.sdk.bean.fastDfs.UploadFastDfsParameter;
import com.xdja.moments.sdk.bean.fastDfs.UploadResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;

public class FastDfsFileUpload {
    private File targetFile;
    private UploadFastDfsParameter sup;
    private static final int MIN_READ_UNIT = 10240;
    private int FIXED_READ_UNIT = 10240;
    private boolean isStop = false;
    private static OkHttpClient mHttpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();

    public FastDfsFileUpload(UploadFastDfsParameter sup) {
        this.sup = sup;
        this.calculationReadUnit(Long.parseLong(sup.getFileSize()));
    }

    private Request.Builder getRequest(UploadFastDfsParameter sup) {
        Request.Builder builder;
        try {
            builder = new Request.Builder().url(sup.getUrl()).addHeader("filename", URLEncoder.encode(sup.getFileName(), "utf-8")).addHeader("filesize", sup.getFileSize()).addHeader("Content-Type", "application/octet-stream");
            if (!TextUtils.isEmpty((CharSequence)sup.getFileId())) {
                builder.addHeader("fileid", sup.getFileId());
            }
            if (!TextUtils.isEmpty((CharSequence)sup.getPerm())) {
                builder.addHeader("perm", sup.getPerm());
            }
            if (!TextUtils.isEmpty((CharSequence)sup.getExpires())) {
                builder.addHeader("expires", sup.getExpires());
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        return builder;
    }

    public String execute() throws Exception {
        String url;
        if (!TextUtils.isEmpty((CharSequence)this.sup.getFilePath())) {
            this.targetFile = new File(this.sup.getFilePath());
            if (!this.targetFile.exists()) {
                throw new NoSuchFieldException();
            }
        }
        if (TextUtils.isEmpty((CharSequence)(url = this.sup.getUrl()))) {
            throw new IllegalArgumentException("url \u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileInputStream fis = null;
        try {
            int length;
            fis = new FileInputStream(this.targetFile);
            byte[] bytes = new byte[this.FIXED_READ_UNIT];
            int total = 0;
            while ((length = fis.read(bytes)) != -1) {
                if (this.isStop) continue;
                total += length;
                boolean success = this.doUpload(bytes = this.subBytes(bytes, 0, length), this.sup);
                if (!success) {
                    throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25");
                }
                Logger.i((String)("upload size:" + total + "/" + this.targetFile.length()), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return this.sup.getFileId();
    }

    private byte[] subBytes(byte[] src, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(src, begin, bs, 0, count);
        return bs;
    }

    private boolean doUpload(byte[] datas, UploadFastDfsParameter sup) throws Exception {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (byte[])datas);
        Request request = this.getRequest(sup).post(requestBody).build();
        try {
            Response response = mHttpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                Logger.i((String)("response code:" + response.code()), (Object[])new Object[0]);
                return false;
            }
            UploadResponse uploadResponse = this.readResponse(response.body());
            if (uploadResponse.getFileid() != null) {
                sup.setFileId(uploadResponse.getFileid());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    private UploadResponse readResponse(ResponseBody body) throws Exception {
        if (body != null) {
            UploadResponse uploadResponse = new UploadResponse();
            try {
                String result = body.string();
                JSONObject object = new JSONObject(result);
                if (object.has("fileid")) {
                    uploadResponse.setFileid(object.getString("fileid"));
                }
                if (object.has("size")) {
                    uploadResponse.setSize(object.getLong("size"));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                throw e;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            return uploadResponse;
        }
        return null;
    }

    private void calculationReadUnit(long fileSize) {
        int tempUnit = (int)(fileSize / 15L);
        this.FIXED_READ_UNIT = tempUnit < 10240 ? 10240 : tempUnit;
    }
}

