/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.manager;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.android.arouter.launcher.ARouter;
import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.LogAdapter;
import com.orhanobut.logger.LogStrategy;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.PrettyFormatStrategy;
import com.xdja.baselibrary.base.OnToolBarTap;
import com.xdja.baselibrary.constant.ConstantUrl;
import com.xdja.baselibrary.constant.MomentsConstants;
import com.xdja.moments.sdk.Navigation;
import com.xdja.moments.sdk.bean.LoginUserInfo;
import com.xdja.moments.sdk.bean.location.MomentsLocationHelper;
import com.xdja.moments.sdk.database.domain.MomentNotification;
import com.xdja.moments.sdk.database.domain.MomentsClassify;
import com.xdja.moments.sdk.flow.init.business.impl.MomentInitServiceImpl;
import com.xdja.moments.sdk.http.bean.request.LoginParams;
import com.xdja.moments.sdk.http.bean.response.ClassifyDeptListResponse;
import com.xdja.moments.sdk.manager.FaceManager;
import com.xdja.moments.sdk.manager.data.MomentsDataManager;
import com.xdja.moments.sdk.manager.data.listener.query.QueryDataListener;
import com.xdja.moments.sdk.manager.data.listener.select.BuildSelectIntentListener;
import com.xdja.moments.sdk.manager.location.MomentsLocationManager;
import com.xdja.moments.sdk.manager.notification.MomentsNotificationManager;
import com.xdja.moments.sdk.manager.share.MomentShareToListener;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.List;
import org.greenrobot.eventbus.EventBus;

public class MomentsManager {
    private static MomentsManager mInstance;
    private Context context;
    private Application application;
    private boolean enableLog = true;
    private boolean customHeader = false;
    private boolean customFooter = false;
    private BuildSelectIntentListener buildIntentListener;
    private MomentShareToListener shareToListener;
    private MomentsLocationHelper locationHelper;
    private boolean hasInitLoginer;
    private boolean hasInit;
    private LoginUserInfo userInfo;

    private MomentsManager() {
    }

    public static synchronized MomentsManager getInstance() {
        if (null == mInstance) {
            mInstance = new MomentsManager();
        }
        return mInstance;
    }

    public MomentsManager with(Application application) {
        this.context = application.getApplicationContext();
        this.application = application;
        return mInstance;
    }

    public MomentsManager momentsAddress(String host, String port) {
        ConstantUrl.MOMENTS_HOST = host;
        ConstantUrl.MOMENTS_PORT = port;
        return mInstance;
    }

    public MomentsManager fastDfsAddress(String host, String port, String userId, String userSecret) {
        ConstantUrl.FASTDFS_HOST = host;
        ConstantUrl.FASTDFS__PORT = port;
        ConstantUrl.FASTDFS_USER_ID = userId;
        ConstantUrl.FASTDFS_USER_SECRET = userSecret;
        return mInstance;
    }

    public void build() {
        this.initLogger();
        this.checkParams();
        this.initArouter();
        this.hasInit = true;
        Log.d((String)"momentSdk", (String)"\u521d\u59cb\u5316SDK\u6210\u529f");
    }

    public void StartMomentPage() {
        Navigation.navigationMomentsMain();
    }

    public MomentsManager enableLog(boolean enable) {
        this.enableLog = enable;
        return mInstance;
    }

    public FaceManager getFaceManager() {
        return FaceManager.getInstance();
    }

    public MomentsManager addShareToListener(MomentShareToListener momentShareToListener) {
        this.shareToListener = momentShareToListener;
        return this;
    }

    public MomentShareToListener getShareToListener() {
        return this.shareToListener;
    }

    public MomentsManager registerIntentListener(BuildSelectIntentListener listener) {
        this.buildIntentListener = listener;
        return this;
    }

    public MomentsManager registerQueryDataListener(QueryDataListener listener) {
        MomentsDataManager.getInstance().addOnQueryDataListener(listener);
        return this;
    }

    public MomentsManager registerLocationHelper(MomentsLocationHelper helper) {
        MomentsLocationManager.getInstance().setLocationHelper(helper);
        return this;
    }

    public Intent getWebDetailIntent(String url, String title) {
        if (this.buildIntentListener != null) {
            return this.buildIntentListener.onBuildWebDetailIntent(url, title);
        }
        return null;
    }

    public Intent getLocationDetailIntent(String address, String addressDetail, double longitude, double latitude, String cityCode) {
        if (this.buildIntentListener != null) {
            return this.buildIntentListener.onBuildLocationDetailIntent(address, addressDetail, longitude, latitude, cityCode);
        }
        return null;
    }

    public Intent getLocationIntent(String address, String addressDetail, double longitude, double latitude, String cityCode) {
        if (this.buildIntentListener != null) {
            return this.buildIntentListener.onBuildLocationIntent(address, addressDetail, longitude, latitude, cityCode);
        }
        return null;
    }

    public Intent getPersonDetailIntent(String userId) {
        if (this.buildIntentListener != null) {
            return this.buildIntentListener.onBuildPersonDetailIntent(userId);
        }
        throw new IllegalStateException("BuildIntentListener \u672a\u5b9e\u73b0\nMomentsManager.registerIntentListener()\u65b9\u6cd5");
    }

    public Intent getSelectDeptIntent(int maxSelect, List<ClassifyDeptListResponse> deptIds, List<String> hasChoosed) {
        if (this.buildIntentListener != null) {
            return this.buildIntentListener.onBuildSelectDeptsIntent(maxSelect, deptIds, hasChoosed);
        }
        throw new IllegalStateException("BuildIntentListener \u672a\u5b9e\u73b0\nMomentsManager.registerIntentListener()\u65b9\u6cd5");
    }

    public Intent getSelectIntent(int type, int maxSelect, List<String> hasChoosed) {
        Intent intent;
        if (this.buildIntentListener == null) {
            return null;
        }
        switch (type) {
            case 0: {
                intent = this.buildIntentListener.onBuildSelectPersonsIntent(maxSelect, hasChoosed);
                break;
            }
            case 2: {
                intent = this.buildIntentListener.onBuildSelectPhotosIntent(maxSelect, hasChoosed);
                break;
            }
            case 4: {
                intent = this.buildIntentListener.onBuildSelectVideosIntent(maxSelect, hasChoosed);
                break;
            }
            case 5: {
                intent = this.buildIntentListener.onBuildSelectFilesIntent(maxSelect, hasChoosed);
                break;
            }
            case 3: {
                intent = this.buildIntentListener.onBuildTakeVideoIntent();
                break;
            }
            default: {
                throw new IllegalStateException("\u672a\u77e5\u7684intent type");
            }
        }
        return intent;
    }

    public MomentsManager titleGravity(int titleGravity) {
        MomentsConstants.TITLE_GRAVITY = titleGravity;
        return mInstance;
    }

    public MomentsManager setLoginer(LoginUserInfo userInfo) {
        this.userInfo = userInfo;
        Disposable subscribe = new MomentInitServiceImpl().init(this.getLoginParams()).subscribe((Consumer)new Consumer<List<MomentsClassify>>(){

            public void accept(List<MomentsClassify> momentsClassifies) throws Exception {
                Logger.d((Object)"\u767b\u5f55\u6210\u529f");
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                Logger.d((Object)throwable.getMessage());
            }
        });
        this.hasInitLoginer = true;
        return mInstance;
    }

    public MomentsManager customHeaderOrFooter(boolean header, boolean footer) {
        this.customHeader = header;
        this.customFooter = footer;
        return mInstance;
    }

    public boolean isCustomHeader() {
        return this.customHeader;
    }

    public boolean isCustomFooter() {
        return this.customFooter;
    }

    public void onToolBarDoubleTap() {
        EventBus.getDefault().post((Object)new OnToolBarTap());
    }

    public void updateLoginer(LoginUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public LoginUserInfo getLoginer() {
        if (this.userInfo == null) {
            throw new IllegalStateException("\u545c\u547c\uff0c\u521d\u59cb\u5316\u5931\u8d25\n\u8bf7\u5728\u4f7f\u7528\u524d\u8c03\u7528setLoginer\u8bbe\u7f6e\u7528\u6237\u4fe1\u606f");
        }
        return this.userInfo;
    }

    public LoginParams getLoginParams() {
        LoginParams loginParams = new LoginParams();
        loginParams.setUserId(this.userInfo.getUserId());
        loginParams.setUserDeptId(this.userInfo.getDeptId());
        loginParams.setUserOrgId(this.userInfo.getOrgId());
        loginParams.setUserTenantId(this.userInfo.getUserTenantId());
        loginParams.setUserFullDeptId(this.userInfo.getUserFullDeptId());
        loginParams.setUserContactTenantId(this.userInfo.getUserContactTenantId());
        return loginParams;
    }

    public void addMomentNofication(MomentNotification notification) {
        MomentsNotificationManager.getInstance().addMomentNotification(notification);
    }

    public Context getContext() {
        return this.context;
    }

    private void initArouter() {
        if (this.enableLog) {
            ARouter.openLog();
            ARouter.openDebug();
        }
        ARouter.init((Application)this.application);
    }

    private void initLogger() {
        if (!this.enableLog) {
            return;
        }
        LogStrategy logStrategy = new LogStrategy(){
            private String[] prefix = new String[]{". ", " ."};
            private int index = 0;

            public void log(int priority, @Nullable String tag, @NonNull String message) {
                this.index ^= 1;
                Log.println((int)priority, (String)(this.prefix[this.index] + tag), (String)message);
            }
        };
        PrettyFormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder().logStrategy(logStrategy).tag("Moments").showThreadInfo(true).methodCount(1).methodOffset(7).build();
        Logger.addLogAdapter((LogAdapter)new AndroidLogAdapter((FormatStrategy)formatStrategy));
    }

    private void checkParams() {
        if (TextUtils.isEmpty((CharSequence)ConstantUrl.MOMENTS_PORT) || TextUtils.isEmpty((CharSequence)ConstantUrl.MOMENTS_HOST)) {
            throw new IllegalArgumentException("\u545c\u547c\uff0c\u521d\u59cb\u5316\u5931\u8d25\n\u8bf7\u8c03\u7528address()\u8bbe\u7f6e\u670d\u52a1\u5730\u5740");
        }
        if (TextUtils.isEmpty((CharSequence)ConstantUrl.FASTDFS_HOST) || TextUtils.isEmpty((CharSequence)ConstantUrl.FASTDFS__PORT)) {
            throw new IllegalArgumentException("\u545c\u547c\uff0c\u521d\u59cb\u5316\u5931\u8d25\n\u8bf7\u8c03\u7528fastDfsAddress()\u8bbe\u7f6e\u6587\u4ef6\u670d\u52a1\u5730\u5740");
        }
        if (this.context == null) {
            throw new IllegalArgumentException("\u545c\u547c\uff0c\u521d\u59cb\u5316\u5931\u8d25\n\u8bf7\u8c03\u7528with()\u8bbe\u7f6eContext");
        }
    }

    public boolean isHasInitLoginer() {
        return this.hasInitLoginer;
    }

    public boolean isHasInit() {
        return this.hasInit;
    }
}

