/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.moments.sdk.manager.data;

import android.support.annotation.WorkerThread;
import com.xdja.baselibrary.rx.ObservableTransfor;
import com.xdja.moments.sdk.bean.DeptInfoBean;
import com.xdja.moments.sdk.bean.UserInfoBean;
import com.xdja.moments.sdk.manager.data.listener.query.QueryDataListener;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.util.List;

public class MomentsDataManager {
    private static MomentsDataManager mInstance;
    private QueryDataListener queryDataListener;

    private MomentsDataManager() {
    }

    public static synchronized MomentsDataManager getInstance() {
        if (null == mInstance) {
            mInstance = new MomentsDataManager();
        }
        return mInstance;
    }

    public void addOnQueryDataListener(QueryDataListener listener) {
        this.queryDataListener = listener;
    }

    public UserInfoBean queryUserInfo(String userId) {
        this.checkDataListener();
        return null == this.queryDataListener.getUserInfo(userId) ? new UserInfoBean() : this.queryDataListener.getUserInfo(userId);
    }

    public Observable<UserInfoBean> queryObservableUserInfo(final String userId) {
        this.checkDataListener();
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<UserInfoBean>(){

            public void subscribe(ObservableEmitter<UserInfoBean> emitter) throws Exception {
                emitter.onNext((Object)MomentsDataManager.this.queryUserInfo(userId));
                emitter.onComplete();
            }
        }).compose(ObservableTransfor.io_main());
    }

    public List<UserInfoBean> queryUserList(List<String> userIds) {
        this.checkDataListener();
        return this.queryDataListener.getUserList(userIds);
    }

    @WorkerThread
    public DeptInfoBean queryDeptInfo(String deptId) {
        this.checkDataListener();
        return this.queryDataListener.getDeptInfo(deptId);
    }

    public List<DeptInfoBean> queryDeptList(List<String> deptIds) {
        this.checkDataListener();
        return this.queryDataListener.getDeptList(deptIds);
    }

    private boolean checkDataListener() {
        if (this.queryDataListener == null) {
            throw new IllegalStateException("QueryDataListener \u672a\u5b9e\u73b0\n\u8bf7\u8c03\u7528DataManager.addOnQueryDataListener()\u65b9\u6cd5");
        }
        return true;
    }
}

